/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.DataItem$;
import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.Tag;
import io.bullet.borer.encodings.BaseEncoding;
import io.bullet.borer.encodings.BaseEncoding$;
import java.math.BigInteger;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scalus.builtin.ByteString$;
import scalus.builtin.Data;
import scalus.builtin.Data$B$;
import scalus.builtin.Data$Constr$;
import scalus.builtin.Data$I$;
import scalus.builtin.Data$List$;
import scalus.builtin.Data$Map$;

public final class PlutusDataCborDecoder$
implements Decoder<Data> {
    public static final PlutusDataCborDecoder$ MODULE$ = new PlutusDataCborDecoder$();

    private PlutusDataCborDecoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlutusDataCborDecoder$.class);
    }

    public Data read(InputReader<? extends Reader.Config> r) {
        Data data;
        PlutusDataCborDecoder$ selfDecoder = this;
        int maxCborByteArraySize = 64;
        int n = r.dataItem();
        switch (n) {
            case 8: 
            case 16: 
            case 32: {
                data = Data$I$.MODULE$.apply((BigInt)Decoder$.MODULE$.forBigInt().read(r));
                break;
            }
            case 262144: {
                data = Data$Map$.MODULE$.apply((List<Tuple2<Data, Data>>)((List)this.readMap(selfDecoder, selfDecoder).read(r)));
                break;
            }
            case 65536: 
            case 131072: {
                data = Data$List$.MODULE$.apply((List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                break;
            }
            case 16384: {
                data = Data$B$.MODULE$.apply(ByteString$.MODULE$.unsafeFromArray((byte[])Decoder$.MODULE$.forByteArray((BaseEncoding)BaseEncoding$.MODULE$.base16()).read(r)));
                break;
            }
            case 32768: {
                r.readBytesStart();
                data = Data$B$.MODULE$.apply(ByteString$.MODULE$.unsafeFromArray(this.readChunks$1(r)));
                break;
            }
            case 0x200000: {
                Tag tag = r.readTag();
                if (tag instanceof Tag.Other) {
                    Tag.Other other = Tag.Other$.MODULE$.unapply((Tag.Other)tag);
                    long l = other._1();
                    if (102L == l) {
                        long l2 = r.readArrayHeader();
                        long i = r.readLong();
                        Object[] args = (Data[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r);
                        data = Data$Constr$.MODULE$.apply(i, (List<Data>)Predef$.MODULE$.wrapRefArray(args).toList());
                        break;
                    }
                    long value = l;
                    if (121L <= value && value < 128L) {
                        data = Data$Constr$.MODULE$.apply(value - 121L, (List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                        break;
                    }
                    long value2 = l;
                    if (1280L <= value2 && value2 < 1401L) {
                        data = Data$Constr$.MODULE$.apply(value2 - 1280L + 7L, (List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                        break;
                    }
                }
                if (Tag.PositiveBigNum$.MODULE$.equals(tag)) {
                    data = Data$I$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(this.fromByteArray$1(r, maxCborByteArraySize)));
                    break;
                }
                if (Tag.NegativeBigNum$.MODULE$.equals(tag)) {
                    data = Data$I$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(this.fromByteArray$1(r, maxCborByteArraySize).not()));
                    break;
                }
                throw package$.MODULE$.error("Unsupported");
            }
            default: {
                int i = n;
                throw package$.MODULE$.error(new StringBuilder(23).append("Unsupported data item ").append(i).append(" ").append(DataItem$.MODULE$.stringify(i)).toString());
            }
        }
        return data;
    }

    public <A, B> Decoder<List<Tuple2<A, B>>> readMap(Decoder<A> evidence$1, Decoder<B> evidence$2) {
        Decoder decoder$proxy1 = r -> {
            if (r.hasMapHeader()) {
                long size = r.readMapHeader();
                if (size <= Integer.MAX_VALUE) {
                    return this.rec$1(r, evidence$1, evidence$2, (int)size, ListBuffer$.MODULE$.empty()).toList();
                }
                throw r.overflow(new StringBuilder(50).append("Cannot deserialize Map with size ").append(size).append(" (> Int.MaxValue)").toString());
            }
            if (r.hasMapStart()) {
                r.readMapStart();
                return this.rec$2(r, evidence$1, evidence$2, ListBuffer$.MODULE$.empty()).toList();
            }
            throw r.unexpectedDataItem("Map");
        };
        return decoder$proxy1;
    }

    private final BigInteger fromByteArray$1(InputReader r$1, int maxCborByteArraySize$1) {
        byte[] byteArray = r$1.readByteArray();
        if (byteArray.length > maxCborByteArraySize$1) {
            throw r$1.overflow(new StringBuilder(78).append("ByteArray for decoding JBigInteger is longer than the configured max of ").append(maxCborByteArraySize$1).append(" bytes").toString());
        }
        return new BigInteger(1, byteArray);
    }

    private final byte[] readChunks$1(InputReader r$2) {
        ArrayBuffer acc = new ArrayBuffer(64);
        while (!r$2.tryReadBreak()) {
            byte[] bytes = (byte[])r$2.readBytes((ByteAccess)ByteAccess.ForByteArray$.MODULE$);
            if (bytes.length > 64) {
                throw r$2.overflow("ByteString chunk is not 64 bytes");
            }
            acc.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(bytes));
        }
        return (byte[])acc.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    private final ListBuffer rec$1(InputReader r$3, Decoder evidence$1$2, Decoder evidence$2$2, int remaining, ListBuffer map) {
        while (remaining > 0) {
            InputReader InputReader_this;
            InputReader InputReader_this2;
            int n = remaining - 1;
            InputReader InputReader_this3 = InputReader_this2 = r$3;
            InputReader InputReader_this4 = InputReader_this = r$3;
            ListBuffer listBuffer = (ListBuffer)map.append((Object)Tuple2$.MODULE$.apply(evidence$1$2.read(InputReader_this3), evidence$2$2.read(InputReader_this4)));
            remaining = n;
            map = listBuffer;
        }
        return map;
    }

    private final ListBuffer rec$2(InputReader r$4, Decoder evidence$1$4, Decoder evidence$2$4, ListBuffer map) {
        while (!r$4.tryReadBreak()) {
            InputReader InputReader_this;
            InputReader InputReader_this2;
            InputReader InputReader_this3 = InputReader_this2 = r$4;
            InputReader InputReader_this4 = InputReader_this = r$4;
            map = (ListBuffer)map.append((Object)Tuple2$.MODULE$.apply(evidence$1$4.read(InputReader_this3), evidence$2$4.read(InputReader_this4)));
        }
        return map;
    }
}

