/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import io.bullet.borer.Cbor$;
import io.bullet.borer.Encoder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.Data;
import scalus.builtin.Data$B$;
import scalus.builtin.Data$Constr$;
import scalus.builtin.Data$I$;
import scalus.builtin.Data$List$;
import scalus.builtin.Data$Map$;
import scalus.builtin.DataCbor$package$dataCborEncoder$;
import scalus.builtin.List;
import scalus.builtin.List$;
import scalus.builtin.Pair;
import scalus.builtin.Pair$;
import scalus.builtin.PlatformSpecific;

public final class Builtins$
implements Serializable {
    public static final Builtins$ MODULE$ = new Builtins$();

    private Builtins$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Builtins$.class);
    }

    public BigInt addInteger(BigInt i1, BigInt i2) {
        return i1.$plus(i2);
    }

    public BigInt subtractInteger(BigInt i1, BigInt i2) {
        return i1.$minus(i2);
    }

    public BigInt multiplyInteger(BigInt i1, BigInt i2) {
        return i1.$times(i2);
    }

    public BigInt divideInteger(BigInt i1, BigInt i2) {
        BigInteger r = new BigDecimal(i1.bigInteger()).divide(new BigDecimal(i2.bigInteger()), RoundingMode.FLOOR).toBigInteger();
        return scala.package$.MODULE$.BigInt().apply(r);
    }

    public BigInt quotientInteger(BigInt i1, BigInt i2) {
        return i1.$div(i2);
    }

    public BigInt remainderInteger(BigInt i1, BigInt i2) {
        return i1.$percent(i2);
    }

    public BigInt modInteger(BigInt i1, BigInt i2) {
        BigInt r = i1.$percent(i2);
        if (r.signum() == -i2.signum()) {
            return r.$plus(i2);
        }
        return r;
    }

    public boolean equalsInteger(BigInt i1, BigInt i2) {
        return BoxesRunTime.equals((Object)i1, (Object)i2);
    }

    public boolean lessThanInteger(BigInt i1, BigInt i2) {
        return i1.$less((Object)i2);
    }

    public boolean lessThanEqualsInteger(BigInt i1, BigInt i2) {
        return i1.$less$eq((Object)i2);
    }

    public ByteString appendByteString(ByteString a, ByteString b) {
        return a.concat(b);
    }

    public ByteString consByteString(BigInt bigInt, ByteString byteString) {
        byte by = bigInt.toByte();
        Object object = Predef$.MODULE$.byteArrayOps(byteString.bytes());
        return ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteString sliceByteString(BigInt start, BigInt n, ByteString bs) {
        Object object = Predef$.MODULE$.byteArrayOps(bs.bytes());
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(object, start.toInt()));
        return ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.take$extension(object2, n.toInt()));
    }

    public BigInt lengthOfByteString(ByteString bs) {
        return BigInt$.MODULE$.int2bigInt(bs.length());
    }

    public BigInt indexByteString(ByteString bs, BigInt i) {
        if (i.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || i.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(bs.length()))) {
            throw new Exception(new StringBuilder(46).append("index ").append(i).append(" out of bounds for bytestring of length ").append(bs.length()).toString());
        }
        return scala.package$.MODULE$.BigInt().apply(bs.bytes()[i.toInt()] & 0xFF);
    }

    public boolean equalsByteString(ByteString a, ByteString b) {
        ByteString byteString = a;
        ByteString byteString2 = b;
        return !(byteString != null ? !((Object)byteString).equals(byteString2) : byteString2 != null);
    }

    public boolean lessThanByteString(ByteString a, ByteString b) {
        int minLen = package$.MODULE$.min(a.length(), b.length());
        for (int i = 0; i < minLen; ++i) {
            int bi;
            int ai = a.bytes()[i] & 0xFF;
            if (ai < (bi = b.bytes()[i] & 0xFF)) {
                return true;
            }
            if (ai <= bi) continue;
            return false;
        }
        return a.length() < b.length();
    }

    public boolean lessThanEqualsByteString(ByteString a, ByteString b) {
        int minLen = package$.MODULE$.min(a.length(), b.length());
        for (int i = 0; i < minLen; ++i) {
            int bi;
            int ai = a.bytes()[i] & 0xFF;
            if (ai < (bi = b.bytes()[i] & 0xFF)) {
                return true;
            }
            if (ai <= bi) continue;
            return false;
        }
        return a.length() <= b.length();
    }

    public ByteString sha2_256(PlatformSpecific ps, ByteString bs) {
        return ps.sha2_256(bs);
    }

    public ByteString sha3_256(PlatformSpecific ps, ByteString bs) {
        return ps.sha3_256(bs);
    }

    public ByteString blake2b_256(PlatformSpecific ps, ByteString bs) {
        return ps.blake2b_256(bs);
    }

    public boolean verifyEd25519Signature(PlatformSpecific ps, ByteString pk, ByteString msg, ByteString sig) {
        return ps.verifyEd25519Signature(pk, msg, sig);
    }

    public boolean verifyEcdsaSecp256k1Signature(PlatformSpecific ps, ByteString pk, ByteString msg, ByteString sig) {
        return ps.verifyEcdsaSecp256k1Signature(pk, msg, sig);
    }

    public boolean verifySchnorrSecp256k1Signature(PlatformSpecific ps, ByteString pk, ByteString msg, ByteString sig) {
        return ps.verifySchnorrSecp256k1Signature(pk, msg, sig);
    }

    public String appendString(String s1, String s2) {
        return new StringBuilder(0).append(s1).append(s2).toString();
    }

    public boolean equalsString(String s1, String s2) {
        String string = s1;
        String string2 = s2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ByteString encodeUtf8(String s) {
        return ByteString$.MODULE$.fromArray(s.getBytes("UTF-8"));
    }

    public String decodeUtf8(ByteString bs) {
        return new String(bs.bytes(), "UTF-8");
    }

    public <A> A ifThenElse(boolean cond, A a, A b) {
        if (cond) {
            return a;
        }
        return b;
    }

    public <A> A chooseUnit(A a) {
        return a;
    }

    public <A> A trace(String s, A a) {
        Predef$.MODULE$.println((Object)s);
        return a;
    }

    public <A, B> A fstPair(Pair<A, B> p) {
        return p.fst();
    }

    public <A, B> B sndPair(Pair<A, B> p) {
        return p.snd();
    }

    public <A, B> B chooseList(List<A> l, B e, B ne) {
        if (l.isEmpty()) {
            return e;
        }
        return ne;
    }

    public <A> List<A> mkCons(A a, List<A> l) {
        return l.$colon$colon(a);
    }

    public <A> A headList(List<A> l) {
        return l.head();
    }

    public <A> List<A> tailList(List<A> l) {
        return l.tail();
    }

    public <A> boolean nullList(List<A> l) {
        return l.isEmpty();
    }

    public <A> A chooseData(Data d, A constrCase, A mapCase, A listCase, A iCase, A bCase) {
        Data data = d;
        if (data instanceof Data.Constr) {
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l = constr._1();
            scala.collection.immutable.List<Data> list = constr._2();
            return constrCase;
        }
        if (data instanceof Data.Map) {
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            scala.collection.immutable.List<Tuple2<Data, Data>> list = map._1();
            return mapCase;
        }
        if (data instanceof Data.List) {
            Data.List list = Data$List$.MODULE$.unapply((Data.List)data);
            scala.collection.immutable.List<Data> list2 = list._1();
            return listCase;
        }
        if (data instanceof Data.I) {
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt bigInt = i._1();
            return iCase;
        }
        if (data instanceof Data.B) {
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString byteString = b._1();
            return bCase;
        }
        throw new MatchError((Object)data);
    }

    public Data mkConstr(BigInt ctor, List<Data> args) {
        return Data$Constr$.MODULE$.apply(ctor.toLong(), args.toList());
    }

    public Data constrData(BigInt ctor, List<Data> args) {
        return Data$Constr$.MODULE$.apply(ctor.toLong(), args.toList());
    }

    public Data mkMap(List<Pair<Data, Data>> values) {
        return Data$Map$.MODULE$.apply((scala.collection.immutable.List<Tuple2<Data, Data>>)values.toList().map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p.fst(), p.snd())));
    }

    public Data mapData(List<Pair<Data, Data>> values) {
        return Data$Map$.MODULE$.apply((scala.collection.immutable.List<Tuple2<Data, Data>>)values.toList().map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p.fst(), p.snd())));
    }

    public Data mkList(List<Data> values) {
        return Data$List$.MODULE$.apply(values.toList());
    }

    public Data listData(List<Data> values) {
        return Data$List$.MODULE$.apply(values.toList());
    }

    public Data mkI(BigInt value) {
        return Data$I$.MODULE$.apply(value);
    }

    public Data iData(BigInt value) {
        return Data$I$.MODULE$.apply(value);
    }

    public Data mkB(ByteString value) {
        return Data$B$.MODULE$.apply(value);
    }

    public Data bData(ByteString value) {
        return Data$B$.MODULE$.apply(value);
    }

    public Pair<BigInt, List<Data>> unsafeDataAsConstr(Data d) {
        Data data = d;
        if (data instanceof Data.Constr) {
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l = constr._1();
            scala.collection.immutable.List<Data> list = constr._2();
            long constr2 = l;
            scala.collection.immutable.List<Data> args = list;
            return Pair$.MODULE$.apply(BigInt$.MODULE$.long2bigInt(constr2), List$.MODULE$.apply(args));
        }
        throw new Exception(new StringBuilder(22).append("not a constructor but ").append(d).toString());
    }

    public Pair<BigInt, List<Data>> unConstrData(Data d) {
        Data data = d;
        if (data instanceof Data.Constr) {
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l = constr._1();
            scala.collection.immutable.List<Data> list = constr._2();
            long constr2 = l;
            scala.collection.immutable.List<Data> args = list;
            return Pair$.MODULE$.apply(BigInt$.MODULE$.long2bigInt(constr2), List$.MODULE$.apply(args));
        }
        throw new Exception(new StringBuilder(22).append("not a constructor but ").append(d).toString());
    }

    public List<Data> unsafeDataAsList(Data d) {
        Data data = d;
        if (data instanceof Data.List) {
            scala.collection.immutable.List<Data> list;
            Data.List list2 = Data$List$.MODULE$.unapply((Data.List)data);
            scala.collection.immutable.List<Data> values = list = list2._1();
            return List$.MODULE$.apply(values);
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public List<Data> unListData(Data d) {
        Data data = d;
        if (data instanceof Data.List) {
            scala.collection.immutable.List<Data> list;
            Data.List list2 = Data$List$.MODULE$.unapply((Data.List)data);
            scala.collection.immutable.List<Data> values = list = list2._1();
            return List$.MODULE$.apply(values);
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public List<Pair<Data, Data>> unsafeDataAsMap(Data d) {
        Data data = d;
        if (data instanceof Data.Map) {
            scala.collection.immutable.List<Tuple2<Data, Data>> list;
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            scala.collection.immutable.List<Tuple2<Data, Data>> values = list = map._1();
            return List$.MODULE$.apply(values.map((Function1 & Serializable)x$1 -> {
                Data data = (Data)x$1._1();
                Data data2 = (Data)x$1._2();
                return Pair$.MODULE$.apply(data, data2);
            }));
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public List<Pair<Data, Data>> unMapData(Data d) {
        Data data = d;
        if (data instanceof Data.Map) {
            scala.collection.immutable.List<Tuple2<Data, Data>> list;
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            scala.collection.immutable.List<Tuple2<Data, Data>> values = list = map._1();
            return List$.MODULE$.apply(values.map((Function1 & Serializable)x$1 -> {
                Data data = (Data)x$1._1();
                Data data2 = (Data)x$1._2();
                return Pair$.MODULE$.apply(data, data2);
            }));
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public BigInt unsafeDataAsI(Data d) {
        Data data = d;
        if (data instanceof Data.I) {
            BigInt bigInt;
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt value = bigInt = i._1();
            return value;
        }
        throw new Exception(new StringBuilder(19).append("not an integer but ").append(d).toString());
    }

    public BigInt unIData(Data d) {
        Data data = d;
        if (data instanceof Data.I) {
            BigInt bigInt;
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt value = bigInt = i._1();
            return value;
        }
        throw new Exception(new StringBuilder(19).append("not an integer but ").append(d).toString());
    }

    public ByteString unsafeDataAsB(Data d) {
        Data data = d;
        if (data instanceof Data.B) {
            ByteString byteString;
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString value = byteString = b._1();
            return value;
        }
        throw new Exception(new StringBuilder(21).append("not a bytestring but ").append(d).toString());
    }

    public ByteString unBData(Data d) {
        Data data = d;
        if (data instanceof Data.B) {
            ByteString byteString;
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString value = byteString = b._1();
            return value;
        }
        throw new Exception(new StringBuilder(21).append("not a bytestring but ").append(d).toString());
    }

    public boolean equalsData(Data d1, Data d2) {
        Data data = d1;
        Data data2 = d2;
        return !(data != null ? !data.equals(data2) : data2 != null);
    }

    public ByteString serialiseData(Data d) {
        return ByteString$.MODULE$.fromArray(Cbor$.MODULE$.encode((Object)d, (Encoder)DataCbor$package$dataCborEncoder$.MODULE$).toByteArray());
    }

    public Pair<Data, Data> mkPairData(Data fst, Data snd) {
        return Pair$.MODULE$.apply(fst, snd);
    }

    public List<Data> mkNilData() {
        return List$.MODULE$.empty();
    }

    public List<Pair<Data, Data>> mkNilPairData() {
        return List$.MODULE$.empty();
    }
}

