/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalus.builtin.ByteOrder;
import scalus.builtin.ByteOrder$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.IntegerToByteString;
import scalus.builtin.IntegerToByteString$IntegerToByteStringError$;
import scalus.uplc.eval.BuiltinException;

public final class IntegerToByteString$
implements Serializable {
    private static final int maximumOutputLength;
    public static final IntegerToByteString$IntegerToByteStringError$ scalus$builtin$IntegerToByteString$$$IntegerToByteStringError;
    public static final IntegerToByteString$ MODULE$;

    private IntegerToByteString$() {
    }

    static {
        MODULE$ = new IntegerToByteString$();
        maximumOutputLength = 8192;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IntegerToByteString$.class);
    }

    public int maximumOutputLength() {
        return maximumOutputLength;
    }

    private int integerLog2(BigInt i) {
        if (i.$less$eq((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return 0;
        }
        return i.bitLength() - 1;
    }

    public ByteString integerToByteString(boolean endiannessArg, BigInt lengthArg, BigInt input) {
        if (lengthArg.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            throw new BuiltinException(new StringBuilder(64).append("integerToByteString: negative length argument\nLength requested: ").append(lengthArg).toString());
        }
        if (lengthArg.$greater((Object)BigInt$.MODULE$.int2bigInt(this.maximumOutputLength()))) {
            throw new BuiltinException(new StringBuilder(88).append("integerToByteString: requested length is too long (maximum is ").append(this.maximumOutputLength()).append(" bytes)\nLength requested: ").append(lengthArg).toString());
        }
        if (BoxesRunTime.equals((Object)lengthArg, (Object)BoxesRunTime.boxToInteger((int)0)) && this.integerLog2(input) >= 8 * this.maximumOutputLength()) {
            Function1 & Serializable bytesRequiredFor = (Function1 & Serializable)n -> MODULE$.integerLog2((BigInt)n) / 8 + 1;
            throw new BuiltinException(new StringBuilder(71).append("integerToByteString: input too long (maximum is 2^").append(8 * this.maximumOutputLength()).append("-1)\nLength required: ").append(bytesRequiredFor.apply((Object)input)).toString());
        }
        ByteOrder endianness = endiannessArg ? ByteOrder$.BigEndian : ByteOrder$.LittleEndian;
        Either<IntegerToByteString.IntegerToByteStringError, ByteString> either = this.unsafeIntegerToByteString(endianness, lengthArg.toInt(), input);
        if (either instanceof Left) {
            IntegerToByteString.IntegerToByteStringError integerToByteStringError = (IntegerToByteString.IntegerToByteStringError)((Left)either).value();
            IntegerToByteString.IntegerToByteStringError integerToByteStringError2 = IntegerToByteString$IntegerToByteStringError$.NegativeInput;
            IntegerToByteString.IntegerToByteStringError integerToByteStringError3 = integerToByteStringError;
            if (!(integerToByteStringError2 != null ? !integerToByteStringError2.equals(integerToByteStringError3) : integerToByteStringError3 != null)) {
                throw new BuiltinException(new StringBuilder(60).append("integerToByteString: cannot convert negative Integer\nInput: ").append(input).toString());
            }
            IntegerToByteString.IntegerToByteStringError integerToByteStringError4 = IntegerToByteString$IntegerToByteStringError$.NotEnoughDigits;
            IntegerToByteString.IntegerToByteStringError integerToByteStringError5 = integerToByteStringError;
            if (!(integerToByteStringError4 != null ? !integerToByteStringError4.equals(integerToByteStringError5) : integerToByteStringError5 != null)) {
                throw new BuiltinException(new StringBuilder(96).append("integerToByteString: cannot represent Integer in given number of bytes\nInput: ").append(input).append("\nBytes requested: ").append(lengthArg).toString());
            }
        }
        if (either instanceof Right) {
            ByteString result = (ByteString)((Right)either).value();
            return result;
        }
        throw new MatchError(either);
    }

    private Either<IntegerToByteString.IntegerToByteStringError, ByteString> unsafeIntegerToByteString(ByteOrder requestedByteOrder, int requestedLength, BigInt input) {
        Option result;
        Option option;
        if (input.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return package$.MODULE$.Left().apply((Object)IntegerToByteString$IntegerToByteStringError$.NegativeInput);
        }
        if (BoxesRunTime.equals((Object)input, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return package$.MODULE$.Right().apply((Object)ByteString$.MODULE$.unsafeFromArray(new byte[requestedLength]));
        }
        if (requestedLength == 0) {
            ArrayBuffer arrayBuffer;
            ByteOrder byteOrder = requestedByteOrder;
            ByteOrder byteOrder2 = ByteOrder$.LittleEndian;
            ByteOrder byteOrder3 = byteOrder;
            if (!(byteOrder2 != null ? !((Object)((Object)byteOrder2)).equals((Object)byteOrder3) : byteOrder3 != null)) {
                arrayBuffer = this.goLENoLimit(input);
            } else {
                ByteOrder byteOrder4 = ByteOrder$.BigEndian;
                ByteOrder byteOrder5 = byteOrder;
                if (!(byteOrder4 != null ? !((Object)((Object)byteOrder4)).equals((Object)byteOrder5) : byteOrder5 != null)) {
                    arrayBuffer = (ArrayBuffer)this.goLENoLimit(input).reverse();
                } else {
                    throw new MatchError((Object)byteOrder);
                }
            }
            ArrayBuffer result2 = arrayBuffer;
            return package$.MODULE$.Right().apply((Object)ByteString$.MODULE$.unsafeFromArray((byte[])result2.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
        }
        ByteOrder byteOrder = requestedByteOrder;
        ByteOrder byteOrder6 = ByteOrder$.LittleEndian;
        ByteOrder byteOrder7 = byteOrder;
        if (!(byteOrder6 != null ? !((Object)((Object)byteOrder6)).equals((Object)byteOrder7) : byteOrder7 != null)) {
            option = this.goLELimit(input, requestedLength);
        } else {
            ByteOrder byteOrder8 = ByteOrder$.BigEndian;
            ByteOrder byteOrder9 = byteOrder;
            if (!(byteOrder8 != null ? !((Object)((Object)byteOrder8)).equals((Object)byteOrder9) : byteOrder9 != null)) {
                option = this.goLELimit(input, requestedLength).map((Function1 & Serializable)_$1 -> (ArrayBuffer)_$1.reverse());
            } else {
                throw new MatchError((Object)byteOrder);
            }
        }
        Option option2 = result = option;
        if (None$.MODULE$.equals(option2)) {
            return package$.MODULE$.Left().apply((Object)IntegerToByteString$IntegerToByteStringError$.NotEnoughDigits);
        }
        if (option2 instanceof Some) {
            ArrayBuffer bytes = (ArrayBuffer)((Some)option2).value();
            return package$.MODULE$.Right().apply((Object)ByteString$.MODULE$.unsafeFromArray((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
        }
        throw new MatchError((Object)option2);
    }

    private Option<ArrayBuffer<Object>> goLELimit(BigInt remaining, int requestedLength) {
        ArrayBuffer builder = new ArrayBuffer(requestedLength);
        BigInt current = remaining;
        while (!BoxesRunTime.equals((Object)current, (Object)BoxesRunTime.boxToInteger((int)0)) && builder.length() < requestedLength) {
            byte by = current.$amp(BigInt$.MODULE$.int2bigInt(255)).toByte();
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
            current = current.$greater$greater(8);
        }
        if (BoxesRunTime.equals((Object)current, (Object)BoxesRunTime.boxToInteger((int)0))) {
            ArrayBuffer result = (ArrayBuffer)builder.padTo(requestedLength, (Object)BoxesRunTime.boxToByte((byte)((byte)0)));
            return Some$.MODULE$.apply((Object)result);
        }
        return None$.MODULE$;
    }

    private ArrayBuffer<Object> goLENoLimit(BigInt input) {
        BigInt remaining;
        ArrayBuffer builder = new ArrayBuffer(input.bitLength() / 8 + 1);
        BigInt current = remaining = input;
        while (!BoxesRunTime.equals((Object)current, (Object)BoxesRunTime.boxToInteger((int)0))) {
            byte by = current.$amp(BigInt$.MODULE$.int2bigInt(255)).toByte();
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
            current = current.$greater$greater(8);
        }
        return builder;
    }
}

