/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;
import scalus.builtin.PlatformSpecific;
import scalus.uplc.BuiltinRuntime;
import scalus.uplc.BuiltinsMeaning;
import scalus.uplc.Constant;
import scalus.uplc.DefaultFun;
import scalus.uplc.DefaultUni;
import scalus.uplc.NamedDeBruijn;
import scalus.uplc.Term;
import scalus.uplc.Term$;
import scalus.uplc.Term$Apply$;
import scalus.uplc.Term$Builtin$;
import scalus.uplc.Term$Case$;
import scalus.uplc.Term$Const$;
import scalus.uplc.Term$Constr$;
import scalus.uplc.Term$Delay$;
import scalus.uplc.Term$Force$;
import scalus.uplc.Term$LamAbs$;
import scalus.uplc.Term$Var$;
import scalus.uplc.TypeScheme;
import scalus.uplc.TypeScheme$All$;
import scalus.uplc.TypeScheme$App$;
import scalus.uplc.TypeScheme$Arrow$;
import scalus.uplc.TypeScheme$TVar$;
import scalus.uplc.TypeScheme$Type$;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.BuiltinError;
import scalus.uplc.eval.BuiltinTermArgumentExpectedMachineError;
import scalus.uplc.eval.CekMachineCosts;
import scalus.uplc.eval.CekState;
import scalus.uplc.eval.CekState$Compute$;
import scalus.uplc.eval.CekState$Done$;
import scalus.uplc.eval.CekState$Return$;
import scalus.uplc.eval.CekValue;
import scalus.uplc.eval.CekValue$VBuiltin$;
import scalus.uplc.eval.CekValue$VCon$;
import scalus.uplc.eval.CekValue$VConstr$;
import scalus.uplc.eval.CekValue$VDelay$;
import scalus.uplc.eval.CekValue$VLamAbs$;
import scalus.uplc.eval.Context;
import scalus.uplc.eval.Context$;
import scalus.uplc.eval.Context$FrameAwaitArg$;
import scalus.uplc.eval.Context$FrameAwaitFunTerm$;
import scalus.uplc.eval.Context$FrameAwaitFunValue$;
import scalus.uplc.eval.Context$FrameCases$;
import scalus.uplc.eval.Context$FrameConstr$;
import scalus.uplc.eval.Context$FrameForce$;
import scalus.uplc.eval.CostModel;
import scalus.uplc.eval.CostingFun;
import scalus.uplc.eval.EvaluationFailure;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.ExBudgetCategory$;
import scalus.uplc.eval.ExBudgetCategory$BuiltinApp$;
import scalus.uplc.eval.ExBudgetCategory$Step$;
import scalus.uplc.eval.Logger;
import scalus.uplc.eval.MachineError;
import scalus.uplc.eval.MachineParams;
import scalus.uplc.eval.MissingCaseBranch;
import scalus.uplc.eval.NonFunctionalApplicationMachineError;
import scalus.uplc.eval.NonPolymorphicInstantiationMachineError;
import scalus.uplc.eval.OpenTermEvaluatedMachineError;
import scalus.uplc.eval.StepKind$;
import scalus.uplc.eval.UnexpectedBuiltinTermArgumentMachineError;
import scalus.uplc.eval.UnknownBuiltin;

public class CekMachine
extends BuiltinsMeaning {
    private final MachineParams params;
    private final BudgetSpender budgetSpender;
    private final Logger logger;
    private final ArrayBuffer logs;

    public CekMachine(MachineParams params, BudgetSpender budgetSpender, Logger logger, PlatformSpecific platformSpecific) {
        this.params = params;
        this.budgetSpender = budgetSpender;
        this.logger = logger;
        super(params.builtinCostModel(), platformSpecific, params.semanticVariant());
        this.logs = ArrayBuffer$.MODULE$.empty();
    }

    public MachineParams params() {
        return this.params;
    }

    public ArrayBuffer<String> logs() {
        return this.logs;
    }

    public Term evaluateTerm(Term term) {
        this.spendBudget(ExBudgetCategory$.Startup, this.params().machineCosts().startupCost(), (Seq<Tuple2<String, CekValue>>)ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        return this.loop$1(CekState$Compute$.MODULE$.apply(Context$.NoFrame, (Seq<Tuple2<String, CekValue>>)ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)), term));
    }

    private final CekState computeCek(Context ctx, Seq<Tuple2<String, CekValue>> env, Term term) {
        CekMachineCosts costs = this.params().machineCosts();
        Term term2 = term;
        if (term2 instanceof Term.Var) {
            NamedDeBruijn namedDeBruijn;
            Term.Var var = Term$Var$.MODULE$.unapply((Term.Var)term2);
            NamedDeBruijn name = namedDeBruijn = var._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Var), costs.varCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, this.lookupVarName(env, name));
        }
        if (term2 instanceof Term.LamAbs) {
            Term.LamAbs lamAbs = Term$LamAbs$.MODULE$.unapply((Term.LamAbs)term2);
            String string = lamAbs._1();
            Term term3 = lamAbs._2();
            String name = string;
            Term term4 = term3;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.LamAbs), costs.lamCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VLamAbs$.MODULE$.apply(name, term4, env));
        }
        if (term2 instanceof Term.Apply) {
            Term.Apply apply = Term$Apply$.MODULE$.unapply((Term.Apply)term2);
            Term term5 = apply._1();
            Term term6 = apply._2();
            Term fun = term5;
            Term arg = term6;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Apply), costs.applyCost(), env);
            return CekState$Compute$.MODULE$.apply(Context$FrameAwaitFunTerm$.MODULE$.apply(env, arg, ctx), env, fun);
        }
        if (term2 instanceof Term.Force) {
            Term term7;
            Term.Force force = Term$Force$.MODULE$.unapply((Term.Force)term2);
            Term term8 = term7 = force._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Force), costs.forceCost(), env);
            return CekState$Compute$.MODULE$.apply(Context$FrameForce$.MODULE$.apply(ctx), env, term8);
        }
        if (term2 instanceof Term.Delay) {
            Term term9;
            Term.Delay delay = Term$Delay$.MODULE$.unapply((Term.Delay)term2);
            Term term10 = term9 = delay._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Delay), costs.delayCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VDelay$.MODULE$.apply(term10, env));
        }
        if (term2 instanceof Term.Const) {
            Constant constant;
            Term.Const const_ = Term$Const$.MODULE$.unapply((Term.Const)term2);
            Constant constant2 = constant = const_._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Const), costs.constCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VCon$.MODULE$.apply(constant2));
        }
        if (term2 instanceof Term.Builtin) {
            DefaultFun defaultFun;
            Term.Builtin builtin = Term$Builtin$.MODULE$.unapply((Term.Builtin)term2);
            DefaultFun bn = defaultFun = builtin._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Builtin), costs.builtinCost(), env);
            Option option = this.BuiltinMeanings().get((Object)bn);
            if (option instanceof Some) {
                BuiltinRuntime meaning = (BuiltinRuntime)((Some)option).value();
                return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VBuiltin$.MODULE$.apply(bn, (Function0<Term>)(Function0 & Serializable)() -> term, meaning));
            }
            if (None$.MODULE$.equals(option)) {
                throw new UnknownBuiltin(bn, env);
            }
            throw new MatchError((Object)option);
        }
        Term term11 = Term$.Error;
        Term term12 = term2;
        if (!(term11 != null ? !term11.equals(term12) : term12 != null)) {
            throw new EvaluationFailure(env);
        }
        if (term2 instanceof Term.Constr) {
            Term.Constr constr = Term$Constr$.MODULE$.unapply((Term.Constr)term2);
            long l = constr._1();
            List<Term> list = constr._2();
            long tag = l;
            List<Term> args = list;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Constr), costs.constrCost(), env);
            List<Term> list2 = args;
            if (list2 instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list2;
                List list3 = colon2.next$access$1();
                Term arg = (Term)colon2.head();
                List rest = list3;
                return CekState$Compute$.MODULE$.apply(Context$FrameConstr$.MODULE$.apply(env, tag, (Seq<Term>)rest, (Seq<CekValue>)ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(CekValue.class)), ctx), env, arg);
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List<Term> list4 = list2;
            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                return this.returnCek(ctx, env, CekValue$VConstr$.MODULE$.apply(tag, (Seq<CekValue>)package$.MODULE$.Nil()));
            }
            throw new MatchError(list2);
        }
        if (term2 instanceof Term.Case) {
            Term.Case case_ = Term$Case$.MODULE$.unapply((Term.Case)term2);
            Term term13 = case_._1();
            List<Term> list = case_._2();
            Term scrut = term13;
            List<Term> cases = list;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Case), costs.caseCost(), env);
            return CekState$Compute$.MODULE$.apply(Context$FrameCases$.MODULE$.apply(env, (Seq<Term>)cases, ctx), env, scrut);
        }
        throw new MatchError((Object)term2);
    }

    private CekState returnCek(Context ctx, Seq<Tuple2<String, CekValue>> env, CekValue value) {
        Context context;
        block10: {
            Seq<Term> seq;
            while (true) {
                context = ctx;
                Context context2 = Context$.NoFrame;
                Context context3 = context;
                if (!(context2 != null ? !context2.equals(context3) : context3 != null)) {
                    return CekState$Done$.MODULE$.apply(this.dischargeCekValue(value));
                }
                if (context instanceof Context.FrameForce) {
                    Context context4;
                    Context.FrameForce frameForce = Context$FrameForce$.MODULE$.unapply((Context.FrameForce)context);
                    Context ctx2 = context4 = frameForce._1();
                    return this.forceEvaluate(ctx2, env, value);
                }
                if (context instanceof Context.FrameAwaitFunTerm) {
                    Context.FrameAwaitFunTerm frameAwaitFunTerm = Context$FrameAwaitFunTerm$.MODULE$.unapply((Context.FrameAwaitFunTerm)context);
                    Seq<Tuple2<String, CekValue>> seq2 = frameAwaitFunTerm._1();
                    Term term = frameAwaitFunTerm._2();
                    Context context5 = frameAwaitFunTerm._3();
                    Seq<Tuple2<String, CekValue>> env2 = seq2;
                    Term arg = term;
                    Context ctx3 = context5;
                    return CekState$Compute$.MODULE$.apply(Context$FrameAwaitArg$.MODULE$.apply(value, ctx3), env2, arg);
                }
                if (context instanceof Context.FrameAwaitArg) {
                    Context.FrameAwaitArg frameAwaitArg = Context$FrameAwaitArg$.MODULE$.unapply((Context.FrameAwaitArg)context);
                    CekValue cekValue = frameAwaitArg._1();
                    Context context6 = frameAwaitArg._2();
                    CekValue fun = cekValue;
                    Context ctx4 = context6;
                    return this.applyEvaluate(ctx4, env, fun, value);
                }
                if (context instanceof Context.FrameAwaitFunValue) {
                    Context.FrameAwaitFunValue frameAwaitFunValue = Context$FrameAwaitFunValue$.MODULE$.unapply((Context.FrameAwaitFunValue)context);
                    CekValue cekValue = frameAwaitFunValue._1();
                    Context context7 = frameAwaitFunValue._2();
                    CekValue arg = cekValue;
                    Context ctx5 = context7;
                    return this.applyEvaluate(ctx5, env, value, arg);
                }
                if (!(context instanceof Context.FrameConstr)) break block10;
                Context.FrameConstr frameConstr = Context$FrameConstr$.MODULE$.unapply((Context.FrameConstr)context);
                Seq<Tuple2<String, CekValue>> seq3 = frameConstr._1();
                long l = frameConstr._2();
                Seq<Term> seq4 = frameConstr._3();
                Seq<CekValue> seq5 = frameConstr._4();
                Context context8 = frameConstr._5();
                Seq<Tuple2<String, CekValue>> env3 = seq3;
                long tag = l;
                Seq<Term> todo = seq4;
                Seq<CekValue> evaled = seq5;
                Context ctx6 = context8;
                Seq newEvaled = (Seq)evaled.$colon$plus((Object)value);
                seq = todo;
                if (seq instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)seq;
                    List list = colon2.next$access$1();
                    Term arg = (Term)colon2.head();
                    List rest = list;
                    return CekState$Compute$.MODULE$.apply(Context$FrameConstr$.MODULE$.apply(env3, tag, (Seq<Term>)rest, (Seq<CekValue>)newEvaled, ctx6), env3, arg);
                }
                Nil$ nil$ = package$.MODULE$.Nil();
                Seq<Term> seq6 = seq;
                if (nil$ != null ? !nil$.equals(seq6) : seq6 != null) break;
                Context context9 = ctx6;
                Seq<Tuple2<String, CekValue>> seq7 = env3;
                CekValue.VConstr vConstr = CekValue$VConstr$.MODULE$.apply(tag, (Seq<CekValue>)newEvaled);
                ctx = context9;
                env = seq7;
                value = vConstr;
            }
            throw new MatchError(seq);
        }
        if (context instanceof Context.FrameCases) {
            Context.FrameCases frameCases = Context$FrameCases$.MODULE$.unapply((Context.FrameCases)context);
            Seq<Tuple2<String, CekValue>> seq = frameCases._1();
            Seq<Term> seq8 = frameCases._2();
            Context context10 = frameCases._3();
            Seq<Tuple2<String, CekValue>> env4 = seq;
            Seq<Term> cases = seq8;
            Context ctx7 = context10;
            CekValue cekValue = value;
            if (cekValue instanceof CekValue.VConstr) {
                CekValue.VConstr vConstr = CekValue$VConstr$.MODULE$.unapply((CekValue.VConstr)cekValue);
                long l = vConstr._1();
                Seq<CekValue> seq9 = vConstr._2();
                long tag = l;
                Seq<CekValue> args = seq9;
                if (0L <= tag && tag < (long)cases.size()) {
                    return CekState$Compute$.MODULE$.apply(this.transferArgStack(args, ctx7), env4, (Term)cases.apply((int)tag));
                }
                throw new MissingCaseBranch(tag, env4);
            }
            throw new EvaluationFailure(env4);
        }
        throw new MatchError((Object)context);
    }

    private Context transferArgStack(Seq<CekValue> args, Context ctx) {
        return (Context)args.foldRight((Object)ctx, (Function2 & Serializable)(arg, c) -> Context$FrameAwaitFunValue$.MODULE$.apply((CekValue)arg, (Context)c));
    }

    private CekValue lookupVarName(Seq<Tuple2<String, CekValue>> env, NamedDeBruijn name) {
        if (name.index() == 0) {
            throw new MachineError(new StringBuilder(85).append("Got a de Bruijn index 0: ").append(name).append(", it should be > 0. Run `DeBruijn.deBruijnTerm(term)` first.").toString());
        }
        if (name.index() <= 0 || env.size() < name.index()) {
            throw new OpenTermEvaluatedMachineError(name, env);
        }
        return (CekValue)((Tuple2)env.apply(env.size() - name.index()))._2();
    }

    private CekState applyEvaluate(Context ctx, Seq<Tuple2<String, CekValue>> env, CekValue fun, CekValue arg) {
        CekValue cekValue = fun;
        if (cekValue instanceof CekValue.VLamAbs) {
            CekValue.VLamAbs vLamAbs = CekValue$VLamAbs$.MODULE$.unapply((CekValue.VLamAbs)cekValue);
            String string = vLamAbs._1();
            Term term = vLamAbs._2();
            Seq<Tuple2<String, CekValue>> seq = vLamAbs._3();
            String name = string;
            Term term2 = term;
            Seq<Tuple2<String, CekValue>> env2 = seq;
            return CekState$Compute$.MODULE$.apply(ctx, (Seq<Tuple2<String, CekValue>>)((Seq)env2.$colon$plus((Object)Tuple2$.MODULE$.apply((Object)name, (Object)arg))), term2);
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            DefaultFun fun2 = defaultFun;
            Function0<Term> term = function0;
            BuiltinRuntime runtime = builtinRuntime;
            Function0 & Serializable term1 = (Function0 & Serializable)() -> Term$Apply$.MODULE$.apply((Term)term.apply(), this.dischargeCekValue(arg));
            TypeScheme typeScheme = runtime.typeScheme();
            if (typeScheme instanceof TypeScheme.Arrow) {
                TypeScheme typeScheme2;
                TypeScheme.Arrow arrow = TypeScheme$Arrow$.MODULE$.unapply((TypeScheme.Arrow)typeScheme);
                TypeScheme typeScheme3 = arrow._1();
                TypeScheme rest = typeScheme2 = arrow._2();
                Seq seq = (Seq)runtime.args().$colon$plus((Object)arg);
                Function2<Logger, Seq<CekValue>, CekValue> function2 = runtime.copy$default$2();
                CostingFun<CostModel> costingFun = runtime.copy$default$4();
                BuiltinRuntime runtime1 = runtime.copy(rest, function2, (Seq<CekValue>)seq, costingFun);
                CekValue res = this.evalBuiltinApp(env, fun2, (Function0<Term>)term1, runtime1);
                return CekState$Return$.MODULE$.apply(ctx, env, res);
            }
            throw new UnexpectedBuiltinTermArgumentMachineError((Term)term1.apply(), env);
        }
        throw new NonFunctionalApplicationMachineError(fun, env);
    }

    private CekState forceEvaluate(Context ctx, Seq<Tuple2<String, CekValue>> env, CekValue value) {
        CekValue cekValue = value;
        if (cekValue instanceof CekValue.VDelay) {
            CekValue.VDelay vDelay = CekValue$VDelay$.MODULE$.unapply((CekValue.VDelay)cekValue);
            Term term = vDelay._1();
            Seq<Tuple2<String, CekValue>> seq = vDelay._2();
            Term term2 = term;
            Seq<Tuple2<String, CekValue>> env2 = seq;
            return CekState$Compute$.MODULE$.apply(ctx, env2, term2);
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            DefaultFun bn = defaultFun;
            Function0<Term> term = function0;
            BuiltinRuntime rt = builtinRuntime;
            Function0 & Serializable term1 = (Function0 & Serializable)() -> Term$Force$.MODULE$.apply((Term)term.apply());
            TypeScheme typeScheme = rt.typeScheme();
            if (typeScheme instanceof TypeScheme.All) {
                TypeScheme typeScheme2;
                TypeScheme.All all = TypeScheme$All$.MODULE$.unapply((TypeScheme.All)typeScheme);
                String string = all._1();
                TypeScheme t = typeScheme2 = all._2();
                BuiltinRuntime runtime1 = rt.copy(t, rt.copy$default$2(), rt.copy$default$3(), rt.copy$default$4());
                CekValue res = this.evalBuiltinApp(env, bn, (Function0<Term>)term1, runtime1);
                return CekState$Return$.MODULE$.apply(ctx, env, res);
            }
            throw new BuiltinTermArgumentExpectedMachineError((Term)term1.apply(), env);
        }
        throw new NonPolymorphicInstantiationMachineError(value, env);
    }

    private CekValue evalBuiltinApp(Seq<Tuple2<String, CekValue>> env, DefaultFun builtinName, Function0<Term> term, BuiltinRuntime runtime) {
        block7: {
            CekValue cekValue;
            block5: {
                TypeScheme typeScheme;
                block6: {
                    block4: {
                        typeScheme = runtime.typeScheme();
                        if (!(typeScheme instanceof TypeScheme.Type)) break block4;
                        TypeScheme.Type type = TypeScheme$Type$.MODULE$.unapply((TypeScheme.Type)typeScheme);
                        DefaultUni defaultUni = type._1();
                        break block5;
                    }
                    if (!(typeScheme instanceof TypeScheme.TVar)) break block6;
                    TypeScheme.TVar tVar = TypeScheme$TVar$.MODULE$.unapply((TypeScheme.TVar)typeScheme);
                    String string = tVar._1();
                    break block5;
                }
                if (!(typeScheme instanceof TypeScheme.App)) break block7;
                TypeScheme.App app = TypeScheme$App$.MODULE$.unapply((TypeScheme.App)typeScheme);
                TypeScheme typeScheme2 = app._1();
                TypeScheme typeScheme3 = app._2();
            }
            this.spendBudget(ExBudgetCategory$BuiltinApp$.MODULE$.apply(builtinName), runtime.calculateCost(), env);
            try {
                cekValue = runtime.apply(this.logger);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    throw new BuiltinError(builtinName, (Term)term.apply(), e, env);
                }
                throw throwable;
            }
            return cekValue;
        }
        return CekValue$VBuiltin$.MODULE$.apply(builtinName, term, runtime);
    }

    private Term dischargeCekValue(CekValue value2) {
        CekValue cekValue = value2;
        if (cekValue instanceof CekValue.VCon) {
            Constant constant;
            CekValue.VCon vCon = CekValue$VCon$.MODULE$.unapply((CekValue.VCon)cekValue);
            Constant constant2 = constant = vCon._1();
            return Term$Const$.MODULE$.apply(constant2);
        }
        if (cekValue instanceof CekValue.VDelay) {
            CekValue.VDelay vDelay = CekValue$VDelay$.MODULE$.unapply((CekValue.VDelay)cekValue);
            Term term = vDelay._1();
            Seq<Tuple2<String, CekValue>> seq = vDelay._2();
            Term term2 = term;
            Seq<Tuple2<String, CekValue>> env = seq;
            return this.dischargeCekValEnv$1(env, Term$Delay$.MODULE$.apply(term2));
        }
        if (cekValue instanceof CekValue.VLamAbs) {
            CekValue.VLamAbs vLamAbs = CekValue$VLamAbs$.MODULE$.unapply((CekValue.VLamAbs)cekValue);
            String string = vLamAbs._1();
            Term term = vLamAbs._2();
            Seq<Tuple2<String, CekValue>> seq = vLamAbs._3();
            String name = string;
            Term term3 = term;
            Seq<Tuple2<String, CekValue>> env = seq;
            return this.dischargeCekValEnv$1(env, Term$LamAbs$.MODULE$.apply(name, term3));
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            Function0<Term> term = function0;
            return (Term)term.apply();
        }
        if (cekValue instanceof CekValue.VConstr) {
            CekValue.VConstr vConstr = CekValue$VConstr$.MODULE$.unapply((CekValue.VConstr)cekValue);
            long l = vConstr._1();
            Seq<CekValue> seq = vConstr._2();
            long tag = l;
            Seq<CekValue> args = seq;
            return Term$Constr$.MODULE$.apply(tag, (List<Term>)((IterableOnceOps)args.map((Function1 & Serializable)value -> this.dischargeCekValue((CekValue)value))).toList());
        }
        throw new MatchError((Object)cekValue);
    }

    private void spendBudget(ExBudgetCategory cat, ExBudget budget, Seq<Tuple2<String, CekValue>> env) {
        this.budgetSpender.spendBudget(cat, budget, env);
    }

    private final Term loop$1(CekState state) {
        CekState cekState;
        while (true) {
            if ((cekState = state) instanceof CekState.Compute) {
                CekState.Compute compute = CekState$Compute$.MODULE$.unapply((CekState.Compute)cekState);
                Context context = compute._1();
                Seq<Tuple2<String, CekValue>> seq = compute._2();
                Term term = compute._3();
                Context ctx = context;
                Seq<Tuple2<String, CekValue>> env = seq;
                Term term2 = term;
                state = this.computeCek(ctx, env, term2);
                continue;
            }
            if (!(cekState instanceof CekState.Return)) break;
            CekState.Return return_ = CekState$Return$.MODULE$.unapply((CekState.Return)cekState);
            Context context = return_._1();
            Seq<Tuple2<String, CekValue>> seq = return_._2();
            CekValue cekValue = return_._3();
            Context ctx = context;
            Seq<Tuple2<String, CekValue>> env = seq;
            CekValue value = cekValue;
            state = this.returnCek(ctx, env, value);
        }
        if (cekState instanceof CekState.Done) {
            Term term;
            CekState.Done done = CekState$Done$.MODULE$.unapply((CekState.Done)cekState);
            Term term3 = term = done._1();
            return term3;
        }
        throw new MatchError((Object)cekState);
    }

    private final Term go$1(Seq env$1, int lamCnt, Term term) {
        Term term2 = term;
        if (term2 instanceof Term.Var) {
            Term.Var var = Term$Var$.MODULE$.unapply((Term.Var)term2);
            NamedDeBruijn namedDeBruijn = var._1();
            NamedDeBruijn name = namedDeBruijn;
            if (lamCnt >= name.index()) {
                return term;
            }
            int relativeIdx = env$1.size() - (name.index() - lamCnt);
            if (env$1.isDefinedAt(relativeIdx)) {
                return this.dischargeCekValue((CekValue)((Tuple2)env$1.apply(relativeIdx))._2());
            }
            return term;
        }
        if (term2 instanceof Term.LamAbs) {
            Term.LamAbs lamAbs = Term$LamAbs$.MODULE$.unapply((Term.LamAbs)term2);
            String string = lamAbs._1();
            Term term3 = lamAbs._2();
            String name = string;
            Term body = term3;
            return Term$LamAbs$.MODULE$.apply(name, this.go$1(env$1, lamCnt + 1, body));
        }
        if (term2 instanceof Term.Apply) {
            Term.Apply apply = Term$Apply$.MODULE$.unapply((Term.Apply)term2);
            Term term4 = apply._1();
            Term term5 = apply._2();
            Term fun = term4;
            Term arg = term5;
            return Term$Apply$.MODULE$.apply(this.go$1(env$1, lamCnt, fun), this.go$1(env$1, lamCnt, arg));
        }
        if (term2 instanceof Term.Force) {
            Term term6;
            Term.Force force = Term$Force$.MODULE$.unapply((Term.Force)term2);
            Term term7 = term6 = force._1();
            return Term$Force$.MODULE$.apply(this.go$1(env$1, lamCnt, term7));
        }
        if (term2 instanceof Term.Delay) {
            Term term8;
            Term.Delay delay = Term$Delay$.MODULE$.unapply((Term.Delay)term2);
            Term term9 = term8 = delay._1();
            return Term$Delay$.MODULE$.apply(this.go$1(env$1, lamCnt, term9));
        }
        return term;
    }

    private final Term dischargeCekValEnv$1(Seq env, Term term) {
        return this.go$1(env, 0, term);
    }
}

