/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import java.io.Serializable;
import scala.Function1;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.CekValue;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.Logger;

public final class TallyingBudgetSpenderLogger
implements BudgetSpender,
Logger {
    private final BudgetSpender budgetSpender;
    private final Map costs;
    private final ArrayBuffer<Tuple2<String, ExBudget>> _logs;
    private final IndexedSeq logs;

    public TallyingBudgetSpenderLogger(BudgetSpender budgetSpender) {
        this.budgetSpender = budgetSpender;
        this.costs = ((Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).withDefault((Function1 & Serializable)_$5 -> ArrayBuffer$.MODULE$.empty());
        this._logs = ArrayBuffer$.MODULE$.empty();
        this.logs = this._logs;
    }

    public BudgetSpender budgetSpender() {
        return this.budgetSpender;
    }

    public Map<ExBudgetCategory, Buffer<ExBudget>> costs() {
        return this.costs;
    }

    @Override
    public void spendBudget(ExBudgetCategory cat, ExBudget budget, Seq<Tuple2<String, CekValue>> env) {
        this.budgetSpender().spendBudget(cat, budget, env);
        this.costs().update((Object)cat, (Object)((Growable)this.costs().apply((Object)cat)).$plus$eq((Object)budget));
    }

    @Override
    public ExBudget getSpentBudget() {
        return this.budgetSpender().getSpentBudget();
    }

    public IndexedSeq<Tuple2<String, ExBudget>> logs() {
        return this.logs;
    }

    public String[] getLogs() {
        return (String[])((IterableOnceOps)this._logs.map((Function1 & Serializable)_$6 -> (String)_$6._1())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Seq<String> getLogsWithBudget() {
        return ((IterableOnceOps)this._logs.map((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            ExBudget exBudget = (ExBudget)x$1._2();
            return new StringBuilder(2).append(string).append(": ").append(exBudget.showJson()).toString();
        })).toSeq();
    }

    @Override
    public void log(String msg) {
        this._logs.append((Object)Tuple2$.MODULE$.apply((Object)msg, (Object)this.getSpentBudget()));
    }
}

