/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.math.BigInteger;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECDigitalSignature$;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.ECPublicKeyApi;
import org.bitcoins.crypto.SchnorrDigitalSignature;
import org.bitcoins.crypto.SchnorrDigitalSignature$;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.SchnorrPublicKey$;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import scala.math.BigInt;
import scala.package$;
import scalus.builtin.BLS12_381_G1_Element;
import scalus.builtin.BLS12_381_G1_Element$;
import scalus.builtin.BLS12_381_G2_Element;
import scalus.builtin.BLS12_381_G2_Element$;
import scalus.builtin.BLS12_381_MlResult;
import scalus.builtin.BLS12_381_MlResult$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.PlatformSpecific;
import scalus.utils.Utils$;
import scodec.bits.ByteVector$;
import supranational.blst.P1;
import supranational.blst.P2;
import supranational.blst.PT;

public interface JVMPlatformSpecific
extends PlatformSpecific {
    public static void $init$(JVMPlatformSpecific $this) {
        $this.scalus$builtin$JVMPlatformSpecific$_setter_$scalarPeriod_$eq(package$.MODULE$.BigInt().apply("73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00000001", 16));
        $this.scalus$builtin$JVMPlatformSpecific$_setter_$bls12_381_G1_compressed_generator_$eq(ByteString$.MODULE$.fromArray(P1.generator().compress()));
    }

    public BigInt scalarPeriod();

    public void scalus$builtin$JVMPlatformSpecific$_setter_$scalarPeriod_$eq(BigInt var1);

    public static ByteString sha2_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.sha2_256(bs);
    }

    @Override
    default public ByteString sha2_256(ByteString bs) {
        return ByteString$.MODULE$.unsafeFromArray(Utils$.MODULE$.sha2_256(bs.bytes()));
    }

    public static ByteString sha3_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.sha3_256(bs);
    }

    @Override
    default public ByteString sha3_256(ByteString bs) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return ByteString$.MODULE$.unsafeFromArray(digestSHA3.digest(bs.bytes()));
    }

    public static ByteString blake2b_224$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_224(bs);
    }

    @Override
    default public ByteString blake2b_224(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(224);
        digest.update(bs.bytes(), 0, bs.length());
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    public static ByteString blake2b_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_256(bs);
    }

    @Override
    default public ByteString blake2b_256(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(256);
        digest.update(bs.bytes(), 0, bs.length());
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    public static boolean verifySchnorrSecp256k1Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifySchnorrSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifySchnorrSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        if (pk.length() != 32) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid public key length ").append(pk.length()).toString());
        }
        if (sig.length() != 64) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid signature length ").append(sig.length()).toString());
        }
        SchnorrDigitalSignature signature = (SchnorrDigitalSignature)SchnorrDigitalSignature$.MODULE$.apply(ByteVector$.MODULE$.apply(sig.bytes()));
        return ((SchnorrPublicKey)SchnorrPublicKey$.MODULE$.apply(ByteVector$.MODULE$.apply(pk.bytes()))).verify(ByteVector$.MODULE$.apply(msg.bytes()), signature);
    }

    public static boolean verifyEd25519Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEd25519Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEd25519Signature(ByteString pk, ByteString msg, ByteString sig) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters;
        if (pk.length() != 32) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid public key length ").append(pk.length()).toString());
        }
        if (sig.length() != 64) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid signature length ").append(sig.length()).toString());
        }
        try {
            ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(pk.bytes(), 0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Ed25519PublicKeyParameters pubKeyParams = ed25519PublicKeyParameters;
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)pubKeyParams);
        verifier.update(msg.bytes(), 0, msg.length());
        return verifier.verifySignature(sig.bytes());
    }

    public static boolean verifyEcdsaSecp256k1Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEcdsaSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEcdsaSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        if (pk.length() != 33) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid public key length ").append(pk.length()).toString());
        }
        if (msg.length() != 32) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Invalid message length ").append(msg.length()).toString());
        }
        if (sig.length() != 64) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid signature length ").append(sig.length()).toString());
        }
        ECDigitalSignature signature = ECDigitalSignature$.MODULE$.fromRS(ByteVector$.MODULE$.apply(sig.bytes()));
        return ((ECPublicKeyApi)ECPublicKey$.MODULE$.apply(ByteVector$.MODULE$.apply(pk.bytes()))).verify(ByteVector$.MODULE$.apply(msg.bytes()), signature);
    }

    public static boolean bls12_381_G1_equal$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return $this.bls12_381_G1_equal(p1, p2);
    }

    @Override
    default public boolean bls12_381_G1_equal(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return p1.p().is_equal(p2.p());
    }

    public static BLS12_381_G1_Element bls12_381_G1_add$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return $this.bls12_381_G1_add(p1, p2);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_add(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return BLS12_381_G1_Element$.MODULE$.apply(p1.p().add(p2.p()));
    }

    public static BLS12_381_G1_Element bls12_381_G1_scalarMul$(JVMPlatformSpecific $this, BigInt s, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_scalarMul(s, p);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_scalarMul(BigInt s, BLS12_381_G1_Element p) {
        BigInteger scalar = s.bigInteger().mod(this.scalarPeriod().bigInteger());
        return BLS12_381_G1_Element$.MODULE$.apply(p.p().mult(scalar));
    }

    public static BLS12_381_G1_Element bls12_381_G1_neg$(JVMPlatformSpecific $this, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_neg(p);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_neg(BLS12_381_G1_Element p) {
        return BLS12_381_G1_Element$.MODULE$.apply(p.p().neg());
    }

    public static ByteString bls12_381_G1_compress$(JVMPlatformSpecific $this, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_compress(p);
    }

    @Override
    default public ByteString bls12_381_G1_compress(BLS12_381_G1_Element p) {
        return ByteString$.MODULE$.fromArray(p.p().compress());
    }

    public static BLS12_381_G1_Element bls12_381_G1_uncompress$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.bls12_381_G1_uncompress(bs);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_uncompress(ByteString bs) {
        if (bs.length() != 48) {
            throw new IllegalArgumentException("Not a compressed point");
        }
        if ((bs.bytes()[0] & 0x80) == 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("BSL point not compressed: ").append(bs).toString());
        }
        P1 p = new P1(bs.bytes());
        if (!p.in_group()) {
            throw new IllegalArgumentException("Invalid point");
        }
        return BLS12_381_G1_Element$.MODULE$.apply(p);
    }

    public static BLS12_381_G1_Element bls12_381_G1_hashToGroup$(JVMPlatformSpecific $this, ByteString bs, ByteString dst) {
        return $this.bls12_381_G1_hashToGroup(bs, dst);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_hashToGroup(ByteString bs, ByteString dst) {
        if (dst.length() > 255) {
            throw new RuntimeException(new StringBuilder(22).append("HashToCurveDstTooBig: ").append(dst.length()).toString());
        }
        P1 p = new P1();
        p.hash_to(bs.bytes(), new String(dst.bytes(), "Latin1"));
        return BLS12_381_G1_Element$.MODULE$.apply(p);
    }

    @Override
    public ByteString bls12_381_G1_compressed_generator();

    public void scalus$builtin$JVMPlatformSpecific$_setter_$bls12_381_G1_compressed_generator_$eq(ByteString var1);

    public static boolean bls12_381_G2_equal$(JVMPlatformSpecific $this, BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_G2_equal(p1, p2);
    }

    @Override
    default public boolean bls12_381_G2_equal(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return p1.p().is_equal(p2.p());
    }

    public static BLS12_381_G2_Element bls12_381_G2_add$(JVMPlatformSpecific $this, BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_G2_add(p1, p2);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_add(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return BLS12_381_G2_Element$.MODULE$.apply(p1.p().add(p2.p()));
    }

    public static BLS12_381_G2_Element bls12_381_G2_scalarMul$(JVMPlatformSpecific $this, BigInt s, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_scalarMul(s, p);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_scalarMul(BigInt s, BLS12_381_G2_Element p) {
        BigInteger scalar = s.bigInteger().mod(this.scalarPeriod().bigInteger());
        return BLS12_381_G2_Element$.MODULE$.apply(p.p().mult(scalar));
    }

    public static BLS12_381_G2_Element bls12_381_G2_neg$(JVMPlatformSpecific $this, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_neg(p);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_neg(BLS12_381_G2_Element p) {
        return BLS12_381_G2_Element$.MODULE$.apply(p.p().neg());
    }

    public static ByteString bls12_381_G2_compress$(JVMPlatformSpecific $this, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_compress(p);
    }

    @Override
    default public ByteString bls12_381_G2_compress(BLS12_381_G2_Element p) {
        return ByteString$.MODULE$.fromArray(p.p().compress());
    }

    public static BLS12_381_G2_Element bls12_381_G2_uncompress$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.bls12_381_G2_uncompress(bs);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_uncompress(ByteString bs) {
        if (bs.length() != 96) {
            throw new IllegalArgumentException("Not a compressed point");
        }
        if ((bs.bytes()[0] & 0x80) == 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("BSL point not compressed: ").append(bs).toString());
        }
        P2 p = new P2(bs.bytes());
        if (!p.in_group()) {
            throw new IllegalArgumentException("Invalid point");
        }
        return BLS12_381_G2_Element$.MODULE$.apply(p);
    }

    public static BLS12_381_G2_Element bls12_381_G2_hashToGroup$(JVMPlatformSpecific $this, ByteString bs, ByteString dst) {
        return $this.bls12_381_G2_hashToGroup(bs, dst);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_hashToGroup(ByteString bs, ByteString dst) {
        if (dst.length() > 255) {
            throw new RuntimeException(new StringBuilder(22).append("HashToCurveDstTooBig: ").append(dst.length()).toString());
        }
        P2 p = new P2();
        p.hash_to(bs.bytes(), new String(dst.bytes(), "Latin1"));
        return BLS12_381_G2_Element$.MODULE$.apply(p);
    }

    public static ByteString bls12_381_G2_compressed_generator$(JVMPlatformSpecific $this) {
        return $this.bls12_381_G2_compressed_generator();
    }

    @Override
    default public ByteString bls12_381_G2_compressed_generator() {
        return ByteString$.MODULE$.fromArray(P2.generator().compress());
    }

    public static BLS12_381_MlResult bls12_381_millerLoop$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_millerLoop(p1, p2);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_millerLoop(BLS12_381_G1_Element p1, BLS12_381_G2_Element p2) {
        PT pt = new PT(p1.p(), p2.p());
        return BLS12_381_MlResult$.MODULE$.apply(pt);
    }

    public static BLS12_381_MlResult bls12_381_mulMlResult$(JVMPlatformSpecific $this, BLS12_381_MlResult r1, BLS12_381_MlResult r2) {
        return $this.bls12_381_mulMlResult(r1, r2);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_mulMlResult(BLS12_381_MlResult r1, BLS12_381_MlResult r2) {
        PT pt = r1.p().mul(r2.p());
        return BLS12_381_MlResult$.MODULE$.apply(pt);
    }

    public static boolean bls12_381_finalVerify$(JVMPlatformSpecific $this, BLS12_381_MlResult p1, BLS12_381_MlResult p2) {
        return $this.bls12_381_finalVerify(p1, p2);
    }

    @Override
    default public boolean bls12_381_finalVerify(BLS12_381_MlResult p1, BLS12_381_MlResult p2) {
        return PT.finalverify((PT)p1.p(), (PT)p2.p());
    }

    public static ByteString keccak_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.keccak_256(bs);
    }

    @Override
    default public ByteString keccak_256(ByteString bs) {
        Keccak.Digest256 digest = new Keccak.Digest256();
        return ByteString$.MODULE$.unsafeFromArray(digest.digest(bs.bytes()));
    }
}

