/*
 * Decompiled with CFR 0.152.
 */
package scalus.examples;

import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.BLS12_381_G1_Element;
import scalus.builtin.BLS12_381_MlResult;
import scalus.builtin.ByteString;
import scalus.builtin.Data;
import scalus.examples.Groth16$;
import scalus.examples.Groth16$Proof$;
import scalus.examples.Groth16$SnarkVerificationKey$;
import scalus.prelude.List;

public final class Groth16 {
    public static BLS12_381_G1_Element derive(List<ByteString> list, List<BigInt> list2, BLS12_381_G1_Element bLS12_381_G1_Element) {
        return Groth16$.MODULE$.derive(list, list2, bLS12_381_G1_Element);
    }

    public static Function1<Data, Proof> given_FromData_Proof() {
        return Groth16$.MODULE$.given_FromData_Proof();
    }

    public static Function1<Data, SnarkVerificationKey> given_FromData_SnarkVerificationKey() {
        return Groth16$.MODULE$.given_FromData_SnarkVerificationKey();
    }

    public static Function1<Proof, Data> given_ToData_Proof() {
        return Groth16$.MODULE$.given_ToData_Proof();
    }

    public static Function1<SnarkVerificationKey, Data> given_ToData_SnarkVerificationKey() {
        return Groth16$.MODULE$.given_ToData_SnarkVerificationKey();
    }

    public static boolean grothVerify(SnarkVerificationKey snarkVerificationKey, Proof proof, List<BigInt> list) {
        return Groth16$.MODULE$.grothVerify(snarkVerificationKey, proof, list);
    }

    public static BLS12_381_MlResult pairing(ByteString byteString, ByteString byteString2) {
        return Groth16$.MODULE$.pairing(byteString, byteString2);
    }

    public static class Proof
    implements Product,
    Serializable {
        private final ByteString piA;
        private final ByteString piB;
        private final ByteString piC;

        public static Proof apply(ByteString byteString, ByteString byteString2, ByteString byteString3) {
            return Groth16$Proof$.MODULE$.apply(byteString, byteString2, byteString3);
        }

        public static Proof fromProduct(Product product) {
            return Groth16$Proof$.MODULE$.fromProduct(product);
        }

        public static Proof unapply(Proof proof) {
            return Groth16$Proof$.MODULE$.unapply(proof);
        }

        public Proof(ByteString piA, ByteString piB, ByteString piC) {
            this.piA = piA;
            this.piB = piB;
            this.piC = piC;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Proof)) return false;
            Proof proof = (Proof)object;
            ByteString byteString = this.piA();
            ByteString byteString2 = proof.piA();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            ByteString byteString3 = this.piB();
            ByteString byteString4 = proof.piB();
            if (byteString3 == null) {
                if (byteString4 != null) {
                    return false;
                }
            } else if (!((Object)byteString3).equals(byteString4)) return false;
            ByteString byteString5 = this.piC();
            ByteString byteString6 = proof.piC();
            if (byteString5 == null) {
                if (byteString6 != null) {
                    return false;
                }
            } else if (!((Object)byteString5).equals(byteString6)) return false;
            if (!proof.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Proof;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Proof";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "piA";
                }
                case 1: {
                    return "piB";
                }
                case 2: {
                    return "piC";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString piA() {
            return this.piA;
        }

        public ByteString piB() {
            return this.piB;
        }

        public ByteString piC() {
            return this.piC;
        }

        public Proof copy(ByteString piA, ByteString piB, ByteString piC) {
            return new Proof(piA, piB, piC);
        }

        public ByteString copy$default$1() {
            return this.piA();
        }

        public ByteString copy$default$2() {
            return this.piB();
        }

        public ByteString copy$default$3() {
            return this.piC();
        }

        public ByteString _1() {
            return this.piA();
        }

        public ByteString _2() {
            return this.piB();
        }

        public ByteString _3() {
            return this.piC();
        }
    }

    public static class SnarkVerificationKey
    implements Product,
    Serializable {
        private final BigInt nPublic;
        private final ByteString vkAlpha;
        private final ByteString vkBeta;
        private final ByteString vkGamma;
        private final ByteString vkDelta;
        private final List vkAlphaBeta;
        private final List vkIC;

        public static SnarkVerificationKey apply(BigInt bigInt, ByteString byteString, ByteString byteString2, ByteString byteString3, ByteString byteString4, List<ByteString> list, List<ByteString> list2) {
            return Groth16$SnarkVerificationKey$.MODULE$.apply(bigInt, byteString, byteString2, byteString3, byteString4, list, list2);
        }

        public static SnarkVerificationKey fromProduct(Product product) {
            return Groth16$SnarkVerificationKey$.MODULE$.fromProduct(product);
        }

        public static SnarkVerificationKey unapply(SnarkVerificationKey snarkVerificationKey) {
            return Groth16$SnarkVerificationKey$.MODULE$.unapply(snarkVerificationKey);
        }

        public SnarkVerificationKey(BigInt nPublic, ByteString vkAlpha, ByteString vkBeta, ByteString vkGamma, ByteString vkDelta, List<ByteString> vkAlphaBeta, List<ByteString> vkIC) {
            this.nPublic = nPublic;
            this.vkAlpha = vkAlpha;
            this.vkBeta = vkBeta;
            this.vkGamma = vkGamma;
            this.vkDelta = vkDelta;
            this.vkAlphaBeta = vkAlphaBeta;
            this.vkIC = vkIC;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SnarkVerificationKey)) return false;
            SnarkVerificationKey snarkVerificationKey = (SnarkVerificationKey)object;
            BigInt bigInt = this.nPublic();
            BigInt bigInt2 = snarkVerificationKey.nPublic();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!bigInt.equals(bigInt2)) return false;
            ByteString byteString = this.vkAlpha();
            ByteString byteString2 = snarkVerificationKey.vkAlpha();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            ByteString byteString3 = this.vkBeta();
            ByteString byteString4 = snarkVerificationKey.vkBeta();
            if (byteString3 == null) {
                if (byteString4 != null) {
                    return false;
                }
            } else if (!((Object)byteString3).equals(byteString4)) return false;
            ByteString byteString5 = this.vkGamma();
            ByteString byteString6 = snarkVerificationKey.vkGamma();
            if (byteString5 == null) {
                if (byteString6 != null) {
                    return false;
                }
            } else if (!((Object)byteString5).equals(byteString6)) return false;
            ByteString byteString7 = this.vkDelta();
            ByteString byteString8 = snarkVerificationKey.vkDelta();
            if (byteString7 == null) {
                if (byteString8 != null) {
                    return false;
                }
            } else if (!((Object)byteString7).equals(byteString8)) return false;
            List<ByteString> list = this.vkAlphaBeta();
            List<ByteString> list2 = snarkVerificationKey.vkAlphaBeta();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<ByteString> list3 = this.vkIC();
            List<ByteString> list4 = snarkVerificationKey.vkIC();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            if (!snarkVerificationKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SnarkVerificationKey;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "SnarkVerificationKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "nPublic";
                }
                case 1: {
                    return "vkAlpha";
                }
                case 2: {
                    return "vkBeta";
                }
                case 3: {
                    return "vkGamma";
                }
                case 4: {
                    return "vkDelta";
                }
                case 5: {
                    return "vkAlphaBeta";
                }
                case 6: {
                    return "vkIC";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInt nPublic() {
            return this.nPublic;
        }

        public ByteString vkAlpha() {
            return this.vkAlpha;
        }

        public ByteString vkBeta() {
            return this.vkBeta;
        }

        public ByteString vkGamma() {
            return this.vkGamma;
        }

        public ByteString vkDelta() {
            return this.vkDelta;
        }

        public List<ByteString> vkAlphaBeta() {
            return this.vkAlphaBeta;
        }

        public List<ByteString> vkIC() {
            return this.vkIC;
        }

        public SnarkVerificationKey copy(BigInt nPublic, ByteString vkAlpha, ByteString vkBeta, ByteString vkGamma, ByteString vkDelta, List<ByteString> vkAlphaBeta, List<ByteString> vkIC) {
            return new SnarkVerificationKey(nPublic, vkAlpha, vkBeta, vkGamma, vkDelta, vkAlphaBeta, vkIC);
        }

        public BigInt copy$default$1() {
            return this.nPublic();
        }

        public ByteString copy$default$2() {
            return this.vkAlpha();
        }

        public ByteString copy$default$3() {
            return this.vkBeta();
        }

        public ByteString copy$default$4() {
            return this.vkGamma();
        }

        public ByteString copy$default$5() {
            return this.vkDelta();
        }

        public List<ByteString> copy$default$6() {
            return this.vkAlphaBeta();
        }

        public List<ByteString> copy$default$7() {
            return this.vkIC();
        }

        public BigInt _1() {
            return this.nPublic();
        }

        public ByteString _2() {
            return this.vkAlpha();
        }

        public ByteString _3() {
            return this.vkBeta();
        }

        public ByteString _4() {
            return this.vkGamma();
        }

        public ByteString _5() {
            return this.vkDelta();
        }

        public List<ByteString> _6() {
            return this.vkAlphaBeta();
        }

        public List<ByteString> _7() {
            return this.vkIC();
        }
    }
}

