/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import scala.Tuple2;
import scala.collection.immutable.Seq;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.CekValue;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudget$;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.OutOfExBudgetError;

public final class RestrictingBudgetSpender
implements BudgetSpender {
    private final ExBudget maxBudget;
    private long cpuLeft;
    private long memoryLeft;

    public RestrictingBudgetSpender(ExBudget maxBudget) {
        this.maxBudget = maxBudget;
        this.cpuLeft = maxBudget.cpu();
        this.memoryLeft = maxBudget.memory();
    }

    public ExBudget maxBudget() {
        return this.maxBudget;
    }

    @Override
    public void spendBudget(ExBudgetCategory cat, ExBudget budget, Seq<Tuple2<String, CekValue>> env) {
        this.cpuLeft -= budget.cpu();
        this.memoryLeft -= budget.memory();
        if (this.cpuLeft < 0L || this.memoryLeft < 0L) {
            throw new OutOfExBudgetError(this.maxBudget(), env);
        }
    }

    @Override
    public ExBudget getSpentBudget() {
        return ExBudget$.MODULE$.fromCpuAndMemory(this.maxBudget().cpu() - this.cpuLeft, this.maxBudget().memory() - this.memoryLeft);
    }

    public void reset() {
        this.cpuLeft = this.maxBudget().cpu();
        this.memoryLeft = this.maxBudget().memory();
    }
}

