/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import scala.runtime.ModuleSerializationProxy;

public final class UTF8Decoder$
implements Serializable {
    public static final UTF8Decoder$ MODULE$ = new UTF8Decoder$();

    private UTF8Decoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UTF8Decoder$.class);
    }

    public String decode(byte[] bytes) {
        String string;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer inputBuffer = ByteBuffer.wrap(bytes);
        CharBuffer outputBuffer = CharBuffer.allocate(bytes.length);
        try {
            CoderResult result = decoder.decode(inputBuffer, outputBuffer, true);
            if (!result.isUnderflow()) {
                throw new IllegalArgumentException("Invalid UTF-8 sequence");
            }
            outputBuffer.flip();
            string = outputBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Invalid UTF-8 sequence", e);
        }
        return string;
    }
}

