/*
 * Decompiled with CFR 0.152.
 */
package scalus.ledger.api.v3;

import scala.Product;
import scala.math.BigInt;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.ByteString;
import scalus.builtin.Data;
import scalus.ledger.api.v1.Credential;
import scalus.ledger.api.v3.ProposalProcedure;
import scalus.ledger.api.v3.ScriptInfo$;
import scalus.ledger.api.v3.ScriptInfo$CertifyingScript$;
import scalus.ledger.api.v3.ScriptInfo$MintingScript$;
import scalus.ledger.api.v3.ScriptInfo$ProposingScript$;
import scalus.ledger.api.v3.ScriptInfo$RewardingScript$;
import scalus.ledger.api.v3.ScriptInfo$SpendingScript$;
import scalus.ledger.api.v3.ScriptInfo$VotingScript$;
import scalus.ledger.api.v3.TxCert;
import scalus.ledger.api.v3.TxOutRef;
import scalus.ledger.api.v3.Voter;
import scalus.prelude.Option;

public abstract class ScriptInfo
implements Product,
Enum {
    public static ScriptInfo fromOrdinal(int n) {
        return ScriptInfo$.MODULE$.fromOrdinal(n);
    }

    public static final class CertifyingScript
    extends ScriptInfo {
        private final BigInt index;
        private final TxCert cert;

        public static CertifyingScript apply(BigInt bigInt, TxCert txCert) {
            return ScriptInfo$CertifyingScript$.MODULE$.apply(bigInt, txCert);
        }

        public static CertifyingScript fromProduct(Product product) {
            return ScriptInfo$CertifyingScript$.MODULE$.fromProduct(product);
        }

        public static CertifyingScript unapply(CertifyingScript certifyingScript) {
            return ScriptInfo$CertifyingScript$.MODULE$.unapply(certifyingScript);
        }

        public CertifyingScript() {
            this.index = index;
            this.cert = cert;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CertifyingScript)) return false;
            CertifyingScript certifyingScript = (CertifyingScript)object;
            BigInt bigInt = this.index();
            BigInt bigInt2 = certifyingScript.index();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!bigInt.equals(bigInt2)) return false;
            TxCert txCert = this.cert();
            TxCert txCert2 = certifyingScript.cert();
            if (txCert == null) {
                if (txCert2 == null) return true;
                return false;
            } else {
                if (!txCert.equals(txCert2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CertifyingScript;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "CertifyingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "index";
            }
            if (1 == n2) {
                return "cert";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInt index() {
            return this.index;
        }

        public TxCert cert() {
            return this.cert;
        }

        public CertifyingScript copy(BigInt index, TxCert cert) {
            return new CertifyingScript();
        }

        public BigInt copy$default$1() {
            return this.index();
        }

        public TxCert copy$default$2() {
            return this.cert();
        }

        public int ordinal() {
            return 3;
        }

        public BigInt _1() {
            return this.index();
        }

        public TxCert _2() {
            return this.cert();
        }
    }

    public static final class MintingScript
    extends ScriptInfo {
        private final ByteString currencySymbol;

        public static MintingScript apply(ByteString byteString) {
            return ScriptInfo$MintingScript$.MODULE$.apply(byteString);
        }

        public static MintingScript fromProduct(Product product) {
            return ScriptInfo$MintingScript$.MODULE$.fromProduct(product);
        }

        public static MintingScript unapply(MintingScript mintingScript) {
            return ScriptInfo$MintingScript$.MODULE$.unapply(mintingScript);
        }

        public MintingScript() {
            this.currencySymbol = currencySymbol;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MintingScript)) return false;
            MintingScript mintingScript = (MintingScript)object;
            ByteString byteString = this.currencySymbol();
            ByteString byteString2 = mintingScript.currencySymbol();
            if (byteString != null) {
                if (!((Object)byteString).equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MintingScript;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MintingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "currencySymbol";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString currencySymbol() {
            return this.currencySymbol;
        }

        public MintingScript copy(ByteString currencySymbol) {
            return new MintingScript();
        }

        public ByteString copy$default$1() {
            return this.currencySymbol();
        }

        public int ordinal() {
            return 0;
        }

        public ByteString _1() {
            return this.currencySymbol();
        }
    }

    public static final class ProposingScript
    extends ScriptInfo {
        private final BigInt index;
        private final ProposalProcedure procedure;

        public static ProposingScript apply(BigInt bigInt, ProposalProcedure proposalProcedure) {
            return ScriptInfo$ProposingScript$.MODULE$.apply(bigInt, proposalProcedure);
        }

        public static ProposingScript fromProduct(Product product) {
            return ScriptInfo$ProposingScript$.MODULE$.fromProduct(product);
        }

        public static ProposingScript unapply(ProposingScript proposingScript) {
            return ScriptInfo$ProposingScript$.MODULE$.unapply(proposingScript);
        }

        public ProposingScript() {
            this.index = index;
            this.procedure = procedure;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProposingScript)) return false;
            ProposingScript proposingScript = (ProposingScript)object;
            BigInt bigInt = this.index();
            BigInt bigInt2 = proposingScript.index();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!bigInt.equals(bigInt2)) return false;
            ProposalProcedure proposalProcedure = this.procedure();
            ProposalProcedure proposalProcedure2 = proposingScript.procedure();
            if (proposalProcedure == null) {
                if (proposalProcedure2 == null) return true;
                return false;
            } else {
                if (!((Object)proposalProcedure).equals(proposalProcedure2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ProposingScript;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "ProposingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "index";
            }
            if (1 == n2) {
                return "procedure";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInt index() {
            return this.index;
        }

        public ProposalProcedure procedure() {
            return this.procedure;
        }

        public ProposingScript copy(BigInt index, ProposalProcedure procedure) {
            return new ProposingScript();
        }

        public BigInt copy$default$1() {
            return this.index();
        }

        public ProposalProcedure copy$default$2() {
            return this.procedure();
        }

        public int ordinal() {
            return 5;
        }

        public BigInt _1() {
            return this.index();
        }

        public ProposalProcedure _2() {
            return this.procedure();
        }
    }

    public static final class RewardingScript
    extends ScriptInfo {
        private final Credential credential;

        public static RewardingScript apply(Credential credential) {
            return ScriptInfo$RewardingScript$.MODULE$.apply(credential);
        }

        public static RewardingScript fromProduct(Product product) {
            return ScriptInfo$RewardingScript$.MODULE$.fromProduct(product);
        }

        public static RewardingScript unapply(RewardingScript rewardingScript) {
            return ScriptInfo$RewardingScript$.MODULE$.unapply(rewardingScript);
        }

        public RewardingScript() {
            this.credential = credential;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RewardingScript)) return false;
            RewardingScript rewardingScript = (RewardingScript)object;
            Credential credential = this.credential();
            Credential credential2 = rewardingScript.credential();
            if (credential != null) {
                if (!credential.equals(credential2)) return false;
                return true;
            }
            if (credential2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RewardingScript;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "RewardingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "credential";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public RewardingScript copy(Credential credential) {
            return new RewardingScript();
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public int ordinal() {
            return 2;
        }

        public Credential _1() {
            return this.credential();
        }
    }

    public static final class SpendingScript
    extends ScriptInfo {
        private final TxOutRef txOutRef;
        private final Option datum;

        public static SpendingScript apply(TxOutRef txOutRef, Option<Data> option) {
            return ScriptInfo$SpendingScript$.MODULE$.apply(txOutRef, option);
        }

        public static SpendingScript fromProduct(Product product) {
            return ScriptInfo$SpendingScript$.MODULE$.fromProduct(product);
        }

        public static SpendingScript unapply(SpendingScript spendingScript) {
            return ScriptInfo$SpendingScript$.MODULE$.unapply(spendingScript);
        }

        public static Option<Data> $lessinit$greater$default$2() {
            return ScriptInfo$SpendingScript$.MODULE$.$lessinit$greater$default$2();
        }

        public SpendingScript(TxOutRef txOutRef2, Option<Data> option) {
            this.txOutRef = txOutRef;
            this.datum = (Option)datum;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SpendingScript)) return false;
            SpendingScript spendingScript = (SpendingScript)object;
            TxOutRef txOutRef = this.txOutRef();
            TxOutRef txOutRef2 = spendingScript.txOutRef();
            if (txOutRef == null) {
                if (txOutRef2 != null) {
                    return false;
                }
            } else if (!((Object)txOutRef).equals(txOutRef2)) return false;
            Option<Data> option = this.datum();
            Option<Data> option2 = spendingScript.datum();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SpendingScript;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "SpendingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "txOutRef";
            }
            if (1 == n2) {
                return "datum";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TxOutRef txOutRef() {
            return this.txOutRef;
        }

        public Option<Data> datum() {
            return this.datum;
        }

        public SpendingScript copy(TxOutRef txOutRef, Option<Data> datum) {
            return new SpendingScript(txOutRef, datum);
        }

        public TxOutRef copy$default$1() {
            return this.txOutRef();
        }

        public Option<Data> copy$default$2() {
            return this.datum();
        }

        public int ordinal() {
            return 1;
        }

        public TxOutRef _1() {
            return this.txOutRef();
        }

        public Option<Data> _2() {
            return this.datum();
        }
    }

    public static final class VotingScript
    extends ScriptInfo {
        private final Voter voter;

        public static VotingScript apply(Voter voter) {
            return ScriptInfo$VotingScript$.MODULE$.apply(voter);
        }

        public static VotingScript fromProduct(Product product) {
            return ScriptInfo$VotingScript$.MODULE$.fromProduct(product);
        }

        public static VotingScript unapply(VotingScript votingScript) {
            return ScriptInfo$VotingScript$.MODULE$.unapply(votingScript);
        }

        public VotingScript() {
            this.voter = voter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VotingScript)) return false;
            VotingScript votingScript = (VotingScript)object;
            Voter voter = this.voter();
            Voter voter2 = votingScript.voter();
            if (voter != null) {
                if (!voter.equals(voter2)) return false;
                return true;
            }
            if (voter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VotingScript;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "VotingScript";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "voter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Voter voter() {
            return this.voter;
        }

        public VotingScript copy(Voter voter) {
            return new VotingScript();
        }

        public Voter copy$default$1() {
            return this.voter();
        }

        public int ordinal() {
            return 4;
        }

        public Voter _1() {
            return this.voter();
        }
    }
}

