/*
 * Decompiled with CFR 0.152.
 */
package org.scanamo;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.scanamo.DynamoArray;
import org.scanamo.DynamoArray$;
import org.scanamo.DynamoObject;
import org.scanamo.DynamoObject$;
import org.scanamo.DynamoValue;
import org.scanamo.DynamoValue$DynNull$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class DynamoValue$
implements Serializable {
    public static DynamoValue$ MODULE$;
    private final AttributeValue Null;
    private final AttributeValue True;
    private final AttributeValue False;
    private final AttributeValue EmptyList;
    private final DynamoValue nil;

    static {
        new DynamoValue$();
    }

    public AttributeValue Null() {
        return this.Null;
    }

    public AttributeValue True() {
        return this.True;
    }

    public AttributeValue False() {
        return this.False;
    }

    public AttributeValue EmptyList() {
        return this.EmptyList;
    }

    public DynamoValue nil() {
        return this.nil;
    }

    public DynamoValue fromBoolean(boolean b) {
        return new DynamoValue.DynBool(b);
    }

    public <N> DynamoValue fromNumber(N n, Numeric<N> evidence$1) {
        return new DynamoValue.DynNum(n.toString());
    }

    public DynamoValue fromString(String s) {
        return new DynamoValue.DynString(s);
    }

    public DynamoValue fromByteBuffer(ByteBuffer b) {
        return new DynamoValue.DynByte(b);
    }

    public DynamoValue fromValues(Iterable<DynamoValue> as) {
        return new DynamoValue.DynArray(DynamoArray$.MODULE$.apply(as));
    }

    public DynamoValue fromFields(Seq<Tuple2<String, DynamoValue>> as) {
        return new DynamoValue.DynObject(DynamoObject$.MODULE$.apply((Map<String, DynamoValue>)as.toMap(Predef$.MODULE$.$conforms())));
    }

    public DynamoValue fromMap(Map<String, DynamoValue> as) {
        return new DynamoValue.DynObject(DynamoObject$.MODULE$.apply(as));
    }

    public <N> DynamoValue fromNumbers(Iterable<N> ns, Numeric<N> evidence$2) {
        return new DynamoValue.DynArray(DynamoArray$.MODULE$.numbers(ns, evidence$2));
    }

    public DynamoValue fromStrings(Iterable<String> ss) {
        return new DynamoValue.DynArray(DynamoArray$.MODULE$.strings(ss));
    }

    public DynamoValue fromByteBuffers(Iterable<ByteBuffer> bs) {
        return new DynamoValue.DynArray(DynamoArray$.MODULE$.byteBuffers(bs));
    }

    public final DynamoValue fromAttributeValue(AttributeValue av) {
        if (Predef$.MODULE$.Boolean2boolean(av.nul())) {
            return this.nil();
        }
        if (av.bool() != null) {
            return new DynamoValue.DynBool(Predef$.MODULE$.Boolean2boolean(av.bool()));
        }
        if (av.n() != null) {
            return new DynamoValue.DynNum(av.n());
        }
        if (av.s() != null) {
            return new DynamoValue.DynString(av.s());
        }
        if (av.b() != null) {
            return new DynamoValue.DynByte(av.b().asByteBuffer());
        }
        if (av.hasNs()) {
            return new DynamoValue.DynArray(DynamoArray$.MODULE$.unsafeNumbers(av.ns()));
        }
        if (av.hasBs()) {
            return new DynamoValue.DynArray(DynamoArray$.MODULE$.byteBuffers(av.bs().stream().map(x$1 -> x$1.asByteBuffer()).collect(Collectors.toList())));
        }
        if (av.hasSs()) {
            return new DynamoValue.DynArray(DynamoArray$.MODULE$.strings(av.ss()));
        }
        if (av.hasL()) {
            return new DynamoValue.DynArray(DynamoArray$.MODULE$.apply(av.l()));
        }
        if (av.hasM()) {
            return new DynamoValue.DynObject(DynamoObject$.MODULE$.apply(av.m()));
        }
        return DynamoValue$DynNull$.MODULE$;
    }

    public DynamoValue fromDynamoObject(DynamoObject xs) {
        return new DynamoValue.DynObject(xs);
    }

    public DynamoValue fromDynamoArray(DynamoArray xs) {
        return new DynamoValue.DynArray(xs);
    }

    public DynamoValue unsafeFromNumber(String n) {
        return new DynamoValue.DynNum(n);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamoValue$() {
        MODULE$ = this;
        this.Null = (AttributeValue)AttributeValue.builder().nul(Predef$.MODULE$.boolean2Boolean(true)).build();
        this.True = (AttributeValue)AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(true)).build();
        this.False = (AttributeValue)AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(false)).build();
        this.EmptyList = (AttributeValue)AttributeValue.builder().l((Collection)Collections.EMPTY_LIST).build();
        this.nil = DynamoValue$DynNull$.MODULE$;
    }
}

