/*
 * Decompiled with CFR 0.152.
 */
package org.scanamo;

import cats.Applicative;
import cats.Monad;
import cats.MonoidK;
import cats.free.Free;
import cats.free.Free$;
import cats.free.FreeT;
import cats.instances.package;
import cats.syntax.package;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.scanamo.DynamoFormat;
import org.scanamo.DynamoObject;
import org.scanamo.DynamoObject$;
import org.scanamo.DynamoResultStream$QueryResultStream$;
import org.scanamo.DynamoResultStream$ScanResultStream$;
import org.scanamo.error.DynamoReadError;
import org.scanamo.ops.ScanamoOps$;
import org.scanamo.ops.ScanamoOpsA;
import org.scanamo.query.Query;
import org.scanamo.query.UniqueKey;
import org.scanamo.query.UniqueKeys;
import org.scanamo.request.RequestCondition;
import org.scanamo.request.ScanamoDeleteRequest;
import org.scanamo.request.ScanamoPutRequest;
import org.scanamo.request.ScanamoQueryOptions$;
import org.scanamo.request.ScanamoQueryRequest;
import org.scanamo.request.ScanamoScanRequest;
import org.scanamo.request.ScanamoUpdateRequest;
import org.scanamo.update.UpdateExpression;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ScanamoFree$ {
    public static ScanamoFree$ MODULE$;
    private final int batchSize;
    private final int batchGetSize;

    static {
        new ScanamoFree$();
    }

    private int batchSize() {
        return this.batchSize;
    }

    private int batchGetSize() {
        return this.batchGetSize;
    }

    public <T> Free<ScanamoOpsA, Option<Either<DynamoReadError, T>>> put(String tableName, T item, DynamoFormat<T> f) {
        return ScanamoOps$.MODULE$.put(new ScanamoPutRequest(tableName, f.write(item), (Option<RequestCondition>)None$.MODULE$)).map((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply((Object)r.getAttributes()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$2 -> DynamoObject$.MODULE$.apply(x$2)).map((Function1 & Serializable & scala.Serializable)m -> MODULE$.read((DynamoObject)m, f)));
    }

    public <T> Free<ScanamoOpsA, List<BatchWriteItemResult>> putAll(String tableName, Set<T> items, DynamoFormat<T> f) {
        return (Free)package.traverse$.MODULE$.toTraverseOps((Object)items.grouped(this.batchSize()).toList(), package.list$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)batch -> {
            Map map = MODULE$.buildMap(tableName, (Iterable)batch, (Function1)(Function1 & Serializable & scala.Serializable)item -> new WriteRequest().withPutRequest(new PutRequest().withItem(((DynamoObject)f.write(item).asObject().getOrElse((Function0 & Serializable & scala.Serializable)() -> DynamoObject$.MODULE$.empty())).toJavaMap())));
            return ScanamoOps$.MODULE$.batchWrite(new BatchWriteItemRequest().withRequestItems(map));
        }, (Applicative)Free$.MODULE$.catsFreeMonadForFree());
    }

    public Free<ScanamoOpsA, List<BatchWriteItemResult>> deleteAll(String tableName, UniqueKeys<?> items) {
        return (Free)package.traverse$.MODULE$.toTraverseOps((Object)items.toDynamoObject().grouped(this.batchSize()).toList(), package.list$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)batch -> {
            Map map = MODULE$.buildMap(tableName, (Iterable)batch, (Function1)(Function1 & Serializable & scala.Serializable)item -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(item.toJavaMap())));
            return ScanamoOps$.MODULE$.batchWrite(new BatchWriteItemRequest().withRequestItems(map));
        }, (Applicative)Free$.MODULE$.catsFreeMonadForFree());
    }

    public <T> Free<ScanamoOpsA, Option<Either<DynamoReadError, T>>> get(String tableName, UniqueKey<?> key, boolean consistent, DynamoFormat<T> evidence$1) {
        return ScanamoOps$.MODULE$.get(new GetItemRequest().withTableName(tableName).withKey(key.toDynamoObject().toJavaMap()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(consistent))).map((Function1 & Serializable & scala.Serializable)res -> Option$.MODULE$.apply((Object)res.getItem()).map((Function1 & Serializable & scala.Serializable)m -> MODULE$.read(DynamoObject$.MODULE$.apply(m), evidence$1)));
    }

    public <T> Free<ScanamoOpsA, Set<Either<DynamoReadError, T>>> getAll(String tableName, UniqueKeys<?> keys, boolean consistent, DynamoFormat<T> evidence$2) {
        return ((Free)package.traverse$.MODULE$.toTraverseOps((Object)keys.toDynamoObject().grouped(this.batchGetSize()).toList(), package.list$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)batch -> {
            Map map = MODULE$.emptyMap(1);
            map.put(tableName, new KeysAndAttributes().withKeys((Collection)batch.foldLeft(MODULE$.emptyList(batch.size()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                void var2_2;
                java.util.List keys = x0$1;
                DynamoObject key = x1$1;
                keys.add(key.toJavaMap());
                return var2_2;
            })).withConsistentRead(Predef$.MODULE$.boolean2Boolean(consistent)));
            return ScanamoOps$.MODULE$.batchGet(new BatchGetItemRequest().withRequestItems(map));
        }, (Applicative)Free$.MODULE$.catsFreeMonadForFree())).map((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)x$4.getResponses().get(tableName)).asScala()).map((Function1 & Serializable & scala.Serializable)m -> MODULE$.read(DynamoObject$.MODULE$.apply(m), evidence$2), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toSet());
    }

    public Free<ScanamoOpsA, DeleteItemResult> delete(String tableName, UniqueKey<?> key) {
        return ScanamoOps$.MODULE$.delete(new ScanamoDeleteRequest(tableName, key.toDynamoObject(), (Option<RequestCondition>)None$.MODULE$));
    }

    public <T> Free<ScanamoOpsA, List<Either<DynamoReadError, T>>> scan(String tableName, DynamoFormat<T> evidence$3) {
        return DynamoResultStream$ScanResultStream$.MODULE$.stream(new ScanamoScanRequest(tableName, (Option<String>)None$.MODULE$, ScanamoQueryOptions$.MODULE$.default()), (DynamoFormat)evidence$3).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)x$6._1());
    }

    public <M, T> FreeT<ScanamoOpsA, M, List<Either<DynamoReadError, T>>> scanM(String tableName, int pageSize, Monad<M> evidence$4, MonoidK<M> evidence$5, DynamoFormat<T> evidence$6) {
        return DynamoResultStream$ScanResultStream$.MODULE$.streamTo(new ScanamoScanRequest(tableName, (Option<String>)None$.MODULE$, ScanamoQueryOptions$.MODULE$.default()), pageSize, (Monad)evidence$4, (DynamoFormat)evidence$6, (MonoidK)evidence$5);
    }

    public <T> Free<ScanamoOpsA, ScanResult> scan0(String tableName, DynamoFormat<T> evidence$7) {
        return ScanamoOps$.MODULE$.scan(new ScanamoScanRequest(tableName, (Option<String>)None$.MODULE$, ScanamoQueryOptions$.MODULE$.default()));
    }

    public <T> Free<ScanamoOpsA, List<Either<DynamoReadError, T>>> query(String tableName, Query<?> query, DynamoFormat<T> evidence$8) {
        return DynamoResultStream$QueryResultStream$.MODULE$.stream(new ScanamoQueryRequest(tableName, (Option<String>)None$.MODULE$, query, ScanamoQueryOptions$.MODULE$.default()), (DynamoFormat)evidence$8).map((Function1 & Serializable & scala.Serializable)x$7 -> (List)x$7._1());
    }

    public <M, T> FreeT<ScanamoOpsA, M, List<Either<DynamoReadError, T>>> queryM(String tableName, Query<?> query, int pageSize, Monad<M> evidence$9, MonoidK<M> evidence$10, DynamoFormat<T> evidence$11) {
        return DynamoResultStream$QueryResultStream$.MODULE$.streamTo(new ScanamoQueryRequest(tableName, (Option<String>)None$.MODULE$, query, ScanamoQueryOptions$.MODULE$.default()), pageSize, (Monad)evidence$9, (DynamoFormat)evidence$11, (MonoidK)evidence$10);
    }

    public <T> Free<ScanamoOpsA, QueryResult> query0(String tableName, Query<?> query, DynamoFormat<T> evidence$12) {
        return ScanamoOps$.MODULE$.query(new ScanamoQueryRequest(tableName, (Option<String>)None$.MODULE$, query, ScanamoQueryOptions$.MODULE$.default()));
    }

    public <T> Free<ScanamoOpsA, Either<DynamoReadError, T>> update(String tableName, UniqueKey<?> key, UpdateExpression update, DynamoFormat<T> evidence$13) {
        return ScanamoOps$.MODULE$.update(new ScanamoUpdateRequest(tableName, key.toDynamoObject(), update.expression(), update.attributeNames(), DynamoObject$.MODULE$.apply(update.dynamoValues()), update.addEmptyList(), (Option<RequestCondition>)None$.MODULE$)).map((Function1 & Serializable & scala.Serializable)r -> MODULE$.read(DynamoObject$.MODULE$.apply(r.getAttributes()), evidence$13));
    }

    public <T> Either<DynamoReadError, T> read(DynamoObject m, DynamoFormat<T> f) {
        return f.read(m.toDynamoValue());
    }

    private <T> java.util.List<T> emptyList(int capacity) {
        return new ArrayList(capacity);
    }

    private <K, T> Map<K, T> emptyMap(int capacity) {
        return new HashMap(capacity, 1.0f);
    }

    private <A, B> Map<String, java.util.List<B>> buildMap(String tableName, Iterable<A> batch, Function1<A, B> f) {
        Map<String, java.util.List<B>> map = this.emptyMap(1);
        map.put(tableName, (java.util.List<B>)batch.foldLeft(this.emptyList(batch.size()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            void var3_3;
            java.util.List reqs = x0$1;
            reqs.add(f.apply(x1$1));
            return var3_3;
        }));
        return map;
    }

    private ScanamoFree$() {
        MODULE$ = this;
        this.batchSize = 25;
        this.batchGetSize = 100;
    }
}

