/*
 * Decompiled with CFR 0.152.
 */
package org.scanamo.ops;

import cats.arrow.FunctionK;
import java.io.Serializable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.scanamo.ops.BatchGet;
import org.scanamo.ops.BatchWrite;
import org.scanamo.ops.ConditionalDelete;
import org.scanamo.ops.ConditionalPut;
import org.scanamo.ops.ConditionalUpdate;
import org.scanamo.ops.Delete;
import org.scanamo.ops.Get;
import org.scanamo.ops.Put;
import org.scanamo.ops.Query;
import org.scanamo.ops.Scan;
import org.scanamo.ops.ScanamoOpsA;
import org.scanamo.ops.TransactWriteAll;
import org.scanamo.ops.Update;
import org.scanamo.ops.package$JavaRequests$;
import org.scanamo.request.ScanamoDeleteRequest;
import org.scanamo.request.ScanamoPutRequest;
import org.scanamo.request.ScanamoQueryRequest;
import org.scanamo.request.ScanamoScanRequest;
import org.scanamo.request.ScanamoTransactWriteRequest;
import org.scanamo.request.ScanamoUpdateRequest;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0004\t\u0001=A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t{\u0001\u0011\t\u0011)A\u0006}!)\u0011\t\u0001C\u0001\u0005\")q\t\u0001C\u0005\u0011\")\u0011\r\u0001C\u0007E\")q\u000f\u0001C!q\n92kY1oC6|\u0017i]=oG&sG/\u001a:qe\u0016$XM\u001d\u0006\u0003\u0013)\t1a\u001c9t\u0015\tYA\"A\u0004tG\u0006t\u0017-\\8\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB!q#\t\u0013)\u001d\tAbD\u0004\u0002\u001a95\t!D\u0003\u0002\u001c\u001d\u00051AH]8pizJ\u0011!H\u0001\u0005G\u0006$8/\u0003\u0002 A\u00059\u0001/Y2lC\u001e,'\"A\u000f\n\u0005\t\u001a#A\u0004\u0013uS2$W\rJ4sK\u0006$XM\u001d\u0006\u0003?\u0001\u0002\"!\n\u0014\u000e\u0003!I!a\n\u0005\u0003\u0017M\u001b\u0017M\\1n_>\u00038/\u0011\t\u0003S1j\u0011A\u000b\u0006\u0003WI\t!bY8oGV\u0014(/\u001a8u\u0013\ti#F\u0001\u0004GkR,(/Z\u0001\u0007G2LWM\u001c;\u0011\u0005AZT\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005Q*\u0014\u0001C:feZL7-Z:\u000b\u0005Y:\u0014AB1xgN$7N\u0003\u00029s\u00051\u0011-\\1{_:T\u0011AO\u0001\tg>4Go^1sK&\u0011A(\r\u0002\u0014\tft\u0017-\\8EE\u0006\u001b\u0018P\\2DY&,g\u000e^\u0001\u0003K\u000e\u0004\"!K \n\u0005\u0001S#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u00111I\u0012\u000b\u0003\t\u0016\u0003\"!\n\u0001\t\u000bu\u001a\u00019\u0001 \t\u000b9\u001a\u0001\u0019A\u0018\u0002\u0007I,h.\u0006\u0002J\u001bR\u0011!J\u0016\t\u0004S1Z\u0005C\u0001'N\u0019\u0001!QA\u0014\u0003C\u0002=\u0013\u0011!Q\t\u0003!N\u0003\"!E)\n\u0005I\u0013\"a\u0002(pi\"Lgn\u001a\t\u0003#QK!!\u0016\n\u0003\u0007\u0005s\u0017\u0010C\u0003X\t\u0001\u0007\u0001,A\bd_6\u0004H.\u001a;j_:\u001cF/Y4f!\rIvlS\u0007\u00025*\u00111f\u0017\u0006\u00039v\u000bA!\u001e;jY*\ta,\u0001\u0003kCZ\f\u0017B\u00011[\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0017a\b:v]\u0016KG\u000f[3s\u0007>tG-\u001b;j_:\fGn\u00115fG.4\u0015-\u001b7fIV\u00111\r\u001e\u000b\u0003IV\u00042!\u000b\u0017f!\u00111'.\\:\u000f\u0005\u001dLgBA\ri\u0013\u0005\u0019\u0012BA\u0010\u0013\u0013\tYGN\u0001\u0004FSRDWM\u001d\u0006\u0003?I\u0001\"A\\9\u000e\u0003=T!\u0001]\u0019\u0002\u000b5|G-\u001a7\n\u0005I|'aH\"p]\u0012LG/[8oC2\u001c\u0005.Z2l\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]B\u0011A\n\u001e\u0003\u0006\u001d\u0016\u0011\ra\u0014\u0005\u0006/\u0016\u0001\rA\u001e\t\u00043~\u001b\u0018!B1qa2LXCA=})\tQX\u0010E\u0002*Ym\u0004\"\u0001\u0014?\u0005\u000b93!\u0019A(\t\u000by4\u0001\u0019A@\u0002\u0005=\u0004\bcA\u0013'w\u0002")
public class ScanamoAsyncInterpreter
implements FunctionK<ScanamoOpsA, Future> {
    private final DynamoDbAsyncClient client;
    private final ExecutionContext ec;

    public <E> FunctionK<E, Future> compose(FunctionK<E, ScanamoOpsA> f) {
        return FunctionK.compose$((FunctionK)this, f);
    }

    public <H> FunctionK<ScanamoOpsA, H> andThen(FunctionK<Future, H> f) {
        return FunctionK.andThen$((FunctionK)this, f);
    }

    public <H> FunctionK<?, Future> or(FunctionK<H, Future> h) {
        return FunctionK.or$((FunctionK)this, h);
    }

    public <H> FunctionK<ScanamoOpsA, ?> and(FunctionK<ScanamoOpsA, H> h) {
        return FunctionK.and$((FunctionK)this, h);
    }

    public <G0> FunctionK<ScanamoOpsA, G0> widen() {
        return FunctionK.widen$((FunctionK)this);
    }

    public <F0 extends ScanamoOpsA<Object>> FunctionK<F0, Future> narrow() {
        return FunctionK.narrow$((FunctionK)this);
    }

    private <A> Future<A> run(CompletionStage<A> completionStage) {
        return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(completionStage)).recoverWith((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)x1;
                    return (B1)Future$.MODULE$.failed(completionException.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof CompletionException;
            }
        }, this.ec);
    }

    private final <A> Future<Either<ConditionalCheckFailedException, A>> runEitherConditionalCheckFailed(CompletionStage<A> completionStage) {
        return this.run(completionStage).map((Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.Right().apply(x$1), this.ec).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof ConditionalCheckFailedException) {
                    ConditionalCheckFailedException conditionalCheckFailedException = (ConditionalCheckFailedException)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)conditionalCheckFailedException);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof ConditionalCheckFailedException;
            }
        }, this.ec);
    }

    public <A> Future<A> apply(ScanamoOpsA<A> op) {
        if (op instanceof Put) {
            ScanamoPutRequest req = ((Put)op).req();
            return this.run(this.client.putItem(package$JavaRequests$.MODULE$.put(req)));
        }
        if (op instanceof ConditionalPut) {
            ScanamoPutRequest req = ((ConditionalPut)op).req();
            return this.runEitherConditionalCheckFailed(this.client.putItem(package$JavaRequests$.MODULE$.put(req)));
        }
        if (op instanceof Get) {
            GetItemRequest req = ((Get)op).req();
            return this.run(this.client.getItem(req));
        }
        if (op instanceof Delete) {
            ScanamoDeleteRequest req = ((Delete)op).req();
            return this.run(this.client.deleteItem(package$JavaRequests$.MODULE$.delete(req)));
        }
        if (op instanceof ConditionalDelete) {
            ScanamoDeleteRequest req = ((ConditionalDelete)op).req();
            return this.runEitherConditionalCheckFailed(this.client.deleteItem(package$JavaRequests$.MODULE$.delete(req)));
        }
        if (op instanceof Scan) {
            ScanamoScanRequest req = ((Scan)op).req();
            return this.run(this.client.scan(package$JavaRequests$.MODULE$.scan(req)));
        }
        if (op instanceof Query) {
            ScanamoQueryRequest req = ((Query)op).req();
            return this.run(this.client.query(package$JavaRequests$.MODULE$.query(req)));
        }
        if (op instanceof BatchWrite) {
            BatchWriteItemRequest req = ((BatchWrite)op).req();
            return this.run(this.client.batchWriteItem(req));
        }
        if (op instanceof BatchGet) {
            BatchGetItemRequest req = ((BatchGet)op).req();
            return this.run(this.client.batchGetItem(req));
        }
        if (op instanceof Update) {
            ScanamoUpdateRequest req = ((Update)op).req();
            return this.run(this.client.updateItem(package$JavaRequests$.MODULE$.update(req)));
        }
        if (op instanceof ConditionalUpdate) {
            ScanamoUpdateRequest req = ((ConditionalUpdate)op).req();
            return this.runEitherConditionalCheckFailed(this.client.updateItem(package$JavaRequests$.MODULE$.update(req)));
        }
        if (op instanceof TransactWriteAll) {
            ScanamoTransactWriteRequest req = ((TransactWriteAll)op).req();
            return this.run(this.client.transactWriteItems(package$JavaRequests$.MODULE$.transactItems(req)));
        }
        throw new MatchError(op);
    }

    public ScanamoAsyncInterpreter(DynamoDbAsyncClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
        FunctionK.$init$((FunctionK)this);
    }
}

