/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.ContentRating;
import org.schedulesdirect.api.Program;
import org.schedulesdirect.api.Station;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;

public class Airing {
    private static final Log LOG = LogFactory.getLog(Airing.class);
    private String id;
    private boolean subjectToBlackout;
    private boolean educational;
    private boolean joinedInProgress;
    private boolean leftInProgress;
    private String contentSource;
    private int partNum;
    private boolean closedCaptioned;
    private boolean stereo;
    private boolean newAiring;
    private int duration;
    private int totalParts;
    private DolbyStatus dolbyStatus;
    private LiveStatus liveStatus;
    private boolean hdtv;
    private PremiereStatus premiereStatus;
    private FinaleStatus finaleStatus;
    private ContentRating[] tvRatings;
    private ContentType contentType;
    private boolean letterboxed;
    private Date gmtStart;
    private boolean descriptiveVideo;
    private boolean is3d;
    private boolean cableInTheClassroom;
    private boolean enhanced;
    private boolean sap;
    private String sapLanguage;
    private boolean subtitled;
    private String subtitleLanguage;
    private boolean timeApproximate;
    private String broadcastLanguage;
    private Station station;
    private Program program;

    Airing(JSONObject src, Program prog, Station station) throws InvalidJsonObjectException, IllegalArgumentException {
        if (prog == null) {
            throw new IllegalArgumentException("An Airing's Program cannot be null!");
        }
        if (station == null) {
            throw new IllegalArgumentException("An Airing's Station cannot be null!");
        }
        this.program = prog;
        this.station = station;
        try {
            String premiereFinale;
            this.id = src.getString("programID");
            if (!this.program.getId().equals(this.id)) {
                throw new IllegalArgumentException("Received Program does not match id of Airing!");
            }
            this.duration = Integer.parseInt(src.get("duration").toString());
            this.gmtStart = Config.get().getDateTimeFormat().parse(src.getString("airDateTime"));
            JSONArray audioOpts = src.optJSONArray("audioProperties");
            this.dolbyStatus = DolbyStatus.NONE;
            if (audioOpts != null) {
                block36: for (int i = 0; i < audioOpts.length(); ++i) {
                    String val;
                    switch (val = audioOpts.getString(i)) {
                        case "cc": {
                            this.closedCaptioned = true;
                            continue block36;
                        }
                        case "stereo": {
                            this.stereo = true;
                            continue block36;
                        }
                        case "dvs": {
                            this.descriptiveVideo = true;
                            continue block36;
                        }
                        case "subtitled": {
                            this.subtitled = true;
                            continue block36;
                        }
                        default: {
                            if (val.startsWith("D")) {
                                try {
                                    this.dolbyStatus = DolbyStatus.valueOf(val);
                                }
                                catch (IllegalArgumentException e) {
                                    LOG.warn((Object)String.format("Unknown DolbyStatus encountered! [%s]", val));
                                    this.dolbyStatus = DolbyStatus.UNKNOWN;
                                }
                                continue block36;
                            }
                            LOG.warn((Object)String.format("Unknown audio property encountered! [%s]", val));
                        }
                    }
                }
            }
            this.timeApproximate = src.optBoolean("timeApproximate");
            if (this.subtitled && src.has("subtitledLanguage")) {
                this.subtitleLanguage = src.getString("subtitledLanguage");
            }
            this.sap = src.optBoolean("sap");
            if (this.sap && src.has("sapLanguage")) {
                this.sapLanguage = src.getString("sapLanguage");
            }
            this.cableInTheClassroom = src.optBoolean("cableInTheClassroom");
            this.subjectToBlackout = src.optBoolean("subjectToBlackout");
            this.educational = src.optBoolean("educational");
            this.joinedInProgress = src.optBoolean("joinedInProgress");
            this.leftInProgress = src.optBoolean("leftInProgress");
            this.contentSource = src.optString("netSyndicationSource");
            this.partNum = src.optInt("partNumber");
            this.newAiring = src.optBoolean("new");
            this.totalParts = src.optInt("numberOfParts");
            String live = src.optString("liveTapeDelay", LiveStatus.NONE.toString()).toUpperCase();
            try {
                this.liveStatus = live.length() == 0 ? LiveStatus.NONE : LiveStatus.valueOf(live);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)String.format("Unknown LiveStatus encountered! [%s]", live));
                this.liveStatus = LiveStatus.UNKNOWN;
            }
            JSONArray videoOpts = src.optJSONArray("videoProperties");
            if (videoOpts != null) {
                block37: for (int i = 0; i < videoOpts.length(); ++i) {
                    String val;
                    switch (val = videoOpts.getString(i)) {
                        case "hdtv": {
                            this.hdtv = true;
                            continue block37;
                        }
                        case "letterbox": {
                            this.letterboxed = true;
                            continue block37;
                        }
                        case "enhanced": {
                            this.enhanced = true;
                            continue block37;
                        }
                        case "3d": {
                            this.is3d = true;
                        }
                    }
                }
            }
            if ((premiereFinale = src.optString("isPremiereOrFinale").toUpperCase().replace(' ', '_')).length() == 0) {
                this.premiereStatus = PremiereStatus.NONE;
                this.finaleStatus = FinaleStatus.NONE;
            } else if (premiereFinale.contains("PREMIERE")) {
                this.finaleStatus = FinaleStatus.NONE;
                try {
                    this.premiereStatus = PremiereStatus.valueOf(premiereFinale);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)String.format("Unknown PremiereStatus encountered! [%s]", premiereFinale));
                    this.premiereStatus = PremiereStatus.UNKNOWN;
                }
            } else {
                this.premiereStatus = PremiereStatus.NONE;
                try {
                    this.finaleStatus = FinaleStatus.valueOf(premiereFinale);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)String.format("Unknown FinaleStatus encountered! [%s]", premiereFinale));
                    this.finaleStatus = FinaleStatus.UNKNOWN;
                }
            }
            JSONArray ratings = src.optJSONArray("contentRating");
            if (ratings != null) {
                ArrayList<ContentRating> ratingsColl = new ArrayList<ContentRating>();
                for (int i = 0; i < ratings.length(); ++i) {
                    JSONObject o = ratings.getJSONObject(i);
                    ratingsColl.add(new ContentRating(o.getString("body"), o.getString("code")));
                }
                this.tvRatings = ratingsColl.toArray(new ContentRating[0]);
            } else {
                this.tvRatings = new ContentRating[0];
            }
            JSONObject content = src.optJSONObject("syndication");
            if (content != null) {
                try {
                    String type = content.getString("type").toUpperCase().replace(' ', '_');
                    this.contentType = type.length() == 0 ? ContentType.NONE : ContentType.valueOf(type);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)String.format("Unknwon ContentType encountered! [%s]", content));
                    this.contentType = ContentType.UNKNOWN;
                }
            } else {
                this.contentType = ContentType.NONE;
            }
            this.broadcastLanguage = src.optString("programLanguage", null);
        }
        catch (ParseException | JSONException e) {
            throw new InvalidJsonObjectException(String.format("Airing[%s]: %s", this.id, e.getMessage()), e, src.toString(3));
        }
    }

    public String getBroadcastLanguage() {
        return this.broadcastLanguage;
    }

    public void setBroadcastLanguage(String lang) {
        this.broadcastLanguage = lang;
    }

    public boolean isSubjectToBlackout() {
        return this.subjectToBlackout;
    }

    public boolean isEducational() {
        return this.educational;
    }

    public boolean isJoinedInProgress() {
        return this.joinedInProgress;
    }

    public boolean isLeftInProgress() {
        return this.leftInProgress;
    }

    public String getContentSource() {
        return this.contentSource;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public boolean isClosedCaptioned() {
        return this.closedCaptioned;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public boolean isNewAiring() {
        return this.newAiring;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTotalParts() {
        return this.totalParts;
    }

    public DolbyStatus getDolbyStatus() {
        return this.dolbyStatus;
    }

    public LiveStatus getLiveStatus() {
        return this.liveStatus;
    }

    public boolean isHdtv() {
        return this.hdtv;
    }

    public PremiereStatus getPremiereStatus() {
        return this.premiereStatus;
    }

    public FinaleStatus getFinaleStatus() {
        return this.finaleStatus;
    }

    public ContentRating[] getTvRatings() {
        return this.tvRatings;
    }

    public String getId() {
        return this.id;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public boolean isLetterboxed() {
        return this.letterboxed;
    }

    public Date getGmtStart() {
        return this.gmtStart;
    }

    public boolean isDescriptiveVideo() {
        return this.descriptiveVideo;
    }

    public boolean is3d() {
        return this.is3d;
    }

    public boolean isCableInTheClassroom() {
        return this.cableInTheClassroom;
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    public boolean isSap() {
        return this.sap;
    }

    public String getSapLanguage() {
        return this.sapLanguage;
    }

    public boolean isSubtitled() {
        return this.subtitled;
    }

    public String getSubtitleLanguage() {
        return this.subtitleLanguage;
    }

    public boolean isTimeApproximate() {
        return this.timeApproximate;
    }

    public void setId(String id) throws IllegalArgumentException {
        if (id == null || !this.program.getId().equals(id)) {
            throw new IllegalArgumentException(String.format("The new id for a Program cannot be null and it must match the id of the attached Program [%s]", this.program.getId()));
        }
        this.id = id;
    }

    public void setSubjectToBlackout(boolean subjectToBlackout) {
        this.subjectToBlackout = subjectToBlackout;
    }

    public void setEducational(boolean educational) {
        this.educational = educational;
    }

    public void setJoinedInProgress(boolean joinedInProgress) {
        this.joinedInProgress = joinedInProgress;
    }

    public void setLeftInProgress(boolean leftInProgress) {
        this.leftInProgress = leftInProgress;
    }

    public void setContentSource(String contentSource) {
        this.contentSource = contentSource;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public void setClosedCaptioned(boolean closedCaptioned) {
        this.closedCaptioned = closedCaptioned;
    }

    public void setStereo(boolean stereo) {
        this.stereo = stereo;
    }

    public void setNewAiring(boolean newAiring) {
        this.newAiring = newAiring;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setTotalParts(int totalParts) {
        this.totalParts = totalParts;
    }

    public void setDolbyStatus(DolbyStatus dolbyStatus) {
        this.dolbyStatus = dolbyStatus;
    }

    public void setLiveStatus(LiveStatus liveStatus) {
        this.liveStatus = liveStatus;
    }

    public void setHdtv(boolean hdtv) {
        this.hdtv = hdtv;
    }

    public void setPremiereStatus(PremiereStatus premiereStatus) {
        this.premiereStatus = premiereStatus;
    }

    public void setFinaleStatus(FinaleStatus finaleStatus) {
        this.finaleStatus = finaleStatus;
    }

    public void setTvRatings(ContentRating[] tvRatings) {
        this.tvRatings = tvRatings;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setLetterboxed(boolean letterboxed) {
        this.letterboxed = letterboxed;
    }

    public void setGmtStart(Date gmtStart) {
        this.gmtStart = gmtStart;
    }

    public void setDescriptiveVideo(boolean descriptiveVideo) {
        this.descriptiveVideo = descriptiveVideo;
    }

    public void setIs3d(boolean is3d) {
        this.is3d = is3d;
    }

    public void setCableInTheClassroom(boolean cableInTheClassroom) {
        this.cableInTheClassroom = cableInTheClassroom;
    }

    public void setEnhanced(boolean enhanced) {
        this.enhanced = enhanced;
    }

    public void setSap(boolean sap) {
        this.sap = sap;
    }

    public void setSapLanguage(String sapLanguage) {
        this.sapLanguage = sapLanguage;
    }

    public void setSubtitled(boolean subtitled) {
        this.subtitled = subtitled;
    }

    public void setSubtitleLanguage(String subtitleLanguage) {
        this.subtitleLanguage = subtitleLanguage;
    }

    public void setTimeApproximate(boolean timeApproximate) {
        this.timeApproximate = timeApproximate;
    }

    public Station getStation() {
        return this.station;
    }

    public void setStation(Station station) throws IllegalArgumentException {
        if (station == null) {
            throw new IllegalArgumentException("An Airing's Station cannot be null!");
        }
        this.station = station;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) throws IllegalArgumentException {
        if (program == null) {
            throw new IllegalArgumentException("The new Program cannot be null!");
        }
        this.program = program;
        this.id = program.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gmtStart == null ? 0 : this.gmtStart.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.program == null ? 0 : this.program.hashCode());
        result = 31 * result + (this.station == null ? 0 : this.station.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Airing)) {
            return false;
        }
        Airing other = (Airing)obj;
        if (this.gmtStart == null ? other.gmtStart != null : !this.gmtStart.equals(other.gmtStart)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.program == null ? other.program != null : !this.program.equals(other.program)) {
            return false;
        }
        return !(this.station == null ? other.station != null : !this.station.equals(other.station));
    }

    public String toString() {
        int maxLen = 2;
        return "Airing [id=" + this.id + ", subjectToBlackout=" + this.subjectToBlackout + ", educational=" + this.educational + ", joinedInProgress=" + this.joinedInProgress + ", leftInProgress=" + this.leftInProgress + ", contentSource=" + this.contentSource + ", partNum=" + this.partNum + ", closedCaptioned=" + this.closedCaptioned + ", stereo=" + this.stereo + ", newAiring=" + this.newAiring + ", duration=" + this.duration + ", totalParts=" + this.totalParts + ", dolbyStatus=" + (Object)((Object)this.dolbyStatus) + ", liveStatus=" + (Object)((Object)this.liveStatus) + ", hdtv=" + this.hdtv + ", premiereStatus=" + (Object)((Object)this.premiereStatus) + ", finaleStatus=" + (Object)((Object)this.finaleStatus) + ", tvRatings=" + (this.tvRatings != null ? Arrays.asList(this.tvRatings).subList(0, Math.min(this.tvRatings.length, 2)) : null) + ", contentType=" + (Object)((Object)this.contentType) + ", letterboxed=" + this.letterboxed + ", gmtStart=" + this.gmtStart + ", descriptiveVideo=" + this.descriptiveVideo + ", is3d=" + this.is3d + ", cableInTheClassroom=" + this.cableInTheClassroom + ", enhanced=" + this.enhanced + ", sap=" + this.sap + ", sapLanguage=" + this.sapLanguage + ", subtitled=" + this.subtitled + ", subtitleLanguage=" + this.subtitleLanguage + ", timeApproximate=" + this.timeApproximate + ", broadcastLanguage=" + this.broadcastLanguage + ", station=" + this.station + ", program=" + this.program + "]";
    }

    public static enum ContentType {
        NONE,
        OFF_NETWORK,
        BROADCAST_NETWORK,
        FIRST_RUN_SYNDICATION,
        UNKNOWN;

    }

    public static enum FinaleStatus {
        NONE,
        SEASON_FINALE,
        SERIES_FINALE,
        UNKNOWN;

    }

    public static enum PremiereStatus {
        NONE,
        PREMIERE,
        SEASON_PREMIERE,
        SERIES_PREMIERE,
        UNKNOWN;

    }

    public static enum LiveStatus {
        NONE,
        LIVE,
        DELAY,
        TAPE,
        UNKNOWN;

    }

    public static enum DolbyStatus {
        NONE,
        DD51,
        DD,
        DOLBY,
        UNKNOWN;

    }
}

