/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Config {
    private static final Log LOG = LogFactory.getLog(Config.class);
    public static final String API_VERSION = Config.initApiVersion();
    public static final String DEFAULT_BASE_URL = "https://json.schedulesdirect.org";
    private static Config INSTANCE = null;
    private String dateTimeFmt = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String initApiVersion() {
        try (InputStream apiProps = Config.class.getResourceAsStream("/sdjson-api.properties");){
            if (apiProps != null) {
                Properties p = new Properties();
                p.load(apiProps);
                String string = p.getProperty("version");
                return string;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOError", (Throwable)e);
            return "unknown";
        }
        LOG.warn((Object)"Unable to determine API version!  Setting to 'unknown'.");
        return "unknown";
    }

    public static Config get() {
        if (INSTANCE == null) {
            INSTANCE = new Config();
        }
        return INSTANCE;
    }

    private Config() {
    }

    public String getDateTimeFormatString() {
        return this.dateTimeFmt;
    }

    public SimpleDateFormat getDateTimeFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat(this.dateTimeFmt);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt;
    }

    public boolean captureJsonParseErrors() {
        return System.getProperty("sdjson.capture.json-errors") != null;
    }

    public boolean captureJsonEncodingErrors() {
        return System.getProperty("sdjson.capture.encode-errors") != null;
    }

    public File captureRoot() {
        String capRoot = System.getProperty("sdjson.fs.capture");
        return new File(capRoot != null && capRoot.length() > 0 ? capRoot : String.format("%s/%s", System.getProperty("user.home"), ".sdjson/capture"));
    }

    public boolean captureHttpComm() {
        return System.getProperty("sdjson.capture.http") != null;
    }

    public boolean captureHttpContent() {
        return this.captureHttpComm() && System.getProperty("sdjson.capture.http.content") != null;
    }
}

