/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.SilentInvalidJsonObjectException;

public class Message {
    private String id;
    private Date date;
    private String content;
    private EpgClient clnt;

    Message(JSONObject src, EpgClient clnt) throws InvalidJsonObjectException {
        try {
            this.date = Config.get().getDateTimeFormat().parse(src.getString("date"));
            this.id = src.getString("msgID");
        }
        catch (ParseException | JSONException e) {
            throw new SilentInvalidJsonObjectException(e);
        }
        this.content = src.optString("message");
        this.clnt = clnt;
    }

    public String getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getContent() {
        return this.content;
    }

    public void delete() throws IOException {
        this.clnt.deleteMessage(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Message [id=");
        builder.append(this.id);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", content=");
        builder.append(this.content);
        builder.append(", clnt=");
        builder.append(this.clnt);
        builder.append("]");
        return builder.toString();
    }
}

