/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.ContentRating;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;

public class Program {
    private static final Log LOG = LogFactory.getLog(Program.class);
    public static final String EMPTY_PROGRAM = "{\"md5\":\"\"}";
    public static final SimpleDateFormat ORIG_FMT = new SimpleDateFormat("yyyy-MM-dd");
    public static final Pattern MOVIE_REGEX;
    private static final Set<String> WARNED_SRC_TYPES;
    private static final Set<String> WARNED_COLOR_CODES;
    private String id;
    private boolean madeForTv;
    private String description;
    private String episodeTitle;
    private String title;
    private Date originalAirDate;
    private String descriptionLanguage;
    private SourceType sourceType;
    private String syndicatedEpisodeNumber;
    private ColorCode colorCode;
    private String[] advisories;
    private String alternateEpisodeNumber;
    private String alternateTitle;
    private Credit[] credits;
    private String alternateDescription;
    private String alternateDescriptionShort;
    private String[] shortDescriptions;
    private Date gameStart;
    private String holiday;
    private String md5;
    private ContentRating[] ratings;
    private String countryOfOrigin;
    private String studio;
    private int runTime;
    private String starRating;
    private float starRatingValue;
    private String episodeNumber;
    private String[] shortTitles;
    private int year;
    private String[] genres;
    private List<Map<String, Object>> metadata;
    private String seriesDescription;

    private static String parseDesc(JSONArray src) {
        return src != null ? src.getJSONObject(Program.findEnDescIndex(src)).getString("description") : "";
    }

    private static int findEnDescIndex(JSONArray src) {
        int retVal = 0;
        if (src.length() > 1) {
            for (int i = 0; i < src.length(); ++i) {
                JSONObject o = src.getJSONObject(i);
                if (!o.getString("descriptionLanguage").equals("en")) continue;
                retVal = i;
                break;
            }
        }
        return retVal;
    }

    Program(JSONObject src) throws InvalidJsonObjectException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null!");
        }
        try {
            int i;
            JSONObject movieInfo;
            this.id = src.getString("programID");
            this.seriesDescription = src.optString("seriesDescription", null);
            this.metadata = new ArrayList<Map<String, Object>>();
            if (src.has("metadata")) {
                JSONArray metaArr = src.getJSONArray("metadata");
                for (int i2 = 0; i2 < metaArr.length(); ++i2) {
                    JSONObject o = metaArr.getJSONObject(i2);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String k : JSONObject.getNames((JSONObject)o)) {
                        map.put(k, !o.isNull(k) ? o.get(k) : null);
                    }
                    this.metadata.add(map);
                }
            }
            this.year = (movieInfo = src.optJSONObject("movie")) != null && movieInfo.has("year") ? Integer.parseInt(movieInfo.get("year").toString()) : 0;
            JSONObject titles = src.getJSONObject("titles");
            this.title = titles.getString("title120");
            this.shortTitles = new String[4];
            this.shortTitles[0] = titles.optString("title70");
            this.shortTitles[1] = titles.optString("title40");
            this.shortTitles[2] = titles.optString("title20");
            this.shortTitles[3] = titles.optString("title10");
            this.episodeNumber = src.optString("syndicatedEpisodeNumber");
            this.starRating = movieInfo != null && movieInfo.has("starRating") ? movieInfo.getString("starRating") : null;
            this.starRatingValue = this.starRating == null || this.starRating.length() == 0 ? 0.0f : this.calcStarValue();
            this.runTime = movieInfo != null && movieInfo.has("runTime") ? movieInfo.getInt("runTime") : 0;
            this.studio = movieInfo != null && movieInfo.has("origStudio") ? movieInfo.getString("origStudio") : null;
            this.countryOfOrigin = movieInfo != null && movieInfo.has("origCountry") ? movieInfo.getString("origCountry") : null;
            JSONArray ratings = src.optJSONArray("contentRating");
            if (ratings != null) {
                ArrayList<ContentRating> coll = new ArrayList<ContentRating>();
                for (int i3 = 0; i3 < ratings.length(); ++i3) {
                    JSONObject o = ratings.getJSONObject(i3);
                    coll.add(new ContentRating(o.getString("body"), o.getString("code")));
                }
                this.ratings = coll.toArray(new ContentRating[0]);
            } else {
                this.ratings = new ContentRating[0];
            }
            this.md5 = src.getString("md5");
            this.holiday = src.has("holiday") ? src.getString("holiday") : null;
            this.gameStart = src.has("gameDatetime") ? Config.get().getDateTimeFormat().parse(src.getString("gameDatetime")) : null;
            JSONObject descs = src.optJSONObject("descriptions");
            this.shortDescriptions = new String[4];
            if (descs != null) {
                this.description = Program.parseDesc(descs.optJSONArray("description1000"));
                this.shortDescriptions[0] = Program.parseDesc(descs.optJSONArray("description255"));
                this.shortDescriptions[1] = Program.parseDesc(descs.optJSONArray("description100"));
                this.shortDescriptions[2] = Program.parseDesc(descs.optJSONArray("description60"));
                this.shortDescriptions[3] = Program.parseDesc(descs.optJSONArray("description40"));
                Arrays.sort(this.shortDescriptions, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        if (o1 == null && o2 != null) {
                            return 1;
                        }
                        if (o1 != null && o2 == null) {
                            return -1;
                        }
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        return o2.length() - o1.length();
                    }
                });
                if (this.description.length() == 0 && this.shortDescriptions[0].length() > 0) {
                    this.description = this.shortDescriptions[0];
                }
                this.alternateDescription = Program.parseDesc(descs.optJSONArray("alternateDescription255"));
                this.alternateDescriptionShort = Program.parseDesc(descs.optJSONArray("alternateDescription100"));
            } else {
                String EMPTY = "";
                this.description = "";
                Arrays.fill(this.shortDescriptions, "");
                this.alternateDescription = "";
                this.alternateDescriptionShort = "";
            }
            ArrayList<Credit> castAndCrew = new ArrayList<Credit>();
            if (src.has("cast")) {
                JSONArray cast = src.getJSONArray("cast");
                for (i = 0; i < cast.length(); ++i) {
                    castAndCrew.add(new Credit(cast.getJSONObject(i)));
                }
            }
            if (src.has("crew")) {
                JSONArray crew = src.getJSONArray("crew");
                for (i = 0; i < crew.length(); ++i) {
                    castAndCrew.add(new Credit(crew.getJSONObject(i)));
                }
            }
            this.credits = castAndCrew.toArray(new Credit[0]);
            this.alternateTitle = src.optString("alternateTitle");
            String string = this.alternateEpisodeNumber = src.has("alternateSyndicatedEpisodeNumber") ? src.getString("alternateSyndicatedEpisodeNumber") : null;
            if (src.has("contentAdvisory")) {
                JSONArray arr = src.getJSONArray("contentAdvisory");
                ArrayList<String> vals = new ArrayList<String>();
                for (int i4 = 0; i4 < arr.length(); ++i4) {
                    vals.add(arr.getString(i4));
                }
                this.advisories = vals.toArray(new String[vals.size()]);
            } else {
                this.advisories = new String[0];
            }
            this.madeForTv = src.optBoolean("madeForTv");
            this.episodeTitle = src.optString("episodeTitle150");
            String orig = src.optString("originalAirDate", "");
            this.originalAirDate = orig.length() > 0 && !orig.startsWith("0") ? ORIG_FMT.parse(src.getString("originalAirDate")) : null;
            this.descriptionLanguage = descs != null ? src.optString("descriptionLanguage", null) : null;
            String srcType = src.optString("sourceType").toUpperCase();
            try {
                this.sourceType = srcType.length() == 0 ? SourceType.NONE : SourceType.valueOf(srcType);
            }
            catch (IllegalArgumentException e) {
                if (WARNED_SRC_TYPES.add(srcType)) {
                    LOG.warn((Object)String.format("Unknown SourceType encountered! [%s]", srcType));
                }
                this.sourceType = SourceType.UNKNOWN;
            }
            ArrayList<String> genreVals = new ArrayList<String>();
            String showTypeVal = src.optString("showType");
            if (showTypeVal != null && !"Series".equals(showTypeVal)) {
                if (MOVIE_REGEX.matcher(showTypeVal).matches()) {
                    showTypeVal = "Movie";
                }
                genreVals.add(showTypeVal);
            }
            if (src.has("genres")) {
                JSONArray arr = src.getJSONArray("genres");
                for (int i5 = 0; i5 < arr.length(); ++i5) {
                    genreVals.add(arr.getString(i5));
                }
            }
            this.genres = genreVals.toArray(new String[0]);
            this.syndicatedEpisodeNumber = src.optString("syndicatedEpisodeNumber");
            String colorVal = src.optString("colorCode", ColorCode.NONE.toString()).toUpperCase().replaceAll(" & ", "").replaceAll(" +", "_");
            try {
                this.colorCode = colorVal.length() == 0 ? ColorCode.NONE : ColorCode.valueOf(colorVal);
            }
            catch (IllegalArgumentException e) {
                if (WARNED_COLOR_CODES.add(colorVal)) {
                    LOG.warn((Object)String.format("Unknown ColorCode encountered! [%s]", colorVal));
                }
                this.colorCode = ColorCode.UNKNOWN;
            }
        }
        catch (ParseException | JSONException e) {
            throw new InvalidJsonObjectException(String.format("Program[%s]: %s", this.id, e.getMessage()), e, src.toString(3));
        }
    }

    public List<Map<String, Object>> getMetadata() {
        return this.metadata;
    }

    public String[] getGenres() {
        return this.genres;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMadeForTv() {
        return this.madeForTv;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEpisodeTitle() {
        return this.episodeTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getOriginalAirDate() {
        return this.originalAirDate;
    }

    public String getDescriptionLanguage() {
        return this.descriptionLanguage;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getSyndicatedEpisodeNumber() {
        return this.syndicatedEpisodeNumber;
    }

    public ColorCode getColorCode() {
        return this.colorCode;
    }

    public String[] getAdvisories() {
        return this.advisories;
    }

    public String getAlternateEpisodeNumber() {
        return this.alternateEpisodeNumber;
    }

    public String getAlternateTitle() {
        return this.alternateTitle;
    }

    public Credit[] getCredits() {
        return this.credits;
    }

    public String getAlternateDescription() {
        return this.alternateDescription;
    }

    public String getAlternateDescriptionShort() {
        return this.alternateDescriptionShort;
    }

    public String[] getShortDescriptions() {
        return this.shortDescriptions;
    }

    public Date getGameStart() {
        return this.gameStart;
    }

    public String getHoliday() {
        return this.holiday;
    }

    public String getMd5() {
        return this.md5;
    }

    public ContentRating[] getRatings() {
        return this.ratings;
    }

    public String getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public String getStudio() {
        return this.studio;
    }

    public int getRunTime() {
        return this.runTime;
    }

    public String getStarRating() {
        return this.starRating;
    }

    public float getStarRatingValue() {
        return this.starRatingValue;
    }

    protected float calcStarValue() throws ParseException {
        if (this.starRating == null || this.starRating.length() == 0) {
            return 0.0f;
        }
        float val = 0.0f;
        block4: for (int i = 0; i < this.starRating.length(); ++i) {
            char c = this.starRating.charAt(i);
            switch (c) {
                case '*': {
                    val += 1.0f;
                    continue block4;
                }
                case '+': {
                    val += 0.5f;
                    if (i == this.starRating.length() - 1) continue block4;
                    throw new ParseException(String.format("Invalid format: can only be one '+' character and it must be last! [%s]", this.starRating), i);
                }
                default: {
                    throw new ParseException(String.format("Invalid character in star rating! [%s]", Character.toString(c)), i);
                }
            }
        }
        if (val > 4.0f) {
            throw new ParseException(String.format("Star rating too high: %f [%s]", Float.valueOf(val), this.starRating), 0);
        }
        return val;
    }

    public String getEpisodeNumber() {
        return this.episodeNumber;
    }

    public String[] getShortTitles() {
        return this.shortTitles;
    }

    public int getYear() {
        return this.year;
    }

    public String toString() {
        int maxLen = 2;
        return "Program [id=" + this.id + ", madeForTv=" + this.madeForTv + ", description=" + this.description + ", episodeTitle=" + this.episodeTitle + ", title=" + this.title + ", originalAirDate=" + this.originalAirDate + ", descriptionLanguage=" + this.descriptionLanguage + ", sourceType=" + (Object)((Object)this.sourceType) + ", syndicatedEpisodeNumber=" + this.syndicatedEpisodeNumber + ", colorCode=" + (Object)((Object)this.colorCode) + ", advisories=" + (this.advisories != null ? Arrays.asList(this.advisories).subList(0, Math.min(this.advisories.length, 2)) : null) + ", alternateEpisodeNumber=" + this.alternateEpisodeNumber + ", alternateTitle=" + this.alternateTitle + ", credits=" + (this.credits != null ? Arrays.asList(this.credits).subList(0, Math.min(this.credits.length, 2)) : null) + ", alternateDescription=" + this.alternateDescription + ", alternateDescriptionShort=" + this.alternateDescriptionShort + ", shortDescriptions=" + (this.shortDescriptions != null ? Arrays.asList(this.shortDescriptions).subList(0, Math.min(this.shortDescriptions.length, 2)) : null) + ", gameStart=" + this.gameStart + ", holiday=" + this.holiday + ", md5=" + this.md5 + ", ratings=" + (this.ratings != null ? Arrays.asList(this.ratings).subList(0, Math.min(this.ratings.length, 2)) : null) + ", countryOfOrigin=" + this.countryOfOrigin + ", studio=" + this.studio + ", runTime=" + this.runTime + ", starRating=" + this.starRating + ", starRatingValue=" + this.starRatingValue + ", episodeNumber=" + this.episodeNumber + ", shortTitles=" + (this.shortTitles != null ? Arrays.asList(this.shortTitles).subList(0, Math.min(this.shortTitles.length, 2)) : null) + ", year=" + this.year + ", genres=" + (this.genres != null ? Arrays.asList(this.genres).subList(0, Math.min(this.genres.length, 2)) : null) + ", metadata=" + (this.metadata != null ? this.metadata.subList(0, Math.min(this.metadata.size(), 2)) : null) + ", seriesDescription=" + this.seriesDescription + "]";
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMadeForTv(boolean madeForTv) {
        this.madeForTv = madeForTv;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEpisodeTitle(String episodeTitle) {
        this.episodeTitle = episodeTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOriginalAirDate(Date originalAirDate) {
        this.originalAirDate = originalAirDate;
    }

    public void setDescriptionLanguage(String descriptionLanguage) {
        this.descriptionLanguage = descriptionLanguage;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setSyndicatedEpisodeNumber(String syndicatedEpisodeNumber) {
        this.syndicatedEpisodeNumber = syndicatedEpisodeNumber;
    }

    public void setColorCode(ColorCode colorCode) {
        this.colorCode = colorCode;
    }

    public void setAdvisories(String[] advisories) {
        this.advisories = advisories;
    }

    public void setAlternateEpisodeNumber(String alternateEpisodeNumber) {
        this.alternateEpisodeNumber = alternateEpisodeNumber;
    }

    public void setAlternateTitle(String alternateTitle) {
        this.alternateTitle = alternateTitle;
    }

    public void setCredits(Credit[] credits) {
        this.credits = credits;
    }

    public void setAlternateDescription(String alternateDescription) {
        this.alternateDescription = alternateDescription;
    }

    public void setAlternateDescriptionShort(String alternateDescriptionShort) {
        this.alternateDescriptionShort = alternateDescriptionShort;
    }

    public void setShortDescriptions(String[] shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
    }

    public void setGameStart(Date gameStart) {
        this.gameStart = gameStart;
    }

    public void setHoliday(String holiday) {
        this.holiday = holiday;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setRatings(ContentRating[] ratings) {
        this.ratings = ratings;
    }

    public void setCountryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
    }

    public void setStudio(String studio) {
        this.studio = studio;
    }

    public void setRunTime(int runTime) {
        this.runTime = runTime;
    }

    public void setStarRating(String starRating) throws ParseException {
        this.starRating = starRating;
        this.starRatingValue = this.calcStarValue();
    }

    public void setEpisodeNumber(String episodeNumber) {
        this.episodeNumber = episodeNumber;
    }

    public void setShortTitles(String[] shortTitles) {
        this.shortTitles = shortTitles;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setGenres(String[] genres) {
        this.genres = genres;
    }

    public void setMetadata(List<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Program)) {
            return false;
        }
        Program other = (Program)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setSeriesDescription(String seriesDescription) {
        this.seriesDescription = seriesDescription;
    }

    static {
        ORIG_FMT.setTimeZone(TimeZone.getDefault());
        MOVIE_REGEX = Pattern.compile("Feature Film|.*Movie");
        WARNED_SRC_TYPES = new HashSet<String>();
        WARNED_COLOR_CODES = new HashSet<String>();
    }

    public static class Credit {
        private Role role;
        private String name;

        private Credit(JSONObject src) throws JSONException {
            Role r = null;
            String roleStr = src.getString("role");
            String name = src.getString("name");
            try {
                r = Role.valueOf(roleStr.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)String.format("Unknown Role encountered! [%s]", roleStr));
                r = Role.UNKNOWN;
            }
            this.role = r;
            this.name = name;
        }

        public Role getRole() {
            return this.role;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Credit [role=");
            builder.append((Object)this.role);
            builder.append(", name=");
            builder.append(this.name);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum Role {
        UNKNOWN,
        ACTOR,
        ANCHOR,
        CONTESTANT,
        CORRESPONDENT,
        DIRECTOR,
        EXECUTIVE_PRODUCER,
        GUEST_STAR,
        GUEST,
        HOST,
        JUDGE,
        MUSICAL_GUEST,
        NARRATOR,
        PRODUCER,
        WRITER;

    }

    public static enum SourceType {
        NONE,
        LOCAL,
        SYNDICATED,
        NETWORK,
        BLOCK,
        UNKNOWN;

    }

    public static enum ColorCode {
        NONE,
        COLOR,
        BW,
        COLOR_AND_BW,
        COLORIZED,
        UNKNOWN;

    }
}

