/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;

public class SystemStatus {
    private Date statusDate;
    private String status;
    private String statusMessage;

    SystemStatus(JSONArray src) throws InvalidJsonObjectException {
        for (int i = 0; i < src.length(); ++i) {
            try {
                JSONObject obj = src.getJSONObject(i);
                Date objDate = Config.get().getDateTimeFormat().parse(obj.getString("date"));
                if (this.statusDate != null && !this.statusDate.before(objDate)) continue;
                this.statusDate = objDate;
                this.status = obj.getString("status");
                this.statusMessage = obj.getString("details");
                continue;
            }
            catch (Exception e) {
                throw new InvalidJsonObjectException(String.format("SystemStatus: %s", e.getMessage()), e, src.toString(3));
            }
        }
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String toString() {
        return "SystemStatus [statusDate=" + this.statusDate + ", status=" + this.status + ", statusMessage=" + this.statusMessage + "]";
    }
}

