/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.Message;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;

public class UserStatus {
    private String userId;
    private Date expires;
    private Date lastServerRefresh;
    private Date nextSuggestedConnectTime;
    private Message[] userMessages;
    private Message[] systemMessages;
    private Map<String, Date> lineupInfo;
    private String jsonEncoding;
    private int maxLineups;

    UserStatus(JSONObject src, String userId, EpgClient clnt) throws InvalidJsonObjectException {
        try {
            int i;
            this.userId = userId != null ? userId : src.getString("userId");
            JSONObject acct = src.getJSONObject("account");
            SimpleDateFormat fmt = Config.get().getDateTimeFormat();
            this.nextSuggestedConnectTime = fmt.parse(acct.getString("nextSuggestedConnectTime"));
            this.expires = fmt.parse(acct.getString("expires"));
            JSONArray msgs = acct.getJSONArray("messages");
            this.userMessages = new Message[msgs.length()];
            for (i = 0; i < msgs.length(); ++i) {
                this.userMessages[i] = new Message(msgs.getJSONObject(i), clnt);
            }
            this.lastServerRefresh = fmt.parse(src.getString("lastDataUpdate"));
            msgs = src.getJSONArray("notifications");
            this.systemMessages = new Message[msgs.length()];
            for (i = 0; i < msgs.length(); ++i) {
                this.systemMessages[i] = new Message(msgs.getJSONObject(i), clnt);
            }
            this.lineupInfo = new HashMap<String, Date>();
            msgs = src.getJSONArray("lineups");
            for (i = 0; i < msgs.length(); ++i) {
                JSONObject lineupInfo = msgs.getJSONObject(i);
                this.lineupInfo.put(lineupInfo.getString("ID"), fmt.parse(lineupInfo.getString("modified")));
            }
            this.maxLineups = acct.getInt("maxLineups");
            JSONObject clone = new JSONObject(src.toString());
            clone.put("userId", (Object)this.userId);
            this.jsonEncoding = clone.toString(3);
        }
        catch (ParseException | JSONException e) {
            throw new InvalidJsonObjectException(String.format("UserStatus[%s]: %s", this.userId, e.getMessage()), e, src.toString(3));
        }
    }

    public String toJson() {
        return this.jsonEncoding;
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean isExpired() {
        return this.expires.getTime() < System.currentTimeMillis();
    }

    public boolean isNewDataAvailable(Date lastDownload) {
        return lastDownload != null && lastDownload.before(this.lastServerRefresh);
    }

    public Date getLastServerRefresh() {
        return this.lastServerRefresh;
    }

    public String toString() {
        int maxLen = 2;
        StringBuilder builder = new StringBuilder();
        builder.append("UserStatus [userId=");
        builder.append(this.userId);
        builder.append(", expires=");
        builder.append(this.expires);
        builder.append(", lastServerRefresh=");
        builder.append(this.lastServerRefresh);
        builder.append(", nextSuggestedConnectTime=");
        builder.append(this.nextSuggestedConnectTime);
        builder.append(", userMessages=");
        builder.append(this.userMessages != null ? Arrays.asList(this.userMessages).subList(0, Math.min(this.userMessages.length, 2)) : null);
        builder.append(", systemMessages=");
        builder.append(this.systemMessages != null ? Arrays.asList(this.systemMessages).subList(0, Math.min(this.systemMessages.length, 2)) : null);
        builder.append(", lineupInfo=");
        builder.append(this.lineupInfo != null ? this.toString(this.lineupInfo.entrySet(), 2) : null);
        builder.append(", jsonEncoding=");
        builder.append(this.jsonEncoding);
        builder.append(", maxLineups=");
        builder.append(this.maxLineups);
        builder.append("]");
        return builder.toString();
    }

    public Message[] getUserMessages() {
        return this.userMessages;
    }

    public Message[] getSystemMessages() {
        return this.systemMessages;
    }

    public Map<String, Date> getLineupInfo() {
        HashMap<String, Date> map = new HashMap<String, Date>();
        for (String k : this.lineupInfo.keySet()) {
            map.put(k, (Date)this.lineupInfo.get(k).clone());
        }
        return map;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getMaxLineups() {
        return this.maxLineups;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public Date getNextSuggestedConnectTime() {
        return this.nextSuggestedConnectTime;
    }
}

