/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.HttpRequestBase;
import org.schedulesdirect.api.Config;

public final class HttpUtils {
    private static final Log LOG = LogFactory.getLog(HttpUtils.class);
    private static Path AUDIT_LOG;
    private static volatile boolean auditSetup;

    private static void setupAudit() {
        try {
            Path root = Paths.get(Config.get().captureRoot().getAbsolutePath(), "http");
            Files.createDirectories(root, new FileAttribute[0]);
            AUDIT_LOG = Files.createTempFile(root, String.format("%s_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())), ".log", new FileAttribute[0]);
            auditSetup = true;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to create HTTP audit log!", (Throwable)e);
            AUDIT_LOG = null;
        }
    }

    public static String prettyPrintHeaders(Header[] input) {
        return HttpUtils.prettyPrintHeaders(input, "");
    }

    public static String prettyPrintHeaders(Header[] input, String prefix) {
        StringBuilder sb = new StringBuilder();
        for (Header h : input) {
            sb.append(String.format("%s%s: %s%n", prefix, h.getName(), h.getValue()));
        }
        return sb.toString();
    }

    public static Header[] scrapeHeaders(Request r) {
        try {
            Field f = r.getClass().getDeclaredField("request");
            f.setAccessible(true);
            HttpRequestBase req = (HttpRequestBase)f.get(r);
            return req.getAllHeaders();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.error((Object)"Error accessing request headers!", (Throwable)e);
            return new Header[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void captureToDisk(String msg) {
        Config conf = Config.get();
        if (!conf.captureHttpComm()) return;
        if (!auditSetup) {
            HttpUtils.setupAudit();
        }
        try {
            if (AUDIT_LOG == null) return;
            Class<HttpUtils> clazz = HttpUtils.class;
            synchronized (HttpUtils.class) {
                Files.write(AUDIT_LOG, msg.getBytes("UTF-8"), StandardOpenOption.APPEND, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to write capture file, logging at trace level instead!", (Throwable)e);
            LOG.trace((Object)msg);
        }
    }

    public static Path captureContentToDisk(InputStream ins) {
        Path f;
        Config conf = Config.get();
        Path p = Paths.get(conf.captureRoot().getAbsolutePath(), "http", "content");
        try {
            Files.createDirectories(p, new FileAttribute[0]);
            f = Files.createTempFile(p, "sdjson_content_", ".dat", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to create http content file!", (Throwable)e);
            return null;
        }
        try (FileOutputStream os = new FileOutputStream(f.toFile());){
            IOUtils.copy((InputStream)ins, (OutputStream)os);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to write http content to file!", (Throwable)e);
            return null;
        }
        return f;
    }

    private HttpUtils() {
    }

    static {
        auditSetup = false;
    }
}

