/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api.exception;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schedulesdirect.api.Config;

public class InvalidJsonObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(InvalidJsonObjectException.class);
    private static volatile boolean targetCleaned = false;
    private String src;

    public InvalidJsonObjectException(String message, String src) {
        super(message);
        this.src = src;
        this.capture();
    }

    public InvalidJsonObjectException(Throwable cause, String src) {
        super(cause);
        this.src = src;
        this.capture();
    }

    public InvalidJsonObjectException(String message, Throwable cause, String src) {
        super(message, cause);
        this.src = src;
        this.capture();
    }

    protected void capture() {
        Config conf = Config.get();
        if (conf.captureJsonParseErrors()) {
            String msg = this.generateMsg();
            try {
                Path p = Paths.get(conf.captureRoot().getAbsolutePath(), "json");
                if (!targetCleaned && Files.exists(p, new LinkOption[0])) {
                    try {
                        FileUtils.deleteDirectory((File)p.toFile());
                    }
                    catch (IOException e) {
                        LOG.warn((Object)String.format("Unable to clean target dir! [%s]", p));
                    }
                }
                targetCleaned = true;
                Files.createDirectories(p, new FileAttribute[0]);
                Path f = Files.createTempFile(p, this.prefix(), ".err", new FileAttribute[0]);
                Files.write(f, msg.getBytes("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to write capture file, logging it instead!", (Throwable)e);
                LOG.error((Object)String.format("Invalid JSON received!%n%s", msg), (Throwable)this);
            }
        }
    }

    private String prefix() {
        return String.format("%s_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
    }

    private String generateMsg() {
        StringWriter sw = new StringWriter();
        sw.append(String.format("*** S T A C K  T R A C E ***%n", new Object[0]));
        try (PrintWriter pw = new PrintWriter(sw);){
            this.printStackTrace(pw);
        }
        sw.append(String.format("%n*** I N P U T ***%n%s", this.src));
        return sw.toString();
    }
}

