/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.schedulesdirect.api.utils.HttpUtils;

public final class JsonRequest {
    private static final Log LOG = LogFactory.getLog(JsonRequest.class);
    private String baseUrl;
    private String hash;
    private String userAgent;
    private String targetUrl;
    private String resource;
    private Action action;
    private boolean valid;
    private StringBuilder audit;

    JsonRequest(Action action, String resource, String hash, String userAgent, String baseUrl) {
        this.hash = hash;
        this.userAgent = userAgent;
        this.targetUrl = null;
        this.resource = resource;
        this.baseUrl = String.format("%s/%s/%s", baseUrl != null ? baseUrl : "https://json.schedulesdirect.org", 20131021, this.resource);
        this.action = action;
        this.valid = true;
        this.audit = new StringBuilder(String.format("[[[ START REQUEST: %s%n", new Date()));
    }

    JsonRequest(Action action, String resource) {
        this(action, resource, null, null, null);
        this.valid = false;
    }

    private Request initRequest() {
        Request r = null;
        switch (this.action) {
            case GET: {
                r = Request.Get((String)this.baseUrl);
                break;
            }
            case PUT: {
                r = Request.Put((String)this.baseUrl);
                break;
            }
            case POST: {
                r = Request.Post((String)this.baseUrl);
                break;
            }
            case DELETE: {
                r = Request.Delete((String)this.baseUrl);
                break;
            }
            case OPTIONS: {
                r = Request.Options((String)this.baseUrl);
                break;
            }
            case HEAD: {
                r = Request.Head((String)this.baseUrl);
            }
        }
        return r.userAgent(this.userAgent);
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    /*
     * Exception decompiling
     */
    public String submitForJson(Object reqData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public InputStream submitForInputStream(Object reqData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream submitRaw(Object reqData) throws IOException {
        if (!this.valid) {
            throw new IllegalStateException("Cannot submit a partially constructed request!");
        }
        try {
            this.targetUrl = this.baseUrl.toString();
            this.audit.append(String.format(">>>target: %s%n>>>verb: %s%n", new Object[]{this.targetUrl, this.action}));
            Executor exe = Executor.newInstance((HttpClient)new DecompressingHttpClient((HttpClient)new DefaultHttpClient()));
            Request req = this.initRequest();
            if (this.hash != null) {
                req.addHeader((Header)new BasicHeader("token", this.hash));
            }
            if (reqData != null) {
                req.bodyString(reqData.toString(), ContentType.APPLICATION_JSON);
            }
            this.audit.append(String.format(">>>req_headers:%n%s", HttpUtils.prettyPrintHeaders(HttpUtils.scrapeHeaders(req), "\t")));
            if (this.action == Action.PUT || this.action == Action.POST) {
                this.audit.append(String.format(">>>input: %s%n", reqData));
            }
            HttpResponse resp = exe.execute(req).returnResponse();
            if (LOG.isDebugEnabled()) {
                Header h = resp.getFirstHeader("Schedulesdirect-Serverid");
                String val = h != null ? h.getValue() : "[Unknown]";
                LOG.debug((Object)String.format("Request to '%s' handled by: %s", this.targetUrl, val));
            }
            StatusLine status = resp.getStatusLine();
            this.audit.append(String.format("<<<resp_status: %s%n", status));
            this.audit.append(String.format("<<<resp_headers:%n%s", HttpUtils.prettyPrintHeaders(resp.getAllHeaders(), "\t")));
            if (status.getStatusCode() != 200) {
                LOG.debug((Object)String.format("%s returned error! [rc=%d]", req, status.getStatusCode()));
            }
            return resp.getEntity().getContent();
        }
        catch (IOException e) {
            this.audit.append(String.format("*** REQUEST FAILED! ***%n%s", e.getMessage()));
            throw e;
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getHash() {
        return this.hash;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getResource() {
        return this.resource;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

