/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.schedulesdirect.api.Airing;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.EpgClientHelper;
import org.schedulesdirect.api.Lineup;
import org.schedulesdirect.api.Message;
import org.schedulesdirect.api.Program;
import org.schedulesdirect.api.Station;
import org.schedulesdirect.api.SystemStatus;
import org.schedulesdirect.api.UserStatus;

public abstract class EpgClient {
    public static final int API_VERSION = 20131021;
    private String userAgent;
    private String baseUrl;

    public static String getUriPathForLineupId(String id) {
        return String.format("/%s/lineups/%s", 20131021, id);
    }

    public EpgClient(String userAgent, String baseUrl) {
        this.userAgent = userAgent;
        this.baseUrl = baseUrl != null ? baseUrl : "https://json.schedulesdirect.org";
    }

    public final Lineup[] getLineups(String location, String zip) throws IOException {
        return this.searchForLineups(location, zip);
    }

    protected abstract Lineup[] searchForLineups(String var1, String var2) throws IOException;

    public abstract Lineup[] getLineups() throws IOException;

    public abstract Lineup getLineupByUriPath(String var1) throws IOException;

    public abstract UserStatus getUserStatus() throws IOException;

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return String.format("%ssdjson/%s (%s Java %s)", this.userAgent != null && this.userAgent.length() > 0 ? this.userAgent + " " : "", Config.API_VERSION, System.getProperty("java.vendor"), System.getProperty("java.version"));
    }

    public abstract void close() throws IOException;

    protected abstract Airing[] fetchSchedule(Station var1) throws IOException;

    protected abstract String fetchChannelMapping(Lineup var1) throws IOException;

    protected abstract InputStream fetchLogoStream(Station var1) throws IOException;

    protected void writeLogoToFile(Station station, File dest) throws IOException {
        try (InputStream ins = this.fetchLogoStream(station);){
            EpgClientHelper.writeLogoToFile(ins, dest);
        }
    }

    protected abstract Program fetchProgram(String var1) throws IOException;

    protected abstract Map<Station, Airing[]> fetchSchedules(Lineup var1) throws IOException;

    protected abstract Map<String, Program> fetchPrograms(String[] var1) throws IOException;

    public abstract void purgeCache();

    public abstract void purgeCache(Object var1);

    public abstract void deleteMessage(Message var1) throws IOException;

    public abstract SystemStatus getSystemStatus() throws IOException;

    public abstract int registerLineup(String var1) throws IOException;

    public abstract int unregisterLineup(Lineup var1) throws IOException;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUri(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

