/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Airing;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.Lineup;
import org.schedulesdirect.api.Message;
import org.schedulesdirect.api.Program;
import org.schedulesdirect.api.Station;
import org.schedulesdirect.api.SystemStatus;
import org.schedulesdirect.api.UserStatus;
import org.schedulesdirect.api.exception.InvalidCredentialsException;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.JsonEncodingException;
import org.schedulesdirect.api.exception.ServiceOfflineException;
import org.schedulesdirect.api.exception.SilentInvalidJsonObjectException;
import org.schedulesdirect.api.json.IJsonRequestFactory;
import org.schedulesdirect.api.json.JsonRequest;
import org.schedulesdirect.api.json.JsonRequestFactory;
import org.schedulesdirect.api.utils.JsonResponseUtils;
import org.schedulesdirect.api.utils.UriUtils;

public class NetworkEpgClient
extends EpgClient {
    private static final Map<String, Object> CACHE = Collections.synchronizedMap(new HashMap());
    private String id;
    private String password;
    private String hash;
    private UserStatus userStatus;
    private boolean useCache;
    private SystemStatus systemStatus;
    private IJsonRequestFactory factory;

    private static String getCacheKey(Object obj) {
        if (obj instanceof Program) {
            return NetworkEpgClient.getCacheKeyForProgram(((Program)obj).getId());
        }
        if (obj instanceof Station) {
            return NetworkEpgClient.getCacheKeyForStation(((Station)obj).getId());
        }
        return null;
    }

    private static String getCacheKeyForProgram(String progId) {
        return "__PROG__" + progId;
    }

    private static String getCacheKeyForStation(String stationId) {
        return "__STAT__" + stationId;
    }

    public NetworkEpgClient(String id, String pwd) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        this(id, pwd, null, null, true, JsonRequestFactory.get());
    }

    public NetworkEpgClient(String id, String pwd, IJsonRequestFactory factory) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        this(id, pwd, null, null, true, factory);
    }

    public NetworkEpgClient(String id, String pwd, String userAgent) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        this(id, pwd, userAgent, null, true, JsonRequestFactory.get());
    }

    public NetworkEpgClient(String id, String pwd, String userAgent, IJsonRequestFactory factory) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        this(id, pwd, userAgent, null, true, factory);
    }

    public NetworkEpgClient(String id, String pwd, String userAgent, String baseUrl, boolean useCache) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        this(id, pwd, userAgent, baseUrl, useCache, JsonRequestFactory.get());
    }

    public NetworkEpgClient(String id, String pwd, String userAgent, String baseUrl, boolean useCache, IJsonRequestFactory factory) throws InvalidCredentialsException, IOException, ServiceOfflineException {
        super(userAgent, baseUrl);
        this.factory = factory;
        if (id == null || id.length() == 0) {
            throw new InvalidCredentialsException("Schedules Direct username cannot be empty!");
        }
        if (pwd == null || pwd.length() == 0) {
            throw new InvalidCredentialsException("Schedules Direct password cannot be empty!");
        }
        this.id = id;
        this.password = pwd;
        this.hash = null;
        this.userStatus = null;
        this.useCache = useCache;
        this.authorize();
    }

    public IJsonRequestFactory getJsonRequestFactory() {
        return this.factory;
    }

    protected void authorize() throws InvalidJsonObjectException, InvalidCredentialsException, IOException, ServiceOfflineException {
        JSONObject resp;
        JSONObject creds = new JSONObject();
        creds.put("username", (Object)this.id);
        creds.put("password", (Object)DigestUtils.shaHex((String)this.password));
        String input = this.factory.get(JsonRequest.Action.POST, "token", this.hash, this.getUserAgent(), this.getBaseUrl()).submitForJson(creds);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Token: %s", e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            try {
                this.hash = resp.getString("token");
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("Token: %s", e.getMessage()), e, resp.toString(3));
            }
        } else {
            if (resp.optInt("code", -1) == 3000) {
                throw new ServiceOfflineException(resp.optString("message"));
            }
            throw new InvalidCredentialsException(resp.optString("message"));
        }
    }

    protected void initStatusObjects() throws IOException {
        JSONObject resp;
        String input = this.factory.get(JsonRequest.Action.GET, "status", this.hash, this.getUserAgent(), this.getBaseUrl()).submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Status[%s]: %s", this.id, e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            this.userStatus = new UserStatus(resp, this.id, this);
            try {
                this.systemStatus = new SystemStatus(resp.getJSONArray("systemStatus"));
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("Status[%s]: %s", this.id, e.getMessage()), e, resp.toString(3));
            }
        } else {
            throw new IOException(resp.optString("message"));
        }
    }

    @Override
    public UserStatus getUserStatus() throws IOException {
        if (this.userStatus == null) {
            this.initStatusObjects();
        }
        return this.userStatus;
    }

    @Override
    public Lineup[] getLineups() throws IOException {
        JSONObject resp;
        Lineup[] list = null;
        String input = this.factory.get(JsonRequest.Action.GET, "lineups", this.hash, this.getUserAgent(), this.getBaseUrl()).submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Lineups[%s]: %s", this.id, e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            try {
                JSONArray lineups = resp.getJSONArray("lineups");
                list = new Lineup[lineups.length()];
                for (int i = 0; i < lineups.length(); ++i) {
                    JSONObject lineup = lineups.getJSONObject(i);
                    list[i] = new Lineup(lineup.getString("name"), lineup.getString("location"), lineup.getString("uri"), lineup.getString("type"), this);
                }
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("Lineups[%s]: %s", this.id, e.getMessage()), e, resp.toString(3));
            }
        } else if (JsonResponseUtils.getErrorCode(resp) != 4102) {
            throw new IOException(String.format("Error getting lineups! [%s]", resp.optString("message")));
        }
        return list;
    }

    @Override
    protected Lineup[] searchForLineups(String location, String zip) throws IOException {
        JSONObject resp;
        ArrayList<Lineup> hes = new ArrayList<Lineup>();
        String input = this.factory.get(JsonRequest.Action.GET, String.format("%s?country=%s&postalcode=%s", "headends", URLEncoder.encode(location, "UTF-8"), URLEncoder.encode(zip, "UTF-8")), this.hash, this.getUserAgent(), this.getBaseUrl()).submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("SearchResp: %s", e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            try {
                Iterator itr = resp.keys();
                while (itr.hasNext()) {
                    String k = (String)itr.next();
                    JSONObject headend = resp.getJSONObject(k);
                    String heLoc = headend.getString("location");
                    String heType = headend.getString("type");
                    JSONArray lineups = headend.getJSONArray("lineups");
                    for (int i = 0; i < lineups.length(); ++i) {
                        JSONObject lineup = lineups.getJSONObject(i);
                        hes.add(new Lineup(lineup.getString("name"), heLoc, lineup.getString("uri"), heType, this));
                    }
                }
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("SearchResp: %s", e.getMessage()), e, resp.toString(3));
            }
        }
        return hes.toArray(new Lineup[hes.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHash() {
        return this.hash;
    }

    @Override
    public void close() throws IOException {
        this.purgeCache();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public InputStream submitRequest(JsonRequest req, Object data) throws IOException {
        JsonRequest scrubbedReq = this.factory.get(req.getAction(), req.getResource(), this.getHash(), this.getUserAgent(), this.getBaseUrl());
        return scrubbedReq.submitForInputStream(data);
    }

    @Override
    protected Airing[] fetchSchedule(Station station) throws IOException {
        Airing[] sched = null;
        if (this.useCache) {
            sched = (Airing[])CACHE.get(NetworkEpgClient.getCacheKey(station));
        }
        if (sched == null) {
            ArrayList<Airing> schedList = new ArrayList<Airing>();
            JSONArray ids = new JSONArray();
            ids.put((Object)station.getId());
            JSONObject reqObj = new JSONObject();
            reqObj.put("request", (Object)ids);
            JsonRequest req = this.factory.get(JsonRequest.Action.POST, "schedules", this.hash, this.getUserAgent(), this.getBaseUrl());
            InputStream ins = req.submitForInputStream(reqObj);
            List input = IOUtils.readLines((InputStream)ins);
            for (String obj : input) {
                JSONObject o;
                try {
                    o = new JSONObject(obj);
                }
                catch (JSONException e) {
                    throw new JsonEncodingException(String.format("ScheduleResp: %s", e.getMessage()), e, obj);
                }
                if (JsonResponseUtils.isErrorResponse(o)) continue;
                try {
                    JSONArray progs = o.getJSONArray("programs");
                    for (int i = 0; i < progs.length(); ++i) {
                        JSONObject p = progs.getJSONObject(i);
                        if (JsonResponseUtils.isErrorResponse(p)) continue;
                        schedList.add(new Airing(p, this.fetchProgram(p.getString("programID")), station));
                    }
                }
                catch (JSONException e) {
                    throw new InvalidJsonObjectException(String.format("", new Object[0]), e, o.toString(3));
                }
            }
        }
        return sched;
    }

    @Override
    protected Program fetchProgram(String progId) throws IOException {
        return this.fetchPrograms(new String[]{progId}).values().toArray(new Program[1])[0];
    }

    private void prefetch(JSONArray airings) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            for (int i = 0; i < airings.length(); ++i) {
                ids.add(airings.getJSONObject(i).getString("programID"));
            }
        }
        catch (JSONException e) {
            throw new SilentInvalidJsonObjectException(e);
        }
        this.fetchPrograms(ids.toArray(new String[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map<Station, Airing[]> fetchSchedules(Lineup lineup) throws IOException {
        ArrayList<String> misses = new ArrayList<String>();
        HashMap<Station, Airing[]> scheds = new HashMap<Station, Airing[]>();
        if (this.useCache) {
            for (Station s : lineup.getStations()) {
                Airing[] sched = (Airing[])CACHE.get(NetworkEpgClient.getCacheKey(s));
                if (sched != null) {
                    scheds.put(s, sched);
                    continue;
                }
                misses.add(s.getId());
            }
        } else {
            for (Station s : lineup.getStations()) {
                misses.add(s.getId());
            }
        }
        if (misses.size() <= 0) return scheds;
        JSONObject reqObj = new JSONObject();
        reqObj.put("request", misses);
        try (InputStream resp = this.factory.get(JsonRequest.Action.POST, "schedules", this.hash, this.getUserAgent(), this.getBaseUrl()).submitForInputStream(reqObj);){
            for (String input : IOUtils.readLines((InputStream)resp)) {
                JSONObject sched;
                try {
                    sched = new JSONObject(input);
                }
                catch (JSONException e) {
                    throw new JsonEncodingException(String.format("Schedule: %s", e.getMessage()), e, input);
                }
                try {
                    Station s = lineup.getStation(sched.getString("stationID"));
                    JSONArray airs = sched.getJSONArray("programs");
                    if (this.useCache) {
                        this.prefetch(airs);
                    }
                    ArrayList<Airing> result = new ArrayList<Airing>();
                    for (int i = 0; i < airs.length(); ++i) {
                        JSONObject a = airs.getJSONObject(i);
                        Program p = this.fetchProgram(a.getString("programID"));
                        result.add(new Airing(a, p, s));
                    }
                    scheds.put(s, result.toArray(new Airing[0]));
                    if (!this.useCache) continue;
                    CACHE.put(NetworkEpgClient.getCacheKeyForStation(s.getId()), s);
                }
                catch (JSONException e) {
                    throw new InvalidJsonObjectException(String.format("Schedule: %s", e.getMessage()), e, sched.toString(3));
                    return scheds;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map<String, Program> fetchPrograms(String[] progIds) throws IOException {
        ArrayList<String> misses = new ArrayList<String>();
        HashMap<String, Program> progs = new HashMap<String, Program>();
        if (this.useCache) {
            for (String progId : progIds) {
                Program p = (Program)CACHE.get(NetworkEpgClient.getCacheKeyForProgram(progId));
                if (p != null) {
                    progs.put(progId, p);
                    continue;
                }
                misses.add(progId);
            }
        } else {
            misses.addAll(Arrays.asList(progIds));
        }
        if (misses.size() <= 0) return progs;
        JSONObject req = new JSONObject();
        req.put("request", (Object)new JSONArray(misses));
        try (InputStream resp = this.factory.get(JsonRequest.Action.POST, "programs", this.hash, this.getUserAgent(), this.getBaseUrl()).submitForInputStream(req);){
            for (String input : IOUtils.readLines((InputStream)resp)) {
                JSONObject prog;
                try {
                    prog = new JSONObject(input);
                }
                catch (JSONException e) {
                    throw new JsonEncodingException(String.format("Program: %s", e.getMessage()), e, input);
                }
                try {
                    Program p = new Program(prog, this);
                    String key = p.getId();
                    progs.put(p.getId(), p);
                    if (!this.useCache) continue;
                    CACHE.put(NetworkEpgClient.getCacheKeyForProgram(key), p);
                }
                catch (JSONException e) {
                    throw new InvalidJsonObjectException(String.format("", new Object[0]), e, prog.toString(3));
                    return progs;
                }
            }
        }
    }

    @Override
    public void purgeCache() {
        CACHE.clear();
    }

    @Override
    public void purgeCache(Object obj) {
        String k = NetworkEpgClient.getCacheKey(obj);
        if (k != null) {
            CACHE.remove(k);
        }
    }

    @Override
    public void deleteMessage(Message msg) throws IOException {
        JSONObject resp;
        JsonRequest req = this.factory.get(JsonRequest.Action.DELETE, String.format("%s/%s", "messages", msg.getId()), this.getHash(), this.getUserAgent(), this.getBaseUrl());
        String input = req.submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Message(DELETE): %s", e.getMessage()), e, input);
        }
        if (JsonResponseUtils.isErrorResponse(resp)) {
            throw new IOException(resp.optString("message"));
        }
    }

    @Override
    public SystemStatus getSystemStatus() throws IOException {
        if (this.systemStatus == null) {
            this.initStatusObjects();
        }
        return this.systemStatus;
    }

    @Override
    protected InputStream fetchLogoStream(Station station) throws IOException {
        return station.getLogo().getUrl().openStream();
    }

    @Override
    public int registerLineup(String path) throws IOException {
        JSONObject resp;
        JsonRequest req = this.factory.get(JsonRequest.Action.PUT, UriUtils.stripApiVersion(path), this.getHash(), this.getUserAgent(), this.getBaseUrl());
        String input = req.submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Lineup(REGISTER): %s", e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            try {
                return resp.getInt("changesRemaining");
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("Lineup(REGISTER): %s", e.getMessage()), e, resp.toString(3));
            }
        }
        throw new IOException(String.format("Error registering lineup! [%s]", resp.optString("message")));
    }

    @Override
    public int unregisterLineup(Lineup l) throws IOException {
        JSONObject resp;
        JsonRequest req = this.factory.get(JsonRequest.Action.DELETE, l.getUri(), this.getHash(), this.getUserAgent(), this.getBaseUrl());
        String input = req.submitForJson(null);
        try {
            resp = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("Lineup(DELETE): %s", e.getMessage()), e, input);
        }
        if (!JsonResponseUtils.isErrorResponse(resp)) {
            try {
                return resp.getInt("changesRemaining");
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("Lineup(DELETE): %s", e.getMessage()), e, resp.toString(3));
            }
        }
        throw new IOException(String.format("Error unregistering lineup! [%s]", resp.optString("message")));
    }

    @Override
    protected String fetchChannelMapping(Lineup lineup) throws IOException {
        return this.factory.get(JsonRequest.Action.GET, lineup.getUri(), this.getHash(), this.getUserAgent(), this.getBaseUrl()).submitForJson(null);
    }

    @Override
    public Lineup getLineupByUriPath(String path) throws IOException {
        for (Lineup l : this.getLineups()) {
            if (!l.getUri().equals(UriUtils.stripApiVersion(path))) continue;
            return l;
        }
        throw new IOException(String.format("Unable to locate lineup for path: %s", path));
    }
}

