/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.schedulesdirect.api.Airing;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.Program;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.SilentInvalidJsonObjectException;

public class Station {
    private static final Pattern DIM_REGEX = Pattern.compile("(w|h)=(\\d+)px");
    private String id;
    private String callsign;
    private String name;
    private String affiliate;
    private String broadcasterState;
    private String broadcasterCity;
    private String broadcasterZip;
    private String broadcasterCountry;
    private int uhfVhfNumber;
    private int atscMajorNumber;
    private int atscMinorNumber;
    private String language;
    private Airing[] airings;
    private Logo logo;
    private EpgClient epgClnt;

    private static int[] extractLogoDimensions(String src) {
        String[] data = src.split("\\|");
        if (data.length != 2) {
            throw new IllegalArgumentException("Invalid dim data!");
        }
        int[] dim = new int[2];
        block8: for (String s : data) {
            Matcher m = DIM_REGEX.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid dim data!");
            }
            String d = m.group(1);
            String i = m.group(2);
            switch (d) {
                case "w": {
                    dim[0] = Integer.parseInt(i);
                    continue block8;
                }
                case "h": {
                    dim[1] = Integer.parseInt(i);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Invalid dim data!");
                }
            }
        }
        if (dim[0] == 0 || dim[1] == 0) {
            throw new IllegalArgumentException("Invalid dim data!");
        }
        return dim;
    }

    Station(JSONObject src, JSONObject tuningDetails, EpgClient clnt) throws InvalidJsonObjectException {
        this.epgClnt = clnt;
        this.airings = null;
        try {
            this.id = src.getString("stationID");
            this.callsign = src.getString("callsign");
            this.name = src.getString("name");
            this.affiliate = src.optString("affiliate");
            JSONObject o = src.optJSONObject("broadcaster");
            if (o != null) {
                this.broadcasterState = o.optString("state");
                this.broadcasterCity = o.optString("city");
                this.broadcasterZip = o.optString("postalcode");
                this.broadcasterCountry = o.optString("country");
            } else {
                this.broadcasterState = "";
                this.broadcasterCity = "";
                this.broadcasterZip = "";
                this.broadcasterCountry = "";
            }
            this.logo = src.has("logo") ? new Logo(src.getJSONObject("logo")) : null;
            if (tuningDetails == null) {
                tuningDetails = new JSONObject();
            }
            this.uhfVhfNumber = tuningDetails.optInt("uhfVhf", 0);
            this.atscMajorNumber = tuningDetails.optInt("atscMajor", 0);
            this.atscMinorNumber = tuningDetails.optInt("atscMinor", 0);
            this.language = src.optString("language");
        }
        catch (Throwable t) {
            throw new InvalidJsonObjectException(String.format("Station[%s]: %s", this.id, t.getMessage()), t, String.format("src:%n%s%n%ntuning:%s", src.toString(3), tuningDetails.toString(3)));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCallsign() {
        return this.callsign;
    }

    public String getName() {
        return this.name;
    }

    public String getAffiliate() {
        return this.affiliate;
    }

    public String getBroadcasterState() {
        return this.broadcasterState;
    }

    public String getBroadcasterCity() {
        return this.broadcasterCity;
    }

    public String getBroadcasterZip() {
        return this.broadcasterZip;
    }

    public String getBroadcasterCountry() {
        return this.broadcasterCountry;
    }

    public int getUhfVhfNumber() {
        return this.uhfVhfNumber;
    }

    public int getAtscMajorNumber() {
        return this.atscMajorNumber;
    }

    public int getAtscMinorNumber() {
        return this.atscMinorNumber;
    }

    public String getPhysicalChannelNumber() {
        StringBuilder sb = new StringBuilder();
        if (this.uhfVhfNumber > 0) {
            sb.append(this.uhfVhfNumber);
            String logical = this.getLogicalChannelNumber();
            if (logical != null) {
                sb.append(String.format("-%s", logical));
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public String getLogicalChannelNumber() {
        return this.atscMajorNumber > 0 && this.atscMinorNumber > 0 ? String.format("%d-%d", this.atscMajorNumber, this.atscMinorNumber) : null;
    }

    public Airing[] getAirings() throws IOException {
        if (this.airings == null) {
            this.downloadProgramsAndAirings();
        }
        return this.airings;
    }

    public Program[] getPrograms() throws IOException {
        if (this.airings == null) {
            this.downloadProgramsAndAirings();
        }
        HashSet<Program> progs = new HashSet<Program>();
        for (Airing a : this.airings) {
            progs.add(a.getProgram());
        }
        return progs.toArray(new Program[0]);
    }

    protected void downloadProgramsAndAirings() throws IOException {
        this.airings = this.epgClnt.fetchSchedule(this);
    }

    public String toString() {
        int maxLen = 2;
        return "Station [id=" + this.id + ", callsign=" + this.callsign + ", name=" + this.name + ", affiliate=" + this.affiliate + ", broadcasterState=" + this.broadcasterState + ", broadcasterCity=" + this.broadcasterCity + ", broadcasterZip=" + this.broadcasterZip + ", broadcasterCountry=" + this.broadcasterCountry + ", uhfVhfNumber=" + this.uhfVhfNumber + ", atscMajorNumber=" + this.atscMajorNumber + ", atscMinorNumber=" + this.atscMinorNumber + ", airings=" + (this.airings != null ? Arrays.asList(this.airings).subList(0, Math.min(this.airings.length, 2)) : null) + ", logo=" + this.logo + ", epgClnt=" + this.epgClnt + "]";
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAffiliate(String affiliate) {
        this.affiliate = affiliate;
    }

    public void setBroadcasterState(String broadcasterState) {
        this.broadcasterState = broadcasterState;
    }

    public void setBroadcasterCity(String broadcasterCity) {
        this.broadcasterCity = broadcasterCity;
    }

    public void setBroadcasterZip(String broadcasterZip) {
        this.broadcasterZip = broadcasterZip;
    }

    public void setBroadcasterCountry(String broadcasterCountry) {
        this.broadcasterCountry = broadcasterCountry;
    }

    public void setUhfVhfNumber(int uhfVhfNumber) {
        this.uhfVhfNumber = uhfVhfNumber;
    }

    public void setAtscMajorNumber(int atscMajorNumber) {
        this.atscMajorNumber = atscMajorNumber;
    }

    public void setAtscMinorNumber(int atscMinorNumber) {
        this.atscMinorNumber = atscMinorNumber;
    }

    public void setAirings(Airing[] airings) {
        this.airings = airings;
        for (Airing a : airings) {
            a.setStation(this);
        }
    }

    public Logo getLogo() {
        return this.logo;
    }

    public void setLogo(Logo logo) {
        this.logo = logo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Station other = (Station)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public class Logo {
        private URL url;
        private int width;
        private int height;

        private Logo(JSONObject src) throws InvalidJsonObjectException {
            try {
                this.url = new URL(src.getString("URL"));
                int[] dim = Station.extractLogoDimensions(src.getString("dimension"));
                this.width = dim[0];
                this.height = dim[1];
            }
            catch (Throwable e) {
                throw new SilentInvalidJsonObjectException(e);
            }
        }

        public InputStream getImage() throws IOException {
            return Station.this.epgClnt.fetchLogoStream(Station.this);
        }

        public void writeImageToFile(File dest) throws IOException {
            Station.this.epgClnt.writeLogoToFile(Station.this, dest);
        }

        URL getUrl() {
            return this.url;
        }

        void setUrl(URL url) {
            this.url = url;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setLength(int height) {
            this.height = height;
        }

        public String toString() {
            return "Logo [url=" + this.url + ", width=" + this.width + ", height=" + this.height + "]";
        }
    }
}

