/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Airing;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.Lineup;
import org.schedulesdirect.api.Message;
import org.schedulesdirect.api.Program;
import org.schedulesdirect.api.Station;
import org.schedulesdirect.api.SystemStatus;
import org.schedulesdirect.api.UserStatus;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.JsonEncodingException;
import org.schedulesdirect.api.utils.UriUtils;

public class ZipEpgClient
extends EpgClient {
    private static final Log LOG = LogFactory.getLog(ZipEpgClient.class);
    public static final String ZIP_VER_FILE = "version.txt";
    public static final int ZIP_VER = 7;
    public static final Charset ZIP_CHARSET = Charset.forName("UTF-8");
    public static final String LINEUPS_LIST = "lineups.txt";
    public static final String USER_DATA = "user.txt";
    private static final Map<String, AtomicInteger> CLNT_COUNT = Collections.synchronizedMap(new HashMap());
    public static final String INVALID_FILE_CHARS = "[\\s\\\\\\/:\\*\\?\"<>\\|]";
    private File src;
    private FileSystem vfs;
    private Map<String, Lineup> lineups;
    private Map<String, Program> progCache;
    private boolean closed;
    private boolean detailsFetched;
    private boolean existingVfs;

    private static String getSrcZipKey(File src) {
        return src.getAbsolutePath();
    }

    public static String scrubFileName(String input) {
        return input.replaceAll(INVALID_FILE_CHARS, "_");
    }

    public ZipEpgClient(Path zip, String baseUrl) throws IOException {
        this(zip.toFile(), baseUrl);
    }

    public ZipEpgClient(File zip, String baseUrl) throws IOException {
        Throwable throwable;
        InputStream ins;
        block36: {
            URI fsUri;
            super(null, baseUrl);
            this.src = zip;
            this.progCache = new HashMap<String, Program>();
            try {
                fsUri = new URI(String.format("jar:%s", zip.toURI()));
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
            try {
                this.vfs = FileSystems.newFileSystem(fsUri, Collections.emptyMap());
                this.existingVfs = false;
            }
            catch (FileSystemAlreadyExistsException e) {
                this.vfs = FileSystems.getFileSystem(fsUri);
                this.existingVfs = true;
            }
            Path verFile = this.vfs.getPath(ZIP_VER_FILE, new String[0]);
            if (Files.exists(verFile, new LinkOption[0])) {
                ins = Files.newInputStream(verFile, new OpenOption[0]);
                throwable = null;
                try {
                    int ver = Integer.parseInt(IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString()));
                    if (ver != 7) {
                        throw new IOException(String.format("Zip file is not expected version! [v=%d; e=%d]", ver, 7));
                    }
                    break block36;
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (ins != null) {
                        if (throwable != null) {
                            try {
                                ins.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            ins.close();
                        }
                    }
                }
            }
            throw new IOException(String.format("Zip file of version %d required!", 7));
        }
        LOG.debug((Object)String.format("Zip file format validated! [version=%d]", 7));
        this.lineups = new HashMap<String, Lineup>();
        ins = Files.newInputStream(this.vfs.getPath(LINEUPS_LIST, new String[0]), new OpenOption[0]);
        throwable = null;
        try {
            JSONObject o;
            String input = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
            try {
                o = new JSONObject(input);
            }
            catch (JSONException e) {
                throw new JsonEncodingException(String.format("ZipLineups: %s", e.getMessage()), e, input);
            }
            try {
                JSONArray lineups = o.getJSONArray("lineups");
                for (int i = 0; i < lineups.length(); ++i) {
                    JSONObject l = lineups.getJSONObject(i);
                    this.lineups.put(l.getString("uri"), new Lineup(l.getString("name"), l.getString("location"), l.getString("uri"), l.getString("type"), this));
                }
            }
            catch (JSONException e) {
                throw new InvalidJsonObjectException(String.format("ZipLineups: %s", e.getMessage()), e, o.toString(3));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (ins != null) {
                if (throwable != null) {
                    try {
                        ins.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ins.close();
                }
            }
        }
        String vfsKey = ZipEpgClient.getSrcZipKey(zip);
        AtomicInteger i = CLNT_COUNT.get(vfsKey);
        if (i == null) {
            i = new AtomicInteger(0);
            CLNT_COUNT.put(vfsKey, i);
        }
        i.incrementAndGet();
        this.closed = false;
        this.detailsFetched = false;
    }

    public ZipEpgClient(Path zip) throws IOException {
        this(zip.toFile());
    }

    public ZipEpgClient(File zip) throws IOException {
        this(zip, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserStatus getUserStatus() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        String input = null;
        try (InputStream ins = Files.newInputStream(this.vfs.getPath(USER_DATA, new String[0]), new OpenOption[0]);){
            input = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
            UserStatus userStatus = new UserStatus(new JSONObject(input), null, this);
            return userStatus;
        }
        catch (JSONException e) {
            throw new JsonEncodingException(String.format("ZipUser: %s", e.getMessage()), e, input);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            int v;
            this.purgeCache();
            String vfsKey = ZipEpgClient.getSrcZipKey(this.src);
            AtomicInteger i = CLNT_COUNT.get(vfsKey);
            int n = v = i != null ? i.decrementAndGet() : 0;
            if (v == 0 && !this.existingVfs) {
                LOG.debug((Object)("Calling close() for " + vfsKey));
                this.vfs.close();
            } else if (this.existingVfs) {
                LOG.debug((Object)"Not closing filesystem object: created from getFileSystem()");
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Skipped close() for %s; c=%d", vfsKey, i != null ? i.get() : Integer.MIN_VALUE));
            }
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    protected Airing[] fetchSchedule(Station station) throws IOException {
        ArrayList<Airing> airs;
        block20: {
            if (this.closed) {
                throw new IllegalStateException("Instance has already been closed!");
            }
            airs = new ArrayList<Airing>();
            Path path = this.vfs.getPath(String.format("schedules/%s.txt", ZipEpgClient.scrubFileName(station.getId())), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                String input = null;
                JSONObject o = null;
                try (InputStream ins = Files.newInputStream(path, new OpenOption[0]);){
                    input = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
                    try {
                        o = new JSONObject(input);
                    }
                    catch (JSONException e) {
                        throw new JsonEncodingException(String.format("Schedule[%s]: %s", station.getId(), e.getMessage()), e, input);
                    }
                    JSONArray jarr = o.getJSONArray("programs");
                    for (int i = 0; i < jarr.length(); ++i) {
                        JSONObject src = jarr.getJSONObject(i);
                        Program p = this.fetchProgram(src.getString("programID"));
                        if (p == null) continue;
                        airs.add(new Airing(src, p, station));
                    }
                    break block20;
                }
                catch (JSONException e) {
                    throw new InvalidJsonObjectException(String.format("Schedule[%s]: %s", station.getId(), e.getMessage()), e, o.toString(3));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Requested schedule not available in cache: " + station.getId()));
            }
        }
        return airs.toArray(new Airing[0]);
    }

    @Override
    protected Program fetchProgram(String progId) throws IOException {
        Program p;
        block19: {
            Path path;
            if (this.closed) {
                throw new IllegalStateException("Instance has already been closed!");
            }
            p = this.progCache.get(progId);
            if (p == null && Files.exists(path = this.vfs.getPath(String.format("programs/%s.txt", ZipEpgClient.scrubFileName(progId)), new String[0]), new LinkOption[0])) {
                try (InputStream ins = Files.newInputStream(path, new OpenOption[0]);){
                    JSONObject obj;
                    String data = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
                    if (data == null) break block19;
                    try {
                        obj = new JSONObject(data);
                    }
                    catch (JSONException e) {
                        throw new JsonEncodingException(String.format("ZipProgram[%s]: %s", progId, e.getMessage()), e, data);
                    }
                    String cachedMd5 = obj.optString("md5", "");
                    if (cachedMd5 != null && !"".equals(cachedMd5)) {
                        p = new Program(obj, this);
                        this.progCache.put(progId, p);
                    }
                }
                catch (JSONException e) {
                    throw new IOException("JSON error!", e);
                }
            }
        }
        return p;
    }

    @Override
    protected Map<Station, Airing[]> fetchSchedules(Lineup lineup) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        HashMap<Station, Airing[]> scheds = new HashMap<Station, Airing[]>();
        for (Station s : lineup.getStations()) {
            scheds.put(s, this.fetchSchedule(s));
        }
        return scheds;
    }

    @Override
    protected Map<String, Program> fetchPrograms(String[] progIds) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        HashMap<String, Program> progs = new HashMap<String, Program>();
        for (String id : progIds) {
            progs.put(id, this.fetchProgram(id));
        }
        return progs;
    }

    protected JSONObject findMetadataForDevice(JSONArray metas, String dev) throws JSONException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        JSONObject val = null;
        for (int i = 0; i < metas.length(); ++i) {
            JSONObject o = metas.getJSONObject(i);
            if (!dev.equals(o.optString("device"))) continue;
            val = o;
            break;
        }
        return val;
    }

    @Override
    public Lineup[] getLineups() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        if (!this.detailsFetched) {
            for (Lineup l : this.lineups.values()) {
                l.fetchDetails(true);
            }
            this.detailsFetched = true;
        }
        return this.lineups.values().toArray(new Lineup[0]);
    }

    @Override
    public void purgeCache() {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        this.progCache.clear();
    }

    @Override
    public void purgeCache(Object obj) {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        if (obj instanceof Program) {
            this.progCache.remove(((Program)obj).getId());
        }
    }

    @Override
    public void deleteMessage(Message msg) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        throw new UnsupportedOperationException("Messages can only be deleted via the NetworkEpgClient!");
    }

    public Airing[] findScheduleGap() throws IOException {
        for (Lineup l : this.getLineups()) {
            for (Station s : l.getStations()) {
                Airing prev = null;
                for (Airing a : s.getAirings()) {
                    if (prev != null && !new Date(prev.getGmtStart().getTime() + 1000L * (long)prev.getDuration()).equals(a.getGmtStart())) {
                        return new Airing[]{prev, a};
                    }
                    prev = a;
                }
            }
        }
        return null;
    }

    @Override
    public SystemStatus getSystemStatus() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Instance has already been closed!");
        }
        try (InputStream ins = Files.newInputStream(this.vfs.getPath(USER_DATA, new String[0]), new OpenOption[0]);){
            JSONObject user;
            String input = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
            try {
                user = new JSONObject(input);
            }
            catch (JSONException e) {
                throw new JsonEncodingException(String.format("ZipSysStatus: %s", e.getMessage()), e, input);
            }
            SystemStatus systemStatus = new SystemStatus(user.getJSONArray("systemStatus"));
            return systemStatus;
        }
    }

    @Override
    protected InputStream fetchLogoStream(Station station) throws IOException {
        String url = station.getLogo().getUrl().toString();
        String ext = url.substring(url.lastIndexOf(46) + 1);
        Path p = this.vfs.getPath(String.format("logos/%s.%s", station.getCallsign(), ext), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try (InputStream ins = Files.newInputStream(p, new OpenOption[0]);){
                IOUtils.copy((InputStream)ins, (OutputStream)os);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                return byteArrayInputStream;
            }
        }
        return null;
    }

    @Override
    public int registerLineup(String path) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int unregisterLineup(Lineup l) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    protected Lineup[] searchForLineups(String location, String zip) throws IOException {
        return this.getLineups();
    }

    @Override
    public Lineup getLineupByUriPath(String path) throws IOException {
        for (Lineup l : this.getLineups()) {
            if (!l.getUri().equals(UriUtils.stripApiVersion(path))) continue;
            return l;
        }
        return null;
    }

    @Override
    protected String fetchChannelMapping(Lineup lineup) throws IOException {
        Throwable throwable = null;
        try (InputStream ins = Files.newInputStream(this.vfs.getPath("maps", ZipEpgClient.scrubFileName(String.format("%s.txt", lineup.getId()))), new OpenOption[0]);){
            String input = IOUtils.toString((InputStream)ins, (String)ZIP_CHARSET.toString());
            try {
                String string = new JSONObject(input).toString();
                return string;
            }
            catch (JSONException e) {
                try {
                    throw new JsonEncodingException(String.format("ZipLineupMap: %s", e.getMessage()), e, input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

