/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api.utils;

import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;

public final class JsonResponseUtils {
    public static int getErrorCode(JSONObject resp) throws InvalidJsonObjectException {
        try {
            return resp.getInt("code");
        }
        catch (JSONException e) {
            throw new InvalidJsonObjectException("ErrorResponse: Not an error!", e, resp.toString(3));
        }
    }

    public static boolean isErrorResponse(JSONObject resp) {
        try {
            return resp.has("code") && JsonResponseUtils.getErrorCode(resp) != 0;
        }
        catch (InvalidJsonObjectException e) {
            return false;
        }
    }

    private JsonResponseUtils() {
    }
}

