/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Airing;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.Station;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.JsonEncodingException;
import org.schedulesdirect.api.utils.UriUtils;

public class Lineup {
    private String id;
    private String name;
    private Date lastModified;
    private String location;
    private String uri;
    private String type;
    private JSONArray channelMap;
    private Map<String, List<String>> stationMap = null;
    private Map<String, List<String>> physicalStationMap = null;
    private Map<String, Station> stations = null;
    private EpgClient epgClnt;
    private boolean physicalMapping;
    private boolean detailsFetched;
    private boolean airingsFetched;

    Lineup(String name, String location, String uri, String type, EpgClient clnt) {
        this.epgClnt = clnt;
        this.uri = UriUtils.stripApiVersion(uri);
        this.name = name;
        this.location = location;
        this.type = type;
        this.channelMap = null;
        this.id = this.uri.substring(this.uri.lastIndexOf(47) + 1);
        this.detailsFetched = false;
        this.airingsFetched = false;
    }

    public void fetchDetails(boolean fetchAirings) throws IOException {
        if (!this.detailsFetched) {
            this.stationMap = new HashMap<String, List<String>>();
            this.physicalStationMap = new HashMap<String, List<String>>();
            String input = this.epgClnt.fetchChannelMapping(this);
            try {
                JSONObject resp = new JSONObject(input);
                this.channelMap = resp.getJSONArray("map");
                Map<String, JSONObject> tuningData = this.getTuningData(resp.getJSONArray("map"));
                this.fillStations(resp.getJSONArray("stations"), tuningData);
                this.fillMetadata(resp.getJSONObject("metadata"));
                if (this.physicalMapping) {
                    this.buildChannelMapViaAtscData();
                } else {
                    this.buildChannelMapViaJsonData();
                }
            }
            catch (JSONException e) {
                throw new JsonEncodingException(String.format("Lineup[%s]: %s", this.id, e.getMessage()), e, input);
            }
            catch (ParseException e) {
                throw new InvalidJsonObjectException(String.format("Lineup[%s]: %s", this.id, e.getMessage()), e, input);
            }
            this.detailsFetched = true;
        }
        if (fetchAirings && !this.airingsFetched) {
            Map<Station, Airing[]> map = this.epgClnt.fetchSchedules(this);
            for (Station s : map.keySet()) {
                Airing[] a = map.get(s);
                this.stations.get(s.getId()).setAirings(a);
            }
            this.airingsFetched = true;
        }
    }

    private void fillMetadata(JSONObject data) throws JSONException, ParseException {
        this.lastModified = Config.get().getDateTimeFormat().parse(data.getString("modified"));
    }

    private Map<String, JSONObject> getTuningData(JSONArray data) throws JSONException {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject o = data.getJSONObject(i);
            result.put(o.getString("stationID"), o);
            if (!o.has("uhfVhf")) continue;
            this.physicalMapping = true;
        }
        return result;
    }

    private void fillStations(JSONArray stationsArray, Map<String, JSONObject> tuningData) throws InvalidJsonObjectException {
        this.stations = new HashMap<String, Station>();
        for (int i = 0; i < stationsArray.length(); ++i) {
            JSONObject s = stationsArray.getJSONObject(i);
            String id = s.getString("stationID");
            this.stations.put(id, new Station(s, tuningData.get(id), this.epgClnt));
        }
    }

    private void buildChannelMapViaJsonData() throws JSONException {
        for (int i = 0; i < this.channelMap.length(); ++i) {
            JSONObject o = this.channelMap.getJSONObject(i);
            List<String> list = this.stationMap.get(o.getString("stationID"));
            if (list == null) {
                list = new ArrayList<String>();
                this.stationMap.put(o.getString("stationID"), list);
            }
            list.add(o.getString("channel").replaceAll("\\.", "-"));
        }
    }

    private void buildChannelMapViaAtscData() {
        boolean diffLogicalVsPhysical = false;
        for (Station s : this.stations.values()) {
            List<String> list;
            String pNum = s.getPhysicalChannelNumber();
            String lNum = s.getLogicalChannelNumber();
            if (lNum == null) {
                lNum = pNum;
            }
            if (lNum != null) {
                list = this.stationMap.get(s.getId());
                if (list == null) {
                    list = new ArrayList<String>();
                    this.stationMap.put(s.getId(), list);
                }
                list.add(lNum);
            }
            if (pNum != null) {
                list = this.physicalStationMap.get(s.getId());
                if (list == null) {
                    list = new ArrayList<String>();
                    this.physicalStationMap.put(s.getId(), list);
                }
                list.add(pNum);
            }
            if (pNum == null || lNum == null || pNum.equals(lNum)) continue;
            diffLogicalVsPhysical = true;
        }
        this.physicalMapping = diffLogicalVsPhysical;
    }

    public boolean hasPhysicalMapping() {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.physicalMapping;
    }

    public Date getLastModified() {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, List<String>> getStationMap() {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.stationMap;
    }

    public Map<String, List<String>> getPhysicalStationMap() {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.physicalMapping ? this.physicalStationMap : this.stationMap;
    }

    public Station[] getStations() {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.stations.values().toArray(new Station[0]);
    }

    public Station getStation(String stationId) {
        if (this.channelMap == null) {
            throw new IllegalStateException("Must call fetchDetails() before calling this method!");
        }
        return this.stations.get(stationId);
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        int maxLen = 2;
        return "Lineup [id=" + this.id + ", name=" + this.name + ", lastModified=" + this.lastModified + ", location=" + this.location + ", uri=" + this.uri + ", type=" + this.type + ", channelMap=" + this.channelMap + ", stationMap=" + (this.stationMap != null ? this.toString(this.stationMap.entrySet(), 2) : null) + ", physicalStationMap=" + (this.physicalStationMap != null ? this.toString(this.physicalStationMap.entrySet(), 2) : null) + ", stations=" + (this.stations != null ? this.toString(this.stations.entrySet(), 2) : null) + ", physicalMapping=" + this.physicalMapping + ", epgClnt=" + this.epgClnt + "]";
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }
}

