/*
 * Decompiled with CFR 0.152.
 */
package org.schedulesdirect.api;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.schedulesdirect.api.Config;
import org.schedulesdirect.api.ContentRating;
import org.schedulesdirect.api.EpgClient;
import org.schedulesdirect.api.exception.InvalidJsonObjectException;
import org.schedulesdirect.api.exception.SilentInvalidJsonObjectException;

public class Program {
    private static final Log LOG = LogFactory.getLog(Program.class);
    private static final Set<String> WARNED_ROLES = new HashSet<String>();
    public static final String EMPTY_PROGRAM = "{\"md5\":\"\"}";
    public static final String ORIG_FMT = "yyyy-MM-dd";
    public static final Pattern MOVIE_REGEX = Pattern.compile("Feature Film|.*Movie");
    private static final Set<String> WARNED_SRC_TYPES = new HashSet<String>();
    private static final Set<String> WARNED_COLOR_CODES = new HashSet<String>();
    private String id;
    private boolean madeForTv;
    private String description;
    private String episodeTitle;
    private String title;
    private Date originalAirDate;
    private String descriptionLanguage;
    private SourceType sourceType;
    private String syndicatedEpisodeNumber;
    private ColorCode colorCode;
    private String[] advisories;
    private String alternateEpisodeNumber;
    private String alternateTitle;
    private Set<Credit> credits;
    private String alternateDescription;
    private String alternateDescriptionShort;
    private String[] shortDescriptions;
    private Date gameStart;
    private String holiday;
    private String md5;
    private ContentRating[] ratings;
    private String countryOfOrigin;
    private String studio;
    private int runTime;
    private QualityRating[] qualityRatings;
    private String episodeNumber;
    private String[] shortTitles;
    private int year;
    private String[] genres;
    private List<Map<String, Object>> metadata;
    private String seriesDescription;
    private String venue;
    private Team[] teams;
    private URL[] images;
    private Program seriesInfo;

    private static SimpleDateFormat getOrigAirDateFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat(ORIG_FMT);
        fmt.setTimeZone(TimeZone.getDefault());
        return fmt;
    }

    private static String parseDesc(JSONArray src) {
        return src != null ? src.getJSONObject(Program.findEnDescIndex(src)).getString("description") : "";
    }

    private static int findEnDescIndex(JSONArray src) {
        int retVal = 0;
        if (src.length() > 1) {
            for (int i = 0; i < src.length(); ++i) {
                JSONObject o = src.getJSONObject(i);
                if (!o.getString("descriptionLanguage").equals("en")) continue;
                retVal = i;
                break;
            }
        }
        return retVal;
    }

    public static String convertToSeriesId(String id) {
        if (id == null || !id.startsWith("EP")) {
            throw new IllegalArgumentException("Invalid id!");
        }
        return "SH" + id.substring(2, id.length() - 4) + "0000";
    }

    Program(JSONObject src, EpgClient clnt) throws InvalidJsonObjectException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null!");
        }
        try {
            int i;
            JSONArray ratings;
            JSONObject movieInfo;
            this.id = src.getString("programID");
            this.seriesDescription = src.optString("seriesDescription", null);
            this.metadata = new ArrayList<Map<String, Object>>();
            if (src.has("metadata")) {
                JSONArray metaArr = src.getJSONArray("metadata");
                for (int i2 = 0; i2 < metaArr.length(); ++i2) {
                    JSONObject o = metaArr.getJSONObject(i2);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String k : JSONObject.getNames((JSONObject)o)) {
                        map.put(k, !o.isNull(k) ? o.get(k) : null);
                    }
                    this.metadata.add(map);
                }
            }
            this.year = (movieInfo = src.optJSONObject("movie")) != null && movieInfo.has("year") ? Integer.parseInt(movieInfo.get("year").toString()) : 0;
            this.shortTitles = new String[4];
            JSONArray titles = src.getJSONArray("titles");
            for (int i3 = 0; i3 < titles.length(); ++i3) {
                JSONObject o = titles.getJSONObject(i3);
                if (o.has("title120")) {
                    this.title = o.getString("title120");
                    continue;
                }
                this.shortTitles[0] = this.shortTitles[0] == null || this.shortTitles[0].length() == 0 ? o.optString("title70") : this.shortTitles[0];
                this.shortTitles[1] = this.shortTitles[1] == null || this.shortTitles[1].length() == 0 ? o.optString("title40") : this.shortTitles[1];
                this.shortTitles[2] = this.shortTitles[2] == null || this.shortTitles[2].length() == 0 ? o.optString("title20") : this.shortTitles[2];
                this.shortTitles[3] = this.shortTitles[3] == null || this.shortTitles[3].length() == 0 ? o.optString("title10") : this.shortTitles[3];
            }
            if (this.title == null || this.title.length() == 0) {
                throw new IllegalArgumentException("No title120 provided!");
            }
            this.episodeNumber = src.optString("syndicatedEpisodeNumber");
            ArrayList<QualityRating> ratingObjs = new ArrayList<QualityRating>();
            if (movieInfo != null && movieInfo.has("qualityRating")) {
                ratings = movieInfo.getJSONArray("qualityRating");
                for (int i4 = 0; i4 < ratings.length(); ++i4) {
                    JSONObject r = ratings.getJSONObject(i4);
                    if ("TMS".equals(r.optString("ratingsBody"))) {
                        ratingObjs.add(new FloatQualityRating(r, "stars"));
                        continue;
                    }
                    ratingObjs.add(new StringQualityRating(r, "rating"));
                }
            }
            this.qualityRatings = ratingObjs.toArray(new QualityRating[0]);
            this.runTime = movieInfo != null && movieInfo.has("runTime") ? movieInfo.getInt("runTime") : 0;
            this.studio = movieInfo != null && movieInfo.has("origStudio") ? movieInfo.getString("origStudio") : null;
            this.countryOfOrigin = movieInfo != null && movieInfo.has("origCountry") ? movieInfo.getString("origCountry") : null;
            ratings = src.optJSONArray("contentRating");
            if (ratings != null) {
                ArrayList<ContentRating> coll = new ArrayList<ContentRating>();
                for (int i5 = 0; i5 < ratings.length(); ++i5) {
                    JSONObject o = ratings.getJSONObject(i5);
                    coll.add(new ContentRating(o.getString("body"), o.getString("code")));
                }
                this.ratings = coll.toArray(new ContentRating[0]);
            } else {
                this.ratings = new ContentRating[0];
            }
            this.md5 = src.getString("md5");
            this.holiday = src.has("holiday") ? src.getString("holiday") : null;
            this.gameStart = src.has("gameDatetime") ? Config.get().getDateTimeFormat().parse(src.getString("gameDatetime")) : null;
            JSONObject descs = src.optJSONObject("descriptions");
            this.shortDescriptions = new String[4];
            if (descs != null) {
                this.description = Program.parseDesc(descs.optJSONArray("description1000"));
                this.shortDescriptions[0] = Program.parseDesc(descs.optJSONArray("description255"));
                this.shortDescriptions[1] = Program.parseDesc(descs.optJSONArray("description100"));
                this.shortDescriptions[2] = Program.parseDesc(descs.optJSONArray("description60"));
                this.shortDescriptions[3] = Program.parseDesc(descs.optJSONArray("description40"));
                Arrays.sort(this.shortDescriptions, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        if (o1 == null && o2 != null) {
                            return 1;
                        }
                        if (o1 != null && o2 == null) {
                            return -1;
                        }
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        return o2.length() - o1.length();
                    }
                });
                if (this.description.length() == 0 && this.shortDescriptions[0].length() > 0) {
                    this.description = this.shortDescriptions[0];
                }
                this.alternateDescription = Program.parseDesc(descs.optJSONArray("alternateDescription255"));
                this.alternateDescriptionShort = Program.parseDesc(descs.optJSONArray("alternateDescription100"));
            } else {
                String EMPTY = "";
                this.description = "";
                Arrays.fill(this.shortDescriptions, "");
                this.alternateDescription = "";
                this.alternateDescriptionShort = "";
            }
            ArrayList<Credit> castAndCrew = new ArrayList<Credit>();
            if (src.has("cast")) {
                JSONArray cast = src.getJSONArray("cast");
                for (int i6 = 0; i6 < cast.length(); ++i6) {
                    castAndCrew.add(new Credit(cast.getJSONObject(i6)));
                }
            }
            if (src.has("crew")) {
                JSONArray crew = src.getJSONArray("crew");
                for (int i7 = 0; i7 < crew.length(); ++i7) {
                    castAndCrew.add(new Credit(crew.getJSONObject(i7)));
                }
            }
            this.credits = new HashSet<Credit>();
            this.credits.addAll(castAndCrew);
            this.alternateTitle = src.optString("alternateTitle");
            String string = this.alternateEpisodeNumber = src.has("alternateSyndicatedEpisodeNumber") ? src.getString("alternateSyndicatedEpisodeNumber") : null;
            if (src.has("contentAdvisory")) {
                JSONArray arr = src.getJSONArray("contentAdvisory");
                ArrayList<String> vals = new ArrayList<String>();
                for (int i8 = 0; i8 < arr.length(); ++i8) {
                    vals.add(arr.getString(i8));
                }
                this.advisories = vals.toArray(new String[vals.size()]);
            } else {
                this.advisories = new String[0];
            }
            this.madeForTv = src.optBoolean("madeForTv");
            this.episodeTitle = src.optString("episodeTitle150");
            String orig = src.optString("originalAirDate", "");
            this.originalAirDate = orig.length() > 0 && !orig.startsWith("0") ? Program.getOrigAirDateFormat().parse(src.getString("originalAirDate")) : null;
            this.descriptionLanguage = descs != null ? src.optString("descriptionLanguage", null) : null;
            String srcType = src.optString("sourceType").toUpperCase();
            try {
                this.sourceType = srcType.length() == 0 ? SourceType.NONE : SourceType.valueOf(srcType);
            }
            catch (IllegalArgumentException e) {
                if (WARNED_SRC_TYPES.add(srcType)) {
                    LOG.warn((Object)String.format("Unknown SourceType encountered! [%s]", srcType));
                }
                this.sourceType = SourceType.UNKNOWN;
            }
            LinkedHashSet<String> genreVals = new LinkedHashSet<String>();
            String showTypeVal = src.optString("showType");
            if (showTypeVal != null && !"Series".equals(showTypeVal)) {
                if (MOVIE_REGEX.matcher(showTypeVal).matches()) {
                    showTypeVal = "Movie";
                }
                genreVals.add(showTypeVal);
            }
            if (src.has("genres")) {
                JSONArray arr = src.getJSONArray("genres");
                for (int i9 = 0; i9 < arr.length(); ++i9) {
                    genreVals.add(arr.getString(i9));
                }
            }
            this.genres = genreVals.toArray(new String[0]);
            this.syndicatedEpisodeNumber = src.optString("syndicatedEpisodeNumber");
            String colorVal = src.optString("colorCode", ColorCode.NONE.toString()).toUpperCase().replaceAll(" & ", "").replaceAll(" +", "_");
            try {
                this.colorCode = colorVal.length() == 0 ? ColorCode.NONE : ColorCode.valueOf(colorVal);
            }
            catch (IllegalArgumentException e) {
                if (WARNED_COLOR_CODES.add(colorVal)) {
                    LOG.warn((Object)String.format("Unknown ColorCode encountered! [%s]", colorVal));
                }
                this.colorCode = ColorCode.UNKNOWN;
            }
            JSONObject event = src.optJSONObject("eventDetails");
            if (event != null) {
                ArrayList<Team> list = new ArrayList<Team>();
                JSONArray teams = event.optJSONArray("teams");
                if (teams != null) {
                    for (i = 0; i < teams.length(); ++i) {
                        JSONObject team = teams.getJSONObject(i);
                        list.add(new Team(team.getString("name"), team.optBoolean("isHome")));
                    }
                }
                this.teams = list.toArray(new Team[0]);
                this.venue = event.optString("venue", null);
            } else {
                this.teams = new Team[0];
                this.venue = null;
            }
            JSONArray images = src.optJSONArray("images");
            if (images != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (i = 0; i < images.length(); ++i) {
                    JSONObject o = images.getJSONObject(i);
                    String url = o.getString("uri");
                    if (!url.matches("^https?:\\/\\/.*")) {
                        urls.add(new URL(String.format("%s/%s/%s", clnt.getBaseUrl(), 20140530, url)));
                        continue;
                    }
                    urls.add(new URL(url));
                }
                this.images = urls.toArray(new URL[0]);
            }
            this.seriesInfo = this.id.startsWith("EP") ? clnt.fetchProgram(Program.convertToSeriesId(this.id)) : null;
        }
        catch (Throwable t) {
            throw new InvalidJsonObjectException(String.format("Program[%s]: %s", this.id, t.getMessage()), t, src.toString(3));
        }
    }

    public List<Map<String, Object>> getMetadata() {
        return this.metadata;
    }

    public String[] getGenres() {
        return this.genres;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMadeForTv() {
        return this.madeForTv;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEpisodeTitle() {
        return this.episodeTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getOriginalAirDate() {
        return this.originalAirDate;
    }

    public String getDescriptionLanguage() {
        return this.descriptionLanguage;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getSyndicatedEpisodeNumber() {
        return this.syndicatedEpisodeNumber;
    }

    public ColorCode getColorCode() {
        return this.colorCode;
    }

    public String[] getAdvisories() {
        return this.advisories;
    }

    public String getAlternateEpisodeNumber() {
        return this.alternateEpisodeNumber;
    }

    public String getAlternateTitle() {
        return this.alternateTitle;
    }

    public Credit[] getCredits() {
        return this.credits.toArray(new Credit[0]);
    }

    public String getAlternateDescription() {
        return this.alternateDescription;
    }

    public String getAlternateDescriptionShort() {
        return this.alternateDescriptionShort;
    }

    public String[] getShortDescriptions() {
        return this.shortDescriptions;
    }

    public Date getGameStart() {
        return this.gameStart;
    }

    public String getHoliday() {
        return this.holiday;
    }

    public String getMd5() {
        return this.md5;
    }

    public ContentRating[] getRatings() {
        return this.ratings;
    }

    public String getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public String getStudio() {
        return this.studio;
    }

    public int getRunTime() {
        return this.runTime;
    }

    public String getEpisodeNumber() {
        return this.episodeNumber;
    }

    public String[] getShortTitles() {
        return this.shortTitles;
    }

    public int getYear() {
        return this.year;
    }

    public String toString() {
        int maxLen = 2;
        return "Program [id=" + this.id + ", madeForTv=" + this.madeForTv + ", description=" + this.description + ", episodeTitle=" + this.episodeTitle + ", title=" + this.title + ", originalAirDate=" + this.originalAirDate + ", descriptionLanguage=" + this.descriptionLanguage + ", sourceType=" + (Object)((Object)this.sourceType) + ", syndicatedEpisodeNumber=" + this.syndicatedEpisodeNumber + ", colorCode=" + (Object)((Object)this.colorCode) + ", advisories=" + (this.advisories != null ? Arrays.asList(this.advisories).subList(0, Math.min(this.advisories.length, 2)) : null) + ", alternateEpisodeNumber=" + this.alternateEpisodeNumber + ", alternateTitle=" + this.alternateTitle + ", credits=" + (this.credits != null ? Arrays.asList(this.credits).subList(0, Math.min(this.credits.size(), 2)) : null) + ", alternateDescription=" + this.alternateDescription + ", alternateDescriptionShort=" + this.alternateDescriptionShort + ", shortDescriptions=" + (this.shortDescriptions != null ? Arrays.asList(this.shortDescriptions).subList(0, Math.min(this.shortDescriptions.length, 2)) : null) + ", gameStart=" + this.gameStart + ", holiday=" + this.holiday + ", md5=" + this.md5 + ", ratings=" + (this.ratings != null ? Arrays.asList(this.ratings).subList(0, Math.min(this.ratings.length, 2)) : null) + ", countryOfOrigin=" + this.countryOfOrigin + ", studio=" + this.studio + ", runTime=" + this.runTime + ", qualityRatings=" + (this.qualityRatings != null ? Arrays.asList(this.qualityRatings).subList(0, Math.min(this.qualityRatings.length, 2)) : null) + ", episodeNumber=" + this.episodeNumber + ", shortTitles=" + (this.shortTitles != null ? Arrays.asList(this.shortTitles).subList(0, Math.min(this.shortTitles.length, 2)) : null) + ", year=" + this.year + ", genres=" + (this.genres != null ? Arrays.asList(this.genres).subList(0, Math.min(this.genres.length, 2)) : null) + ", metadata=" + (this.metadata != null ? this.metadata.subList(0, Math.min(this.metadata.size(), 2)) : null) + ", seriesDescription=" + this.seriesDescription + ", venue=" + this.venue + ", teams=" + (this.teams != null ? Arrays.asList(this.teams).subList(0, Math.min(this.teams.length, 2)) : null) + ", images=" + (this.images != null ? Arrays.asList(this.images).subList(0, Math.min(this.images.length, 2)) : null) + ", seriesInfo=" + this.seriesInfo + "]";
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMadeForTv(boolean madeForTv) {
        this.madeForTv = madeForTv;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEpisodeTitle(String episodeTitle) {
        this.episodeTitle = episodeTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOriginalAirDate(Date originalAirDate) {
        this.originalAirDate = originalAirDate;
    }

    public void setDescriptionLanguage(String descriptionLanguage) {
        this.descriptionLanguage = descriptionLanguage;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setSyndicatedEpisodeNumber(String syndicatedEpisodeNumber) {
        this.syndicatedEpisodeNumber = syndicatedEpisodeNumber;
    }

    public void setColorCode(ColorCode colorCode) {
        this.colorCode = colorCode;
    }

    public void setAdvisories(String[] advisories) {
        this.advisories = advisories;
    }

    public void setAlternateEpisodeNumber(String alternateEpisodeNumber) {
        this.alternateEpisodeNumber = alternateEpisodeNumber;
    }

    public void setAlternateTitle(String alternateTitle) {
        this.alternateTitle = alternateTitle;
    }

    public void setCredits(Credit[] credits) {
        this.credits.clear();
        for (Credit c : credits) {
            this.credits.add(c);
        }
    }

    public void setAlternateDescription(String alternateDescription) {
        this.alternateDescription = alternateDescription;
    }

    public void setAlternateDescriptionShort(String alternateDescriptionShort) {
        this.alternateDescriptionShort = alternateDescriptionShort;
    }

    public void setShortDescriptions(String[] shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
    }

    public void setGameStart(Date gameStart) {
        this.gameStart = gameStart;
    }

    public void setHoliday(String holiday) {
        this.holiday = holiday;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setRatings(ContentRating[] ratings) {
        this.ratings = ratings;
    }

    public void setCountryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
    }

    public void setStudio(String studio) {
        this.studio = studio;
    }

    public void setRunTime(int runTime) {
        this.runTime = runTime;
    }

    public void setEpisodeNumber(String episodeNumber) {
        this.episodeNumber = episodeNumber;
    }

    public void setShortTitles(String[] shortTitles) {
        this.shortTitles = shortTitles;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setGenres(String[] genres) {
        this.genres = genres;
    }

    public void setMetadata(List<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Program)) {
            return false;
        }
        Program other = (Program)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setSeriesDescription(String seriesDescription) {
        this.seriesDescription = seriesDescription;
    }

    public String getVenue() {
        return this.venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public Team[] getTeams() {
        return this.teams;
    }

    public void setTeams(Team[] teams) {
        this.teams = teams;
    }

    public URL[] getImages() {
        return this.images;
    }

    public void setImages(URL[] images) {
        this.images = images;
    }

    public QualityRating[] getQualityRatings() {
        return this.qualityRatings;
    }

    public void setQualityRatings(QualityRating[] qualityRatings) {
        this.qualityRatings = qualityRatings;
    }

    public Program getSeriesInfo() {
        return this.seriesInfo;
    }

    public void setSeriesInfo(Program seriesInfo) {
        this.seriesInfo = seriesInfo;
    }

    public static class FloatQualityRating
    extends QualityRating {
        private float rating;
        private float minRating;
        private float maxRating;
        private float increment;

        protected FloatQualityRating(JSONObject src, String units) {
            super(src.optString("ratingsBody", null), units);
            this.rating = Float.parseFloat(src.getString("rating"));
            this.minRating = Float.parseFloat(src.optString("minRating", Float.toString(Float.MIN_VALUE)));
            this.maxRating = Float.parseFloat(src.optString("maxRating", Float.toString(Float.MIN_VALUE)));
            this.increment = Float.parseFloat(src.optString("increment", Float.toString(Float.MIN_VALUE)));
        }

        @Override
        public Float getRating() {
            return Float.valueOf(this.rating);
        }

        @Override
        public Float getMinRating() {
            return Float.valueOf(this.minRating);
        }

        @Override
        public Float getMaxRating() {
            return Float.valueOf(this.maxRating);
        }

        @Override
        public Float getIncrement() {
            return Float.valueOf(this.increment);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(String.format("%.1f", Float.valueOf(this.rating)));
            if (this.maxRating > Float.MIN_VALUE) {
                sb.append(String.format("/%.1f", Float.valueOf(this.maxRating)));
            }
            sb.append(String.format(" %s", this.getUnits()));
            return sb.toString();
        }
    }

    public static class StringQualityRating
    extends QualityRating {
        private String rating;
        private String minRating;
        private String maxRating;
        private String increment;

        protected StringQualityRating(JSONObject src, String units) throws InvalidJsonObjectException {
            super(src.optString("ratingsBody", null), units);
            try {
                this.rating = src.getString("rating");
                this.minRating = src.optString("minRating", null);
                this.maxRating = src.optString("maxRating", null);
                this.increment = src.optString("increment", null);
            }
            catch (JSONException e) {
                throw new SilentInvalidJsonObjectException(e);
            }
        }

        @Override
        public String getRating() {
            return this.rating;
        }

        @Override
        public String getMinRating() {
            return this.minRating;
        }

        @Override
        public String getMaxRating() {
            return this.maxRating;
        }

        @Override
        public String getIncrement() {
            return this.increment;
        }

        public String toString() {
            return String.format("%s %s", this.rating, this.getUnits());
        }
    }

    public static abstract class QualityRating {
        private String source;
        private String units;

        private QualityRating(String source, String units) {
            this.source = source;
            this.units = units;
        }

        public String getSource() {
            return this.source;
        }

        public String getUnits() {
            return this.units;
        }

        public abstract Object getRating();

        public abstract Object getMinRating();

        public abstract Object getMaxRating();

        public abstract Object getIncrement();
    }

    public static class Team {
        private String name;
        private boolean isHome;

        protected Team(String name, boolean isHome) {
            this.name = name;
            this.isHome = isHome;
        }

        public String getName() {
            return this.name;
        }

        public boolean isHome() {
            return this.isHome;
        }

        public String toString() {
            return "Team [name=" + this.name + ", isHome=" + this.isHome + "]";
        }
    }

    public static class Credit {
        private Role role;
        private String name;
        private int billingOrder;
        private String personId;
        private String nameId;
        private String characterName;

        private Credit(JSONObject src) throws JSONException {
            Role r = null;
            String roleStr = src.getString("role");
            if (roleStr.startsWith("Writer") || roleStr.contains("Screenwriter")) {
                roleStr = "Writer";
            } else if (roleStr.contains("Assistant Director")) {
                roleStr = "Assistant Director";
            } else if (roleStr.contains("Producer")) {
                roleStr = "Producer";
            } else if (roleStr.contains("Art Director")) {
                roleStr = "Art Direction";
            } else if (roleStr.contains("Production Design")) {
                roleStr = "Production Designer";
            } else if (roleStr.contains("Visual Effects")) {
                roleStr = "Visual Effects";
            }
            String name = src.getString("name");
            try {
                r = Role.valueOf(roleStr.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException e) {
                if (WARNED_ROLES.add(roleStr)) {
                    LOG.warn((Object)String.format("Unknown Role encountered! [%s]", roleStr));
                }
                r = Role.UNKNOWN;
            }
            this.role = r;
            this.name = name;
            this.billingOrder = Integer.parseInt(src.optString("billingOrder", "0"));
            this.personId = src.optString("personId", null);
            this.nameId = src.optString("nameId", null);
            this.characterName = src.optString("characterName", null);
        }

        public Role getRole() {
            return this.role;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Credit [personId=" + this.personId + ", nameId=" + this.nameId + ", billingOrder=" + this.billingOrder + ", name=" + this.name + ", role=" + (Object)((Object)this.role) + ", characterName=" + this.characterName + "]";
        }

        public int getBillingOrder() {
            return this.billingOrder;
        }

        public String getPersonId() {
            return this.personId;
        }

        public String getNameId() {
            return this.nameId;
        }

        public String getCharacterName() {
            return this.characterName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.nameId == null ? 0 : this.nameId.hashCode());
            result = 31 * result + (this.personId == null ? 0 : this.personId.hashCode());
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Credit other = (Credit)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.nameId == null ? other.nameId != null : !this.nameId.equals(other.nameId)) {
                return false;
            }
            if (this.personId == null ? other.personId != null : !this.personId.equals(other.personId)) {
                return false;
            }
            return this.role == other.role;
        }
    }

    public static enum Role {
        UNKNOWN,
        ACTOR,
        ANCHOR,
        CONTESTANT,
        CORRESPONDENT,
        DIRECTOR,
        ASSISTANT_DIRECTOR,
        EXECUTIVE_PRODUCER,
        GUEST_STAR,
        GUEST,
        HOST,
        JUDGE,
        MUSICAL_GUEST,
        NARRATOR,
        PRODUCER,
        WRITER,
        COSTUME_DESIGNER,
        SET_DECORATION,
        ART_DIRECTION,
        PRODUCTION_DESIGNER,
        CASTING,
        FILM_EDITOR,
        CINEMATOGRAPHER,
        ORIGINAL_MUSIC,
        ASSOCIATE_PRODUCER,
        CASTING_DIRECTOR,
        COMPOSER,
        VOICE,
        PRODUCTION_MANAGER,
        DIRECTORY_OF_PHOTOGRAPHY,
        VISUAL_EFFECTS;

    }

    public static enum SourceType {
        NONE,
        LOCAL,
        SYNDICATED,
        NETWORK,
        BLOCK,
        UNKNOWN;

    }

    public static enum ColorCode {
        NONE,
        COLOR,
        BW,
        COLOR_AND_BW,
        COLORIZED,
        UNKNOWN;

    }
}

