/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import org.schicwp.dinky.api.dto.AuthRequest;
import org.schicwp.dinky.api.dto.AuthResponse;
import org.schicwp.dinky.auth.AuthService;
import org.schicwp.dinky.auth.User;
import org.schicwp.dinky.security.JWTEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Order(value=2)
@RequestMapping(value={"/api/v1/auth"})
public class AuthResource {
    @Autowired
    AuthService authService;

    @GetMapping(value={"current"})
    User getCurrentUser() {
        return this.authService.getCurrentUser();
    }

    @PostMapping(value={"token"})
    AuthResponse getToken(@RequestBody AuthRequest authRequest) {
        return new AuthResponse(JWTEncoder.getToken(authRequest.getUsername(), authRequest.getPassword()));
    }
}

