/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.validation.Valid;
import org.schicwp.dinky.api.dto.ContentSubmission;
import org.schicwp.dinky.content.ContentService;
import org.schicwp.dinky.content.ContentSubmissionService;
import org.schicwp.dinky.exceptions.FieldValidationException;
import org.schicwp.dinky.exceptions.OptimisticLockingException;
import org.schicwp.dinky.exceptions.PermissionException;
import org.schicwp.dinky.exceptions.SubmissionValidationException;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.type.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/api/v1"})
public class ContentResource {
    private static final Logger logger = Logger.getLogger(ContentResource.class.getCanonicalName());
    @Autowired
    ContentService contentRepository;
    @Autowired
    ContentSubmissionService contentSubmissionService;

    @PostMapping(value={"content"})
    public Content postContent(@Valid @RequestBody ContentSubmission contentSubmission) {
        return this.contentSubmissionService.processSubmission(contentSubmission);
    }

    @PostMapping(value={"content"}, consumes={"multipart/form-data"})
    public Content postContentMultipart(MultipartHttpServletRequest request, @RequestParam(value="content") String content) throws IOException {
        ContentSubmission contentSubmission = (ContentSubmission)new ObjectMapper().readValue(content, ContentSubmission.class);
        request.getFileNames().forEachRemaining(f -> {
            for (String k : contentSubmission.getContent().keySet()) {
                if (!f.equals(contentSubmission.getContent().get(k))) continue;
                contentSubmission.getContent().put(k, request.getFile(f));
            }
        });
        return this.contentSubmissionService.processSubmission(contentSubmission);
    }

    @GetMapping(value={"content/{id}"})
    public Content getContent(@PathVariable(value="id") String id) {
        return this.contentRepository.findById(id).orElseThrow(IllegalArgumentException::new);
    }

    @GetMapping(value={"content/{id}/history"})
    public Page<Content> getContentHistory(@PathVariable(value="id") String id, @PageableDefault(sort={"modified"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return this.contentRepository.getHistory(id, pageable);
    }

    @GetMapping(value={"content/{id}/history/{version}"})
    public Content getContentHistoryVersion(@PathVariable(value="id") String id, @PathVariable(value="version") int version) {
        return this.contentRepository.getHistoricalVersion(id, version);
    }

    @PostMapping(value={"content/{id}/history/{version}"})
    public Content revertToVersion(@PathVariable(value="id") String id, @PathVariable(value="version") int version) {
        return this.contentRepository.revertToHistoricalVersion(id, version);
    }

    @GetMapping(value={"content"})
    public Page<Content> listContent(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params, @PageableDefault(sort={"modified"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return this.contentRepository.find(this.generateQueryFromParams(q, params), pageable);
    }

    @GetMapping(value={"assigned"})
    public Page<Content> assignedContent(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params, @PageableDefault(sort={"modified"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return this.contentRepository.findAssigned(this.generateQueryFromParams(q, params), pageable);
    }

    @GetMapping(value={"mine"})
    public Page<Content> myCountent(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params, @PageableDefault(sort={"modified"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return this.contentRepository.findMine(this.generateQueryFromParams(q, params), pageable);
    }

    @GetMapping(value={"content-count"})
    public long contentCount(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params) {
        return this.contentRepository.count(this.generateQueryFromParams(q, params));
    }

    @GetMapping(value={"assigned-count"})
    public long assignedCount(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params) {
        return this.contentRepository.countAssigned(this.generateQueryFromParams(q, params));
    }

    @GetMapping(value={"mine-count"})
    public long mineCount(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params) {
        return this.contentRepository.countOwned(this.generateQueryFromParams(q, params));
    }

    @ExceptionHandler(value={FieldValidationException.class})
    public ResponseEntity<ValidationResult> validationException(FieldValidationException e) {
        return new ResponseEntity((Object)e.getValidationResult(), (MultiValueMap)new HttpHeaders(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OptimisticLockingException.class})
    public ResponseEntity<?> validationException(OptimisticLockingException e) {
        return new ResponseEntity((MultiValueMap)new HttpHeaders(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={PermissionException.class})
    public ResponseEntity<?> validationException(PermissionException e) {
        return new ResponseEntity((MultiValueMap)new HttpHeaders(), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={SubmissionValidationException.class})
    public ResponseEntity<?> validationException(SubmissionValidationException e) {
        return new ResponseEntity((MultiValueMap)new HttpHeaders(), HttpStatus.BAD_REQUEST);
    }

    private Query generateQueryFromParams(@RequestParam(value="q", required=false) String q, @RequestParam Map<String, String> params) {
        params.remove("q");
        params.remove("size");
        params.remove("page");
        params.remove("sort");
        if (q == null && params.size() == 0) {
            return null;
        }
        Criteria criteria = new Criteria();
        for (String k : params.keySet()) {
            criteria = criteria.and(k).is((Object)params.get(k));
        }
        Query query = q != null ? new BasicQuery(q).addCriteria((CriteriaDefinition)criteria) : Query.query((CriteriaDefinition)criteria);
        return query;
    }
}

