/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import java.util.List;
import java.util.NoSuchElementException;
import org.schicwp.dinky.config.ContentTypeConfig;
import org.schicwp.dinky.config.loader.TypeLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/content-type"})
public class ContentTypeResource {
    @Autowired
    TypeLoader typeLoader;

    @GetMapping
    public Page<ContentTypeConfig> listContentTypes() {
        List<ContentTypeConfig> allContentTypes = this.typeLoader.getContentTypeConfigs();
        return PageableExecutionUtils.getPage(allContentTypes, (Pageable)PageRequest.of((int)0, (int)allContentTypes.size()), allContentTypes::size);
    }

    @GetMapping(value={"{name}"})
    public ContentTypeConfig getContentType(@PathVariable(value="name") String name) {
        List<ContentTypeConfig> workflowConfigs = this.typeLoader.getContentTypeConfigs();
        return workflowConfigs.stream().filter(w -> w.getName().equals(name)).findFirst().orElseThrow(NoSuchElementException::new);
    }
}

