/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.schicwp.dinky.auth.User;
import org.schicwp.dinky.model.Content;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties(value="auth")
public class AuthService {
    private Map<String, String> groupMap = new HashMap<String, String>();
    private List<String> allUsers = new ArrayList<String>();
    private final ThreadLocal<User> forcedUser = new ThreadLocal();
    private static final User SYSTEM_USER = new User("system", Collections.emptyList(), true);
    @Autowired
    MongoOperations mongoOperations;

    public void setGroupMap(Map<String, String> groupMap) {
        this.groupMap = groupMap;
    }

    public void setAllUsers(List<String> allUsers) {
        this.allUsers = allUsers;
    }

    @PostConstruct
    void init() {
        this.groupMap.values().forEach(s -> {
            this.mongoOperations.indexOps(Content.class).ensureIndex((IndexDefinition)new Index().on("permissions.group." + s + ".read", Sort.Direction.ASC));
            this.mongoOperations.indexOps(Content.class).ensureIndex((IndexDefinition)new Index().on("permissions.group." + s + ".write", Sort.Direction.ASC));
        });
    }

    public User getCurrentUser() {
        if (this.forcedUser.get() != null) {
            return this.forcedUser.get();
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            List<String> grantedGroups = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(this.groupMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            grantedGroups.addAll(this.allUsers);
            return new User(authentication.getName(), grantedGroups, false);
        }
        return null;
    }

    public <T> T withSystemUser(Supplier<T> supplier) {
        try {
            this.forcedUser.set(SYSTEM_USER);
            T t = supplier.get();
            return t;
        }
        finally {
            this.forcedUser.remove();
        }
    }

    public void withSystemUser(Runnable supplier) {
        try {
            this.forcedUser.set(SYSTEM_USER);
            supplier.run();
        }
        finally {
            this.forcedUser.remove();
        }
    }
}

