/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.config.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.schicwp.dinky.config.ContentTypeConfig;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.type.ContentType;
import org.schicwp.dinky.model.type.ContentTypeService;
import org.schicwp.dinky.model.type.Field;
import org.schicwp.dinky.model.type.FieldTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Component
public class TypeLoader {
    private static final Logger logger = Logger.getLogger(TypeLoader.class.getCanonicalName());
    private List<ContentTypeConfig> contentTypeConfigs = new ArrayList<ContentTypeConfig>();
    @Autowired
    ContentTypeService contentTypeService;
    @Autowired
    MongoOperations mongoOperations;
    @Autowired
    FieldTypeService fieldTypeService;
    @Value(value="${dinky.types}")
    private String configDir;

    @PostConstruct
    @Scheduled(fixedRate=15000L)
    void init() {
        HashMap<String, ContentType> contentTypes = new HashMap<String, ContentType>();
        ArrayList<ContentTypeConfig> contentTypeConfigs = new ArrayList<ContentTypeConfig>();
        Arrays.asList(new File(this.configDir).listFiles()).forEach(file -> {
            try {
                logger.fine("Loading: " + file);
                ContentTypeConfig contentTypeConfig = (ContentTypeConfig)new Yaml((BaseConstructor)new Constructor(ContentTypeConfig.class)).load((InputStream)new FileInputStream((File)file));
                ContentType contentType = this.convertContentTypeConfigToContentType(contentTypeConfig);
                contentTypes.put(contentType.getName(), contentType);
                contentTypeConfigs.add(contentTypeConfig);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading: " + file, e);
            }
        });
        logger.fine("Types: " + contentTypes);
        this.contentTypeService.setContentTypes(contentTypes);
        this.setContentTypeConfigs(contentTypeConfigs);
    }

    private ContentType convertContentTypeConfigToContentType(ContentTypeConfig contentTypeConfig) {
        ContentType contentType = new ContentType(contentTypeConfig.getName(), contentTypeConfig.getFields().stream().map(fieldConfig -> new Field(this.fieldTypeService.getFieldType(fieldConfig.getType()), fieldConfig.isRequired(), fieldConfig.getConfig(), fieldConfig.getName(), fieldConfig.isIndexed())).collect(Collectors.toList()), contentTypeConfig.getWorkflows(), contentTypeConfig.getNameField());
        contentType.getFields().forEach(field -> {
            if (field.isIndexed()) {
                logger.fine("Creating index 'content." + field.getName() + "'");
                this.mongoOperations.indexOps(Content.class).ensureIndex((IndexDefinition)new Index().on("content." + field.getName(), Sort.Direction.ASC));
            }
        });
        return contentType;
    }

    public synchronized List<ContentTypeConfig> getContentTypeConfigs() {
        return this.contentTypeConfigs;
    }

    public synchronized void setContentTypeConfigs(List<ContentTypeConfig> contentTypeConfigs) {
        this.contentTypeConfigs = contentTypeConfigs;
    }
}

