/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.config.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.schicwp.dinky.config.StateConfig;
import org.schicwp.dinky.config.WorkflowConfig;
import org.schicwp.dinky.workflow.Action;
import org.schicwp.dinky.workflow.ActionHookFactoryService;
import org.schicwp.dinky.workflow.NamedActionHook;
import org.schicwp.dinky.workflow.State;
import org.schicwp.dinky.workflow.Workflow;
import org.schicwp.dinky.workflow.WorkflowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Service
public class WorkflowLoader {
    private static final Logger logger = Logger.getLogger(WorkflowLoader.class.getCanonicalName());
    @Value(value="${dinky.workflows}")
    private String configDir;
    @Autowired
    ActionHookFactoryService actionHookFactoryService;
    @Autowired
    WorkflowService workflowService;
    private List<WorkflowConfig> workflowConfigs = new ArrayList<WorkflowConfig>();

    @PostConstruct
    public synchronized void init() {
        logger.info("Loading workflows");
        HashMap<String, Workflow> workflows = new HashMap<String, Workflow>();
        ArrayList<WorkflowConfig> workflowConfigs = new ArrayList<WorkflowConfig>();
        Arrays.asList(new File(this.configDir).listFiles()).forEach(file -> {
            try {
                logger.info("Loading: " + file);
                WorkflowConfig workflowConfig = (WorkflowConfig)new Yaml((BaseConstructor)new Constructor(WorkflowConfig.class)).load((InputStream)new FileInputStream((File)file));
                Workflow workflow = this.convertWorkflowConfigToWorkflow(workflowConfig);
                workflows.put(workflow.getName(), workflow);
                workflowConfigs.add(workflowConfig);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        logger.info("Workflows: " + workflows);
        this.workflowService.setWorkflows(workflows);
        this.setWorkflowConfigs(workflowConfigs);
    }

    public Workflow convertWorkflowConfigToWorkflow(WorkflowConfig workflowConfig) {
        return new Workflow(workflowConfig.getName(), workflowConfig.getStates().stream().map(StateConfig::getName).map(State::new).collect(Collectors.toList()), workflowConfig.getActions().stream().map(a -> new Action(a.getName(), a.isEntryPoint(), a.getNextState(), a.getSourceStates(), a.getAllowedGroups(), a.getHooks().stream().map(ahc -> new NamedActionHook(ahc.getName(), this.actionHookFactoryService.getActionHook(ahc.getName()).createActionHook(ahc.getConfig()))).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public synchronized void setWorkflowConfigs(List<WorkflowConfig> workflowConfigs) {
        this.workflowConfigs = workflowConfigs;
    }

    public synchronized List<WorkflowConfig> getWorkflowConfigs() {
        return this.workflowConfigs;
    }
}

