/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.content;

import java.util.concurrent.ConcurrentHashMap;
import org.schicwp.dinky.model.Content;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class QueryTotalCache {
    @Autowired
    MongoTemplate mongoTemplate;
    ConcurrentHashMap<String, Long> cachedTotals = new ConcurrentHashMap();

    public void invalidate() {
        this.cachedTotals.clear();
    }

    public long getCountForQuery(Query finalQuery) {
        String queryString = finalQuery.toString();
        if (!this.cachedTotals.containsKey(queryString)) {
            this.cachedTotals.put(queryString, this.mongoTemplate.count(finalQuery, Content.class));
        }
        return this.cachedTotals.get(queryString);
    }
}

