/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.schicwp.dinky.model.ContentMap;
import org.schicwp.dinky.model.ContentPermissions;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Content {
    @Indexed
    @Id
    private String id;
    @Indexed
    private int version = 0;
    @Indexed
    private Date created = new Date();
    @Indexed
    private Date modified = new Date();
    @Indexed
    private String workflow;
    @Indexed
    private String state;
    @Indexed
    private String type;
    @Indexed
    private String owner;
    @Indexed
    private String createdBy;
    @Indexed
    private String modifiedBy;
    @Indexed
    private String assignedUser;
    @Indexed
    private String assignedGroup;
    @Indexed
    private String name;
    @Indexed
    private Map<String, Integer> searchVersions = new HashMap<String, Integer>();
    private ContentPermissions permissions = new ContentPermissions();
    private ContentMap content = new ContentMap();

    public Content() {
    }

    public Content(String id, String owner, String type) {
        this.id = id;
        this.owner = owner;
        this.createdBy = owner;
        this.modifiedBy = owner;
        this.type = type;
    }

    public Content(Content content) {
        this.id = content.id;
        this.version = content.version;
        this.created = content.created;
        this.modified = content.modified;
        this.workflow = content.workflow;
        this.state = content.state;
        this.type = content.type;
        this.owner = content.owner;
        this.createdBy = content.createdBy;
        this.modifiedBy = content.modifiedBy;
        this.assignedUser = content.assignedUser;
        this.assignedGroup = content.assignedGroup;
        this.name = content.name;
        this.searchVersions = content.searchVersions;
        this.permissions = content.permissions;
        this.content = content.content;
    }

    public Content merge(Map<String, Object> properties) {
        if (properties != null) {
            this.content.putAll(properties);
        }
        ++this.version;
        this.modified = new Date();
        return this;
    }

    public ContentMap getContent() {
        return this.content;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setContent(ContentMap content) {
        this.content = content;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        if (this.name == null) {
            return this.id;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Map<String, Integer> getSearchVersions() {
        return this.searchVersions;
    }

    public void setSearchVersions(Map<String, Integer> searchVersions) {
        this.searchVersions = searchVersions;
    }

    public ContentPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ContentPermissions permissions) {
        this.permissions = permissions;
    }

    public String getAssignedGroup() {
        return this.assignedGroup;
    }

    public String getAssignedUser() {
        return this.assignedUser;
    }

    public void setAssignedUser(String assignedUser) {
        this.assignedUser = assignedUser;
    }

    public void setAssignedGroup(String assignedGroup) {
        this.assignedGroup = assignedGroup;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String toString() {
        return "Content{id='" + this.id + '\'' + ", version=" + this.version + ", workflow='" + this.workflow + '\'' + ", state='" + this.state + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

