/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.model.type;

import java.util.ArrayList;
import java.util.Collection;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.type.Field;
import org.schicwp.dinky.model.type.ValidationResult;

public class ContentType {
    private final String name;
    private final Collection<Field> fields;
    private final Collection<String> workflows;
    private final String nameField;

    public ContentType(String name, Collection<Field> fields, Collection<String> workflows, String nameField) {
        this.name = name;
        this.fields = fields;
        this.workflows = workflows;
        this.nameField = nameField;
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        for (Field field : this.fields) {
            ArrayList<String> fieldErrors = new ArrayList<String>();
            if (field.isRequired() && !content.getContent().containsKey(field.getName())) {
                fieldErrors.add("Required");
                result.setErrors(field.getName(), fieldErrors);
            }
            if (!content.getContent().containsKey(field.getName()) || field.validateSubmission(content.getContent().get(field.getName()), fieldErrors)) continue;
            result.setErrors(field.getName(), fieldErrors);
        }
        return result;
    }

    public Content sanitize(Content content) {
        ArrayList fieldNames = new ArrayList(content.getContent().keySet());
        fieldNames.forEach(name -> {
            if (this.fields.stream().noneMatch(f -> f.getName().equals(name))) {
                content.getContent().remove(name);
            }
        });
        return content;
    }

    public Content convert(Content content) {
        for (Field field : this.fields) {
            if (!content.getContent().containsKey(field.getName())) continue;
            content.getContent().put(field.getName(), field.convertSubmission(content.getContent().get(field.getName()), content));
        }
        return content;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Field> getFields() {
        return this.fields;
    }

    public String getNameField() {
        return this.nameField;
    }

    public Collection<String> getWorkflows() {
        return this.workflows;
    }
}

