/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.search;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.schicwp.dinky.search.SearchContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    public static final String ES_TYPENAME = "contentType";
    @Autowired
    ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    ElasticsearchConverter elasticsearchConverter;

    public String addToIndex(String index, SearchContent content) {
        IndexQuery indexQuery = new IndexQuery();
        indexQuery.setId(content.getId());
        indexQuery.setIndexName(index);
        indexQuery.setType(ES_TYPENAME);
        indexQuery.setObject((Object)content);
        return this.elasticsearchTemplate.index(indexQuery);
    }

    public String deleteFromIndex(String index, String id) {
        return this.elasticsearchTemplate.delete(index, ES_TYPENAME, id);
    }

    public Page<SearchContent> search(String index, QueryBuilder queryBuilder, Pageable pageable) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(queryBuilder).withPageable(pageable).withIndices(new String[]{index}).withTypes(new String[]{ES_TYPENAME}).build();
        return (Page)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
            SearchHit[] hits;
            DefaultResultMapper resultsMapper = new DefaultResultMapper(this.elasticsearchConverter.getMappingContext());
            AggregatedPage searchContents = resultsMapper.mapResults(response, SearchContent.class, pageable);
            for (SearchHit hit : hits = response.getHits().getHits()) {
                for (SearchContent content : searchContents.getContent()) {
                    if (!hit.getId().equals(content.getId())) continue;
                    content.setScore(Float.valueOf(hit.getScore()));
                }
            }
            return searchContents;
        });
    }

    public Collection<String> getIndexes() {
        ArrayList<String> result = new ArrayList<String>();
        GetSettingsResponse response = (GetSettingsResponse)this.elasticsearchTemplate.getClient().admin().indices().prepareGetSettings(new String[0]).get();
        for (ObjectObjectCursor cursor : response.getIndexToSettings()) {
            String index = (String)cursor.key;
            result.add(index);
        }
        return result;
    }
}

