/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.workflow;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.schicwp.dinky.workflow.ActionHookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ActionHookFactoryService {
    private static final Logger logger = Logger.getLogger(ActionHookFactoryService.class.getCanonicalName());
    @Autowired
    private ApplicationContext applicationContext;
    Map<String, ActionHookFactory> actionHookFactories = new HashMap<String, ActionHookFactory>();

    @PostConstruct
    public void init() {
        this.applicationContext.getBeansOfType(ActionHookFactory.class).forEach((k, f) -> {
            logger.info("Registering ActionHook: " + f.getName());
            this.actionHookFactories.put(f.getName(), (ActionHookFactory)f);
        });
    }

    public ActionHookFactory getActionHook(String name) {
        return this.actionHookFactories.get(name);
    }
}

