/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.workflow.hooks;

import java.util.logging.Logger;
import org.schicwp.dinky.model.ContentMap;
import org.schicwp.dinky.search.SearchContent;
import org.schicwp.dinky.search.SearchService;
import org.schicwp.dinky.workflow.ActionHook;
import org.schicwp.dinky.workflow.ActionHookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddToSearch
implements ActionHookFactory {
    private static final Logger logger = Logger.getLogger(AddToSearch.class.getCanonicalName());
    @Autowired
    SearchService searchService;

    @Override
    public String getName() {
        return "AddToSearch";
    }

    @Override
    public ActionHook createActionHook(ContentMap config) {
        String index = config.getOrDefault("index", "default");
        return (content, actionConfig) -> {
            logger.info(String.format("Adding [%s] to search index [%s]", content, index));
            content.getSearchVersions().put(index, content.getVersion());
            this.searchService.addToIndex(index, new SearchContent(content));
        };
    }
}

