/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.workflow.hooks;

import java.util.logging.Logger;
import org.schicwp.dinky.model.ContentMap;
import org.schicwp.dinky.search.SearchService;
import org.schicwp.dinky.workflow.ActionHook;
import org.schicwp.dinky.workflow.ActionHookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoveFromSearch
implements ActionHookFactory {
    private static final Logger logger = Logger.getLogger(RemoveFromSearch.class.getCanonicalName());
    @Autowired
    SearchService searchService;

    @Override
    public String getName() {
        return "RemoveFromSearch";
    }

    @Override
    public ActionHook createActionHook(ContentMap config) {
        String index = config.getOrDefault("index", "default");
        return (content, actionConfig) -> {
            this.searchService.deleteFromIndex(index, content.getId());
            logger.info(String.format("Removing [%s] from search index [%s]", content, index));
            content.getSearchVersions().remove(index);
        };
    }
}

