/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.workflow.hooks;

import java.util.HashMap;
import java.util.Map;
import org.schicwp.dinky.model.ContentMap;
import org.schicwp.dinky.model.Permission;
import org.schicwp.dinky.workflow.ActionHook;
import org.schicwp.dinky.workflow.ActionHookFactory;
import org.springframework.stereotype.Component;

@Component
public class SetPermissions
implements ActionHookFactory {
    @Override
    public String getName() {
        return "SetPermissions";
    }

    @Override
    public ActionHook createActionHook(ContentMap config) {
        return (content, actionConfig) -> {
            Permission _owner = this.fromObject(actionConfig.getOrDefault("owner", config.getOrDefault("owner", null)));
            Permission _other = this.fromObject(actionConfig.getOrDefault("other", config.getOrDefault("other", null)));
            Permission _assignee = this.fromObject(actionConfig.getOrDefault("assignee", config.getOrDefault("assignee", null)));
            if (_owner != null) {
                content.getPermissions().setOwner(_owner);
            }
            if (_other != null) {
                content.getPermissions().setOther(_other);
            }
            if (_assignee != null) {
                content.getPermissions().setAssignee(_assignee);
            }
            Map<String, Permission> group = this.fromMap(config.get("group"));
            Map<String, Permission> _group = this.fromMap(actionConfig.get("group"));
            group.forEach((s, permission) -> content.getPermissions().getGroup().put((String)s, (Permission)permission));
            _group.forEach((s, permission) -> content.getPermissions().getGroup().put((String)s, (Permission)permission));
        };
    }

    private Map<String, Permission> fromMap(Object o) {
        Map groupConfig = (Map)o;
        HashMap<String, Permission> group = new HashMap<String, Permission>();
        if (groupConfig != null) {
            groupConfig.forEach((k, v) -> group.put((String)k, this.fromObject(v)));
        }
        return group;
    }

    Permission fromObject(Object o) {
        if (o == null) {
            return null;
        }
        Map map = (Map)o;
        return new Permission((Boolean)map.get("read"), (Boolean)map.get("write"));
    }
}

