/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky;

import java.util.Arrays;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import nz.net.ultraq.thymeleaf.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.decorators.strategies.GroupingStrategy;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoRepositoriesAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@SpringBootApplication
@EnableScheduling
@EnableWebSecurity
@EnableAutoConfiguration(exclude={MongoRepositoriesAutoConfiguration.class})
@EnableMongoRepositories(basePackages={"org/schicwp/dinky/persistence"})
public class Main {
    public static void main(String[] args) {
        SpringApplication.run(Main.class, (String[])args);
    }

    @Bean
    public CommandLineRunner commandLineRunner(ApplicationContext ctx) {
        return args -> {
            System.out.println("Let's inspect the beans provided by Spring Boot:");
            Object[] beanNames = ctx.getBeanDefinitionNames();
            Arrays.sort(beanNames);
            for (Object beanName : beanNames) {
                System.out.println((String)beanName);
            }
        };
    }

    @Bean
    FileTemplateResolver templateResolver() {
        FileTemplateResolver fileTemplateResolver = new FileTemplateResolver();
        fileTemplateResolver.setCacheable(false);
        fileTemplateResolver.setPrefix("./web/");
        fileTemplateResolver.setSuffix(".html");
        return fileTemplateResolver;
    }

    @Bean
    SpringTemplateEngine templateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.addDialect((IDialect)new LayoutDialect((SortingStrategy)new GroupingStrategy()));
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver());
        return templateEngine;
    }
}

