/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.schicwp.dinky.content.ContentService;
import org.schicwp.dinky.content.PermissionService;
import org.schicwp.dinky.exceptions.PermissionException;
import org.schicwp.dinky.model.Content;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/assets"})
public class AssetResource {
    @Autowired
    GridFsTemplate gridFsTemplate;
    @Autowired
    PermissionService permissionService;
    @Autowired
    ContentService contentService;

    @GetMapping(value={"{id}"})
    void getAsset(@PathVariable(value="id") String id, HttpServletResponse response) throws IOException {
        int read;
        GridFSFile file = this.gridFsTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)));
        Content content = this.contentService.findById(file.getMetadata().getString((Object)"contentId")).orElseThrow(NoSuchElementException::new);
        if (!this.permissionService.allowRead(content)) {
            throw new PermissionException();
        }
        response.addHeader("Content-Type", file.getMetadata().getString((Object)"contentType"));
        InputStream out = this.gridFsTemplate.getResource(Objects.requireNonNull(file).getFilename()).getInputStream();
        byte[] buffer = new byte[1024];
        while ((read = out.read(buffer)) >= 0) {
            response.getOutputStream().write(buffer, 0, read);
        }
    }
}

