/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import java.util.Collection;
import java.util.logging.Logger;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.schicwp.dinky.auth.AuthService;
import org.schicwp.dinky.content.ContentService;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.ContentHistory;
import org.schicwp.dinky.persistence.ContentHistoryRepository;
import org.schicwp.dinky.search.SearchContent;
import org.schicwp.dinky.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/search"})
public class SearchResource {
    private static final Logger logger = Logger.getLogger(SearchResource.class.getCanonicalName());
    @Autowired
    ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    ContentService contentService;
    @Autowired
    ContentHistoryRepository contentHistoryRepository;
    @Autowired
    AuthService authService;
    @Autowired
    SearchService searchService;

    @GetMapping(value={"{index}"})
    public Page<SearchContent> search(@PathVariable(value="index") String index, @RequestParam(value="q") String q, @PageableDefault(sort={"modified"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return this.searchService.search(index, (QueryBuilder)QueryBuilders.queryStringQuery((String)q), pageable);
    }

    @DeleteMapping(value={"{index}"})
    public void rebuildIndex(@PathVariable(value="index") String index) {
        this.authService.withSystemUser(() -> {
            Page<Content> content;
            logger.info("Rebuilding index: [" + index + "]");
            this.elasticsearchTemplate.deleteIndex(index);
            long count = 0L;
            int i = 0;
            do {
                content = this.contentService.find(Query.query((CriteriaDefinition)Criteria.where((String)("searchVersions." + index)).ne(null)), (Pageable)PageRequest.of((int)i++, (int)100));
                logger.info("Re-indexing [" + content.getContent().size() + "] items");
                count += (long)content.getContent().size();
                content.forEach(c -> {
                    ContentHistory contentHistory = this.contentHistoryRepository.findByContentIdAndContentVersion(c.getId(), c.getSearchVersions().get(index));
                    this.searchService.addToIndex(index, new SearchContent(contentHistory.getContent()));
                });
            } while (!content.isLast());
            logger.info("Re-indexed [" + count + "] total items");
        });
    }

    @GetMapping
    public Collection<String> getIndexes() {
        return this.searchService.getIndexes();
    }
}

