/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.api;

import java.util.List;
import java.util.NoSuchElementException;
import org.schicwp.dinky.config.WorkflowConfig;
import org.schicwp.dinky.config.loader.WorkflowLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/workflow"})
public class WorkflowResource {
    @Autowired
    WorkflowLoader workflowLoader;

    @GetMapping
    public Page<WorkflowConfig> listContentTypes() {
        List<WorkflowConfig> workflowConfigs = this.workflowLoader.getWorkflowConfigs();
        return PageableExecutionUtils.getPage(workflowConfigs, (Pageable)PageRequest.of((int)0, (int)workflowConfigs.size()), workflowConfigs::size);
    }

    @GetMapping(value={"{name}"})
    public WorkflowConfig getContentType(@PathVariable(value="name") String name) {
        List<WorkflowConfig> workflowConfigs = this.workflowLoader.getWorkflowConfigs();
        return workflowConfigs.stream().filter(w -> w.getName().equals(name)).findFirst().orElseThrow(NoSuchElementException::new);
    }
}

