/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.content;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Logger;
import org.schicwp.dinky.auth.AuthService;
import org.schicwp.dinky.auth.User;
import org.schicwp.dinky.content.PermissionService;
import org.schicwp.dinky.content.QueryTotalCache;
import org.schicwp.dinky.exceptions.PermissionException;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.ContentHistory;
import org.schicwp.dinky.persistence.ContentHistoryRepository;
import org.schicwp.dinky.persistence.ContentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContentService {
    private static final Logger logger = Logger.getLogger(ContentService.class.getCanonicalName());
    @Autowired
    ContentRepository contentRepository;
    @Autowired
    ContentHistoryRepository contentHistoryRepository;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    PermissionService permissionService;
    @Autowired
    QueryTotalCache queryTotalCache;
    @Autowired
    AuthService authService;

    @Transactional
    Content save(Content content) {
        this.queryTotalCache.invalidate();
        this.contentHistoryRepository.save(new ContentHistory(content));
        return (Content)this.contentRepository.save(content);
    }

    public Page<Content> getHistory(String id, Pageable pageable) {
        if (!this.findById(id).isPresent()) {
            throw new NoSuchElementException("No such element");
        }
        return this.contentHistoryRepository.findAllByContentIdOrderByContentVersionDesc(id, pageable).map(ContentHistory::getContent);
    }

    public Content getHistoricalVersion(String id, int version) {
        if (!this.findById(id).isPresent()) {
            throw new NoSuchElementException("No such element");
        }
        return this.contentHistoryRepository.findByContentIdAndContentVersion(id, version).getContent();
    }

    @Transactional
    public Content revertToHistoricalVersion(String id, int version) {
        if (!this.findById(id).isPresent()) {
            throw new NoSuchElementException("No such element");
        }
        Content oldVersion = this.contentHistoryRepository.findByContentIdAndContentVersion(id, version).getContent();
        Content currentVersion = (Content)this.contentRepository.findById(id).orElseThrow(NoSuchElementException::new);
        if (!this.permissionService.allowWrite(currentVersion)) {
            throw new PermissionException();
        }
        logger.info(String.format("Reverting %s to %s", currentVersion, oldVersion));
        oldVersion.setVersion(currentVersion.getVersion() + 1);
        return this.save(oldVersion);
    }

    public Optional<Content> findById(String s) {
        Optional byId = this.contentRepository.findById(s);
        if (byId.isPresent() && !this.permissionService.allowRead((Content)byId.get())) {
            throw new PermissionException();
        }
        return byId;
    }

    public Page<Content> find(Query query, Pageable pageable) {
        Query finalQuery = this.getPermissionAwareQuery(query, pageable);
        return PageableExecutionUtils.getPage((List)this.mongoTemplate.find(finalQuery, Content.class), (Pageable)pageable, () -> this.queryTotalCache.getCountForQuery(finalQuery));
    }

    private Query getPermissionAwareQuery(Query query, Pageable pageable) {
        Criteria permissionFilter = this.permissionService.getPermissionFilter();
        return query == null ? Query.query((CriteriaDefinition)permissionFilter).with(pageable) : query.addCriteria((CriteriaDefinition)permissionFilter).with(pageable);
    }

    public Page<Content> findAssigned(Query query, Pageable pageable) {
        Query finalQuery = this.getPermissionAwareQuery(query, pageable);
        return PageableExecutionUtils.getPage((List)this.mongoTemplate.find(finalQuery, Content.class), (Pageable)pageable, () -> this.queryTotalCache.getCountForQuery(finalQuery));
    }

    public Page<Content> findMine(Query query, Pageable pageable) {
        Query finalQuery = this.getPermissionAwareQuery(query, pageable);
        return PageableExecutionUtils.getPage((List)this.mongoTemplate.find(finalQuery, Content.class), (Pageable)pageable, () -> this.queryTotalCache.getCountForQuery(finalQuery));
    }

    public long count(Query query) {
        return this.queryTotalCache.getCountForQuery(query.addCriteria((CriteriaDefinition)this.permissionService.getPermissionFilter()));
    }

    public long countAssigned(Query query) {
        return this.queryTotalCache.getCountForQuery(query.addCriteria((CriteriaDefinition)this.getAssignedPermissionFilter()));
    }

    public long countOwned(Query query) {
        return this.queryTotalCache.getCountForQuery(query.addCriteria((CriteriaDefinition)this.getOwnedPermissionFilter()));
    }

    private Criteria getAssignedPermissionFilter() {
        User user = this.authService.getCurrentUser();
        return new Criteria().andOperator(new Criteria[]{this.permissionService.getPermissionFilter(), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"assignedUser").is((Object)user.getUsername()), Criteria.where((String)"assignedGroup").in(user.getGroups())})});
    }

    private Criteria getOwnedPermissionFilter() {
        User user = this.authService.getCurrentUser();
        return new Criteria().andOperator(new Criteria[]{this.permissionService.getPermissionFilter(), Criteria.where((String)"owner").is((Object)user.getUsername())});
    }
}

