/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.content;

import java.util.List;
import java.util.stream.Collectors;
import org.schicwp.dinky.auth.AuthService;
import org.schicwp.dinky.auth.User;
import org.schicwp.dinky.model.Content;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
public class PermissionService {
    @Autowired
    AuthService authService;

    public boolean allowRead(Content content) {
        User user = this.authService.getCurrentUser();
        if (user.isSystemUser()) {
            return true;
        }
        if (content.getPermissions().getOther().isRead()) {
            return true;
        }
        if (user.getUsername().equals(content.getOwner()) && content.getPermissions().getOwner().isRead()) {
            return true;
        }
        if (user.getUsername().equals(content.getAssignedUser()) && content.getPermissions().getAssignee().isRead()) {
            return true;
        }
        for (String group : user.getGroups()) {
            if (group.equals(content.getAssignedGroup()) && content.getPermissions().getAssignee().isRead()) {
                return true;
            }
            if (!content.getPermissions().getGroup().containsKey(group) || !content.getPermissions().getGroup().get(group).isRead()) continue;
            return true;
        }
        return false;
    }

    public boolean allowWrite(Content content) {
        User user = this.authService.getCurrentUser();
        if (user.isSystemUser()) {
            return true;
        }
        if (content.getPermissions().getOther().isWrite()) {
            return true;
        }
        if (user.getUsername().equals(content.getOwner()) && content.getPermissions().getOwner().isWrite()) {
            return true;
        }
        if (user.getUsername().equals(content.getAssignedUser()) && content.getPermissions().getAssignee().isWrite()) {
            return true;
        }
        for (String group : user.getGroups()) {
            if (group.equals(content.getAssignedGroup()) && content.getPermissions().getAssignee().isWrite()) {
                return true;
            }
            if (!content.getPermissions().getGroup().containsKey(group) || !content.getPermissions().getGroup().get(group).isWrite()) continue;
            return true;
        }
        return false;
    }

    public Criteria getPermissionFilter() {
        User user = this.authService.getCurrentUser();
        if (user.isSystemUser()) {
            return new Criteria();
        }
        List<Criteria> criteria = user.getGroups().stream().map(s -> Criteria.where((String)("permissions.group." + s + ".read")).is((Object)true)).collect(Collectors.toList());
        criteria.add(Criteria.where((String)"owner").is((Object)user.getUsername()).and("permissions.owner.read").is((Object)true));
        criteria.add(Criteria.where((String)"permissions.assignee.read").is((Object)true).orOperator(new Criteria[]{Criteria.where((String)"assignedUser").is((Object)user.getUsername()), Criteria.where((String)"assignedGroup").in(user.getGroups())}));
        criteria.add(Criteria.where((String)"permissions.other.read").is((Object)true));
        return new Criteria().orOperator(criteria.toArray(new Criteria[0]));
    }
}

