/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.model.type;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.schicwp.dinky.model.type.FieldType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class FieldTypeService {
    private static final Logger logger = Logger.getLogger(FieldTypeService.class.getCanonicalName());
    @Autowired
    private ApplicationContext applicationContext;
    Map<String, FieldType> fieldTypeFactoryHashMap = new HashMap<String, FieldType>();

    @PostConstruct
    public void init() {
        this.applicationContext.getBeansOfType(FieldType.class).forEach((k, f) -> {
            logger.info("Registering FieldType: " + f.getName());
            this.fieldTypeFactoryHashMap.put(f.getName().toLowerCase(), (FieldType)f);
        });
    }

    public FieldType getFieldType(String name) {
        if (!this.fieldTypeFactoryHashMap.containsKey(name.toLowerCase())) {
            throw new IllegalArgumentException("Unkown field type: " + name);
        }
        return this.fieldTypeFactoryHashMap.get(name.toLowerCase());
    }
}

